/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.EntryFetcher;
import net.sf.jabref.imports.ImportInspector;
import net.sf.jabref.imports.MedlineImporter;

public class MedlineFetcher
implements EntryFetcher {
    private static final int PACING = 20;
    private boolean shouldContinue;
    OutputPrinter frame;
    ImportInspector dialog;

    private String toSearchTerm(String string) {
        Pattern pattern = Pattern.compile(", ");
        Pattern pattern2 = Pattern.compile(",");
        Pattern pattern3 = Pattern.compile(" ");
        Matcher matcher = pattern.matcher(string);
        string = matcher.replaceAll("\\+AND\\+");
        matcher = pattern2.matcher(string);
        string = matcher.replaceAll("\\+AND\\+");
        matcher = pattern3.matcher(string);
        string = matcher.replaceAll("+");
        return string;
    }

    private SearchResult getIds(String string, int n, int n2) {
        String string2 = "http://eutils.ncbi.nlm.nih.gov/entrez/eutils";
        String string3 = string2 + "/esearch.fcgi?db=pubmed&retmax=" + Integer.toString(n2) + "&retstart=" + Integer.toString(n) + "&term=";
        Pattern pattern = Pattern.compile("<Id>(\\d+)</Id>");
        Pattern pattern2 = Pattern.compile("<Count>(\\d+)<\\/Count>");
        Pattern pattern3 = Pattern.compile("<RetMax>(\\d+)<\\/RetMax>");
        Pattern pattern4 = Pattern.compile("<RetStart>(\\d+)<\\/RetStart>");
        boolean bl = true;
        SearchResult searchResult = new SearchResult();
        try {
            String string4;
            URL uRL = new URL(string3 + string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            while ((string4 = bufferedReader.readLine()) != null) {
                Matcher matcher;
                Matcher matcher2;
                Matcher matcher3 = pattern.matcher(string4);
                if (matcher3.find()) {
                    searchResult.addID(matcher3.group(1));
                }
                if ((matcher2 = pattern3.matcher(string4)).find()) {
                    searchResult.retmax = Integer.parseInt(matcher2.group(1));
                }
                if ((matcher = pattern4.matcher(string4)).find()) {
                    searchResult.retstart = Integer.parseInt(matcher.group(1));
                }
                Matcher matcher4 = pattern2.matcher(string4);
                if (!bl || !matcher4.find()) continue;
                searchResult.count = Integer.parseInt(matcher4.group(1));
                bl = false;
            }
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("bad url");
            malformedURLException.printStackTrace();
        }
        catch (IOException iOException) {
            System.out.println("connection failed");
            iOException.printStackTrace();
        }
        return searchResult;
    }

    @Override
    public void stopFetching() {
        this.shouldContinue = false;
    }

    @Override
    public String getHelpPage() {
        return "MedlineHelp.html";
    }

    @Override
    public String getKeyName() {
        return "Medline";
    }

    @Override
    public JPanel getOptionsPanel() {
        return null;
    }

    @Override
    public String getTitle() {
        return "Medline";
    }

    @Override
    public boolean processQuery(String string, ImportInspector importInspector, OutputPrinter outputPrinter) {
        this.shouldContinue = true;
        if ((string = string.trim().replace(';', ',')).matches("\\d+[,\\d+]*")) {
            outputPrinter.setStatus(Globals.lang("Fetching Medline by id..."));
            List<BibtexEntry> list = MedlineImporter.fetchMedline(string, outputPrinter);
            if (list.size() == 0) {
                outputPrinter.showMessage(Globals.lang("No references found"));
            }
            for (BibtexEntry bibtexEntry : list) {
                importInspector.addEntry(bibtexEntry);
            }
            return true;
        }
        if (string.length() > 0) {
            outputPrinter.setStatus(Globals.lang("Fetching Medline by term..."));
            String string2 = this.toSearchTerm(string);
            SearchResult searchResult = this.getIds(string2, 0, 1);
            if (searchResult.count == 0) {
                outputPrinter.showMessage(Globals.lang("No references found"));
                return false;
            }
            int n = searchResult.count;
            if (n > 20) {
                while (true) {
                    String string3;
                    if ((string3 = JOptionPane.showInputDialog(Globals.lang("References found") + ": " + n + "  " + Globals.lang("Number of references to fetch?"), (Object)Integer.toString(n))) == null) {
                        outputPrinter.setStatus(Globals.lang("Medline import canceled"));
                        return false;
                    }
                    try {
                        n = Integer.parseInt(string3.trim());
                    }
                    catch (RuntimeException runtimeException) {
                        outputPrinter.showMessage(Globals.lang("Please enter a valid number"));
                        continue;
                    }
                    break;
                }
            }
            for (int i = 0; i < n && this.shouldContinue; i += 20) {
                int n2 = Math.min(20, n - i);
                searchResult = this.getIds(string2, i, n2);
                List<BibtexEntry> list = MedlineImporter.fetchMedline(searchResult.ids, outputPrinter);
                for (BibtexEntry bibtexEntry : list) {
                    importInspector.addEntry(bibtexEntry);
                }
                importInspector.setProgress(i + n2, n);
            }
            return true;
        }
        outputPrinter.showMessage(Globals.lang("Please enter a comma separated list of Medline IDs (numbers) or search terms."), Globals.lang("Input error"), 0);
        return false;
    }

    class SearchResult {
        public int count = 0;
        public int retmax = 0;
        public int retstart = 0;
        public String ids = "";

        SearchResult() {
        }

        public void addID(String string) {
            this.ids = this.ids.equals("") ? string : this.ids + "," + string;
        }
    }
}

