/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;

public class MedlinePlainImporter
extends ImportFormat {
    @Override
    public String getFormatName() {
        return "MedlinePlain";
    }

    @Override
    public String getCLIId() {
        return "medlineplain";
    }

    @Override
    public boolean isRecognizedFormat(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        Pattern pattern = Pattern.compile("PMID.*-.*");
        Pattern pattern2 = Pattern.compile("PMC.*-.*");
        Pattern pattern3 = Pattern.compile("PMCR.*-.*");
        while ((string = bufferedReader.readLine()) != null) {
            if (!pattern.matcher(string).find() && !pattern2.matcher(string).find() && !pattern3.matcher(string).find()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<BibtexEntry> importEntries(InputStream inputStream, OutputPrinter outputPrinter) throws IOException {
        String[] stringArray;
        String string;
        ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string);
            stringBuilder.append("\n");
        }
        for (String string2 : stringArray = stringBuilder.toString().replaceAll("\u2013", "-").replaceAll("\u2014", "--").replaceAll("\u2015", "--").split("\\n\\n")) {
            String string3;
            Object object3;
            Serializable serializable;
            if (string2.trim().length() == 0) continue;
            String string4 = "";
            String string5 = "";
            String string6 = "";
            String string7 = "";
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String[] stringArray2 = string2.split("\n");
            for (int i = 0; i < stringArray2.length; ++i) {
                Object object2;
                if (stringArray2[i].equals("")) continue;
                serializable = new StringBuilder(stringArray2[i]);
                boolean bl = false;
                while (!bl && i < stringArray2.length - 1) {
                    if (stringArray2[i + 1].length() <= 4) {
                        System.out.println("aaa");
                    }
                    if (stringArray2[i + 1].charAt(4) != '-') {
                        if (((StringBuilder)serializable).length() > 0 && !Character.isWhitespace(((StringBuilder)serializable).charAt(((StringBuilder)serializable).length() - 1))) {
                            ((StringBuilder)serializable).append(' ');
                        }
                        ((StringBuilder)serializable).append(stringArray2[i + 1].trim());
                        ++i;
                        continue;
                    }
                    bl = true;
                }
                object3 = ((StringBuilder)serializable).toString();
                string3 = ((String)object3).substring(0, ((String)object3).indexOf(45)).trim();
                String string8 = ((String)object3).substring(((String)object3).indexOf(45) + 1).trim();
                if (string3.equals("PT")) {
                    if ((string8 = string8.toLowerCase()).equals("BOOK")) {
                        string4 = "book";
                        continue;
                    }
                    if (string8.equals("journal article") || string8.equals("classical article") || string8.equals("corrected and republished article") || string8.equals("historical article") || string8.equals("introductory journal article") || string8.equals("newspaper article")) {
                        string4 = "article";
                        continue;
                    }
                    if (string8.equals("clinical conference") || string8.equals("consensus development conference") || string8.equals("consensus development conference, NIH")) {
                        string4 = "conference";
                        continue;
                    }
                    if (string8.equals("technical report")) {
                        string4 = "techreport";
                        continue;
                    }
                    if (string8.equals("editorial")) {
                        string4 = "inproceedings";
                        continue;
                    }
                    if (string8.equals("overall")) {
                        string4 = "proceedings";
                        continue;
                    }
                    if (!string4.equals("")) continue;
                    string4 = "other";
                    continue;
                }
                if (string3.equals("TI")) {
                    object2 = hashMap.get("title");
                    if (object2 == null) {
                        hashMap.put("title", string8);
                        continue;
                    }
                    if (((String)object2).endsWith(":") || ((String)object2).endsWith(".") || ((String)object2).endsWith("?")) {
                        hashMap.put("title", (String)object2 + " " + string8);
                        continue;
                    }
                    hashMap.put("title", (String)object2 + ": " + string8);
                    continue;
                }
                if (string3.equals("BTI") || string3.equals("CTI")) {
                    hashMap.put("booktitle", string8);
                    continue;
                }
                if (string3.equals("FAU")) {
                    if (string5.equals("")) {
                        string5 = string8;
                        continue;
                    }
                    string5 = string5 + " and " + string8;
                    continue;
                }
                if (string3.equals("FED")) {
                    if (string6.equals("")) {
                        string6 = string8;
                        continue;
                    }
                    string6 = string6 + " and " + string8;
                    continue;
                }
                if (string3.equals("JT")) {
                    if (string4.equals("inproceedings")) {
                        hashMap.put("booktitle", string8);
                        continue;
                    }
                    hashMap.put("journal", string8);
                    continue;
                }
                if (string3.equals("PG")) {
                    hashMap.put("pages", string8);
                    continue;
                }
                if (string3.equals("PL")) {
                    hashMap.put("address", string8);
                    continue;
                }
                if (string3.equals("IS")) {
                    hashMap.put("issn", string8);
                    continue;
                }
                if (string3.equals("VI")) {
                    hashMap.put("volume", string8);
                    continue;
                }
                if (string3.equals("AB")) {
                    object2 = hashMap.get("abstract");
                    if (object2 == null) {
                        hashMap.put("abstract", string8);
                        continue;
                    }
                    hashMap.put("abstract", (String)object2 + "\n" + string8);
                    continue;
                }
                if (string3.equals("DP")) {
                    object2 = string8.split(" ");
                    hashMap.put("year", object2[0]);
                    if (((String[])object2).length <= 1 || object2[1].length() <= 0) continue;
                    hashMap.put("month", object2[1]);
                    continue;
                }
                if (string3.equals("MH") || string3.equals("OT")) {
                    if (!hashMap.containsKey("keywords")) {
                        hashMap.put("keywords", string8);
                        continue;
                    }
                    object2 = hashMap.get("keywords");
                    hashMap.put("keywords", (String)object2 + ", " + string8);
                    continue;
                }
                if (string3.equals("CON") || string3.equals("CIN") || string3.equals("EIN") || string3.equals("EFR") || string3.equals("CRI") || string3.equals("CRF") || string3.equals("PRIN") || string3.equals("PROF") || string3.equals("RPI") || string3.equals("RPF") || string3.equals("RIN") || string3.equals("ROF") || string3.equals("UIN") || string3.equals("UOF") || string3.equals("SPIN") || string3.equals("ORI")) {
                    if (string7.length() > 0) {
                        string7 = string7 + "\n";
                    }
                    string7 = string7 + string8;
                    continue;
                }
                if (!string3.equals("AID") || !((String)(object2 = string8)).startsWith("doi:")) continue;
                object2 = ((String)object2).replaceAll("(?i)doi:", "").trim();
                hashMap.put("doi", (String)object2);
            }
            if (string5.length() > 0) {
                string5 = AuthorList.fixAuthor_lastNameFirst(string5);
                hashMap.put("author", string5);
            }
            if (string6.length() > 0) {
                string6 = AuthorList.fixAuthor_lastNameFirst(string6);
                hashMap.put("editor", string6);
            }
            if (string7.length() > 0) {
                hashMap.put("comment", string7);
            }
            BibtexEntry bibtexEntry = new BibtexEntry("__ID", Globals.getEntryType(string4));
            serializable = new ArrayList();
            for (Object object3 : hashMap.keySet()) {
                string3 = (String)hashMap.get(object3);
                if (string3 != null && string3.trim().length() != 0) continue;
                ((ArrayList)serializable).add(object3);
            }
            Iterator<Object> iterator = ((ArrayList)serializable).iterator();
            while (iterator.hasNext()) {
                object3 = iterator.next();
                hashMap.remove(object3);
            }
            bibtexEntry.setField(hashMap);
            arrayList.add(bibtexEntry);
        }
        return arrayList;
    }
}

