/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;
import javax.swing.JPanel;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryTypes;
import net.sf.jabref.Globals;
import net.sf.jabref.IdGenerator;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.EntryFetcher;
import net.sf.jabref.imports.ImportInspector;
import net.sf.jabref.imports.OAI2Handler;
import net.sf.jabref.util.MonthUtil;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OAI2Fetcher
implements EntryFetcher {
    private static final String OAI2_ARXIV_PREFIXIDENTIFIER = "oai%3AarXiv.org%3A";
    private static final String OAI2_ARXIV_HOST = "export.arxiv.org";
    private static final String OAI2_ARXIV_SCRIPT = "oai2";
    private static final String OAI2_ARXIV_METADATAPREFIX = "arXiv";
    private static final String OAI2_ARXIV_ARCHIVENAME = "ArXiv.org";
    private static final String OAI2_IDENTIFIER_FIELD = "oai2identifier";
    private SAXParser saxParser;
    private final String oai2Host;
    private final String oai2Script;
    private final String oai2MetaDataPrefix;
    private final String oai2PrefixIdentifier;
    private final String oai2ArchiveName;
    private boolean shouldContinue = true;
    private OutputPrinter status;
    private long waitTime = -1L;
    private Date lastCall;

    private boolean shouldWait() {
        return this.waitTime > 0L;
    }

    public OAI2Fetcher(String string, String string2, String string3, String string4, String string5, long l) {
        this.oai2Host = string;
        this.oai2Script = string2;
        this.oai2MetaDataPrefix = string3;
        this.oai2PrefixIdentifier = string4;
        this.oai2ArchiveName = string5;
        this.waitTime = l;
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            this.saxParser = sAXParserFactory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
    }

    public OAI2Fetcher() {
        this(OAI2_ARXIV_HOST, OAI2_ARXIV_SCRIPT, OAI2_ARXIV_METADATAPREFIX, OAI2_ARXIV_PREFIXIDENTIFIER, OAI2_ARXIV_ARCHIVENAME, 20000L);
    }

    public String constructUrl(String string) {
        String string2;
        try {
            string2 = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
        return "http://" + this.oai2Host + "/" + this.oai2Script + "?" + "verb=GetRecord" + "&identifier=" + this.oai2PrefixIdentifier + string2 + "&metadataPrefix=" + this.oai2MetaDataPrefix;
    }

    public static String fixKey(String string) {
        if (string.toLowerCase().startsWith("arxiv:")) {
            string = string.substring(6);
        }
        int n = string.indexOf(46);
        int n2 = string.indexOf(47);
        if (n > -1 && n < n2) {
            string = string.substring(0, n) + string.substring(n2, string.length());
        }
        return string;
    }

    public static String correctLineBreaks(String string) {
        string = string.replaceAll("\\n(?!\\s*\\n)", " ");
        string = string.replaceAll("\\s*\\n\\s*", "\n");
        return string.replaceAll(" {2,}", " ").replaceAll("(^\\s*|\\s+$)", "");
    }

    public BibtexEntry importOai2Entry(String string) {
        string = OAI2Fetcher.fixKey(string);
        String string2 = this.constructUrl(string);
        try {
            URL uRL = new URL(string2);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestProperty("User-Agent", "Jabref");
            InputStream inputStream = httpURLConnection.getInputStream();
            BibtexEntry bibtexEntry = new BibtexEntry(IdGenerator.next(), BibtexEntryTypes.ARTICLE);
            bibtexEntry.setField(OAI2_IDENTIFIER_FIELD, string);
            OAI2Handler oAI2Handler = new OAI2Handler(bibtexEntry);
            this.saxParser.parse(inputStream, (DefaultHandler)oAI2Handler);
            for (String object : bibtexEntry.getAllFields()) {
                bibtexEntry.setField(object, OAI2Fetcher.correctLineBreaks(bibtexEntry.getField(object)));
            }
            if (string.matches("\\d\\d\\d\\d\\..*")) {
                bibtexEntry.setField("year", "20" + string.substring(0, 2));
                int n = Integer.parseInt(string.substring(2, 4));
                MonthUtil.Month month = MonthUtil.getMonthByNumber(n);
                if (month.isValid()) {
                    bibtexEntry.setField("month", month.bibtexFormat);
                }
            }
            return bibtexEntry;
        }
        catch (IOException iOException) {
            this.status.showMessage(Globals.lang("An Exception ocurred while accessing '%0'", string2) + "\n\n" + iOException.toString(), Globals.lang(this.getKeyName()), 0);
        }
        catch (SAXException sAXException) {
            this.status.showMessage(Globals.lang("An SAXException ocurred while parsing '%0':", new String[]{string2}) + "\n\n" + sAXException.getMessage(), Globals.lang(this.getKeyName()), 0);
        }
        catch (RuntimeException runtimeException) {
            this.status.showMessage(Globals.lang("An Error occurred while fetching from OAI2 source (%0):", new String[]{string2}) + "\n\n" + runtimeException.getMessage(), Globals.lang(this.getKeyName()), 0);
        }
        return null;
    }

    @Override
    public String getHelpPage() {
        return null;
    }

    @Override
    public String getKeyName() {
        return this.oai2ArchiveName;
    }

    @Override
    public JPanel getOptionsPanel() {
        return null;
    }

    @Override
    public String getTitle() {
        return Globals.menuTitle(this.getKeyName());
    }

    @Override
    public boolean processQuery(String string, ImportInspector importInspector, OutputPrinter outputPrinter) {
        this.status = outputPrinter;
        try {
            this.shouldContinue = true;
            string = string.replaceAll(" ", ";");
            String[] stringArray = string.split(";");
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (this.shouldWait() && this.lastCall != null) {
                    long l = new Date().getTime() - this.lastCall.getTime();
                    while (l < this.waitTime) {
                        outputPrinter.setStatus(Globals.lang("Waiting for ArXiv...") + (this.waitTime - l) / 1000L + " s");
                        Thread.sleep(1000L);
                        l = new Date().getTime() - this.lastCall.getTime();
                    }
                }
                outputPrinter.setStatus(Globals.lang("Processing ") + string2);
                if (!this.shouldContinue) break;
                BibtexEntry bibtexEntry = this.importOai2Entry(string2);
                if (this.shouldWait()) {
                    this.lastCall = new Date();
                }
                if (bibtexEntry != null) {
                    importInspector.addEntry(bibtexEntry);
                }
                importInspector.setProgress(i + 1, stringArray.length);
            }
            return true;
        }
        catch (Exception exception) {
            outputPrinter.setStatus(Globals.lang("Error while fetching from OAI2") + ": " + exception.getMessage());
            exception.printStackTrace();
            return false;
        }
    }

    @Override
    public void stopFetching() {
        this.shouldContinue = false;
    }
}

