/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import net.sf.jabref.BibtexEntry;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OAI2Handler
extends DefaultHandler {
    private final BibtexEntry entry;
    private StringBuffer authors;
    private String keyname;
    private String forenames;
    private StringBuffer characters;

    public OAI2Handler(BibtexEntry bibtexEntry) {
        this.entry = bibtexEntry;
    }

    @Override
    public void startDocument() throws SAXException {
        this.authors = new StringBuffer();
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.characters.append(cArray, n, n2);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.characters = new StringBuffer();
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = this.characters.toString();
        if (string3.equals("error")) {
            throw new RuntimeException(string4);
        }
        if (string3.equals("id")) {
            this.entry.setField("eprint", string4);
        } else if (string3.equals("keyname")) {
            this.keyname = string4;
        } else if (string3.equals("forenames")) {
            this.forenames = string4;
        } else if (string3.equals("journal-ref")) {
            String string5 = string4.replaceFirst("[0-9].*", "");
            this.entry.setField("journal", string5);
            String string6 = string4.replaceFirst(string5, "");
            string6 = string6.replaceFirst(" .*", "");
            this.entry.setField("volume", string6);
            String string7 = string4.replaceFirst(".*?\\(", "");
            string7 = string7.replaceFirst("\\).*", "");
            this.entry.setField("year", string7);
            String string8 = string4.replaceFirst(string5, "");
            string8 = string8.replaceFirst(string6, "");
            string8 = string8.replaceFirst("\\(" + string7 + "\\)", "");
            string8 = string8.replaceAll(" ", "");
            this.entry.setField("pages", string8);
        } else if (string3.equals("datestamp")) {
            String string9 = this.entry.getField("year");
            if (string9 == null || string9.equals("")) {
                this.entry.setField("year", string4.replaceFirst("-.*", ""));
            }
        } else if (string3.equals("title")) {
            this.entry.setField("title", string4);
        } else if (string3.equals("abstract")) {
            this.entry.setField("abstract", string4);
        } else if (string3.equals("comments")) {
            this.entry.setField("comments", string4);
        } else if (string3.equals("report-no")) {
            this.entry.setField("reportno", string4);
        } else if (string3.equals("author")) {
            String string10 = this.forenames + " " + this.keyname;
            if (this.authors.length() > 0) {
                this.authors.append(" and ");
            }
            this.authors.append(string10);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.entry.setField("author", this.authors.toString());
    }
}

