/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.BibsonomyScraper;
import net.sf.jabref.imports.EntryFetcher;
import net.sf.jabref.imports.ImportInspector;
import net.sf.jabref.net.URLDownload;

public class ScienceDirectFetcher
implements EntryFetcher {
    private static final int MAX_PAGES_TO_LOAD = 8;
    private static final String WEBSITE_URL = "http://www.sciencedirect.com";
    private static final String SEARCH_URL = "http://www.sciencedirect.com/science/quicksearch?query=";
    private static final String linkPrefix = "http://www.sciencedirect.com/science?_ob=ArticleURL&";
    private static final Pattern linkPattern = Pattern.compile("<a href=\"" + "http://www.sciencedirect.com/science?_ob=ArticleURL&".replaceAll("\\?", "\\\\?") + "([^\"]+)\"\"");
    protected static final Pattern nextPagePattern = Pattern.compile("<a href=\"(.*)\">Next &gt;");
    private boolean stopFetching = false;

    @Override
    public String getHelpPage() {
        return "ScienceDirect.html";
    }

    @Override
    public String getKeyName() {
        return "ScienceDirect";
    }

    @Override
    public JPanel getOptionsPanel() {
        return null;
    }

    @Override
    public String getTitle() {
        return Globals.menuTitle("Search ScienceDirect");
    }

    @Override
    public void stopFetching() {
        this.stopFetching = true;
        boolean bl = false;
    }

    @Override
    public boolean processQuery(String string, ImportInspector importInspector, OutputPrinter outputPrinter) {
        this.stopFetching = false;
        try {
            List<String> list = this.getCitations(string);
            if (list == null) {
                return false;
            }
            if (list.size() == 0) {
                outputPrinter.showMessage(Globals.lang("No entries found for the search string '%0'", string), Globals.lang("Search ScienceDirect"), 1);
                return false;
            }
            int n = 0;
            for (String string2 : list) {
                if (this.stopFetching) break;
                BibtexEntry bibtexEntry = BibsonomyScraper.getEntry(string2);
                if (bibtexEntry != null) {
                    importInspector.addEntry(bibtexEntry);
                }
                importInspector.setProgress(++n, list.size());
            }
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            outputPrinter.showMessage(Globals.lang("Error while fetching from ScienceDirect") + ": " + iOException.getMessage());
            return false;
        }
    }

    private List<String> getCitations(String string) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string2;
            String string3 = SEARCH_URL + URLEncoder.encode(string, "UTF-8");
            for (int i = 1; (string2 = this.getCitationsFromUrl(string3, arrayList)) != null && i < 8; ++i) {
                string3 = string2;
            }
            return arrayList;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    private String getCitationsFromUrl(String string, List<String> list) throws IOException {
        URL uRL = new URL(string);
        String string2 = new URLDownload(uRL).downloadToString();
        Matcher matcher = linkPattern.matcher(string2);
        if (matcher.find()) {
            while (matcher.find()) {
                list.add(linkPrefix + matcher.group(1));
                string2 = string2.substring(matcher.end());
                matcher = linkPattern.matcher(string2);
            }
        } else {
            return null;
        }
        return null;
    }
}

