/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.labelPattern;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.MetaData;
import net.sf.jabref.export.layout.format.RemoveLatexCommands;
import net.sf.jabref.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LabelPatternUtil {
    private static final String CHARS = "abcdefghijklmnopqrstuvwxyz";
    private static final Log LOGGER = LogFactory.getLog(LabelPatternUtil.class);
    public static ArrayList<String> DEFAULT_LABELPATTERN;
    private static BibtexDatabase _db;

    public static void updateDefaultPattern() {
        DEFAULT_LABELPATTERN = LabelPatternUtil.split(JabRefPreferences.getInstance().get("defaultLabelPattern"));
    }

    public static void setDataBase(BibtexDatabase bibtexDatabase) {
        _db = bibtexDatabase;
    }

    private static String normalize(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        String string2 = "";
        String string3 = "";
        for (int i = 0; i < string.length(); ++i) {
            if (n == 0) {
                if (string2.equals("") && string.charAt(i) == ' ' || string2.equals(" ") && string.charAt(i) == 'a' || string2.equals(" a") && string.charAt(i) == 'n' || string2.equals(" an") && string.charAt(i) == 'd') {
                    string2 = string2 + string.charAt(i);
                    continue;
                }
                if (string2.equals(" and") && string.charAt(i) == ' ') {
                    string2 = "";
                    arrayList.add(string3.trim());
                    string3 = "";
                    continue;
                }
                if (string.charAt(i) == '{') {
                    ++n;
                }
                if (string.charAt(i) == '}') {
                    --n;
                }
                string3 = string3 + string2;
                string2 = "";
                string3 = string3 + string.charAt(i);
                continue;
            }
            string3 = string3 + string.charAt(i);
        }
        arrayList.add(string3);
        StringBuilder stringBuilder = new StringBuilder("");
        for (int i = 0; i < arrayList.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(" and ");
            }
            stringBuilder.append(LabelPatternUtil.isInstitution((String)arrayList.get(i)) ? LabelPatternUtil.generateInstitutionKey((String)arrayList.get(i)) : LabelPatternUtil.removeDiacritics((String)arrayList.get(i)));
        }
        return stringBuilder.toString();
    }

    private static String removeDiacritics(String string) {
        if (string == null) {
            return null;
        }
        string = string.replaceAll("\\{\\\\\"([a-zA-Z])\\}", "$1e");
        string = string.replaceAll("\\\\\"\\{([a-zA-Z])\\}", "$1e");
        string = string.replaceAll("\\\\\"([a-zA-Z])", "$1e");
        string = string.replaceAll("\\{\\\\.([a-zA-Z])\\}", "$1");
        string = string.replaceAll("\\\\.\\{([a-zA-Z])\\}", "$1");
        string = string.replaceAll("\\\\.([a-zA-Z])", "$1");
        return string;
    }

    private static String unifyDiacritics(String string) {
        if (string == null) {
            return null;
        }
        return string.replaceAll("\\$\\\\ddot\\{\\\\mathrm\\{([^\\}])\\}\\}\\$", "{\\\"$1}").replaceAll("(\\\\[^\\-a-zA-Z])\\{?([a-zA-Z])\\}?", "{$1$2}");
    }

    private static boolean isInstitution(String string) {
        AuthorList.Author author = AuthorList.getAuthorList(string).getAuthor(0);
        return string.charAt(0) == '{' && string.charAt(string.length() - 1) == '}';
    }

    private static String generateInstitutionKey(String string) {
        if (string == null) {
            return null;
        }
        string = LabelPatternUtil.unifyDiacritics(string);
        List<String> list = Arrays.asList("press", "the");
        string = string.replaceAll("^\\{", "").replaceAll("\\}$", "");
        Pattern pattern = Pattern.compile(".*\\(\\{([A-Z]+)\\}\\).*");
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        string = LabelPatternUtil.removeDiacritics(string);
        String[] stringArray = string.split(",");
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string6 : stringArray[i].replaceAll("\\{[A-Z]+\\}", "").split("[ \\-_]")) {
                if ((string6.equals("") || list.contains(string6.toLowerCase()) || string6.charAt(string6.length() - 1) == '.' || !(string6.charAt(0) + "").matches("[A-Z]")) && (string6.length() < 3 || !string6.toLowerCase().substring(0, 2).equals("uni"))) continue;
                arrayList.add(string6);
            }
            boolean bl = false;
            int n = 0;
            int n2 = 0;
            boolean bl2 = false;
            for (String string7 : arrayList) {
                if (string7.length() >= 5 && string7.toLowerCase().substring(0, 5).equals("univ")) {
                    bl = true;
                }
                if (string7.length() >= 6 && string7.toLowerCase().substring(0, 6).equals("techn")) {
                    n = 1;
                }
                if (string7.toLowerCase().equals("school")) {
                    bl2 = true;
                }
                if ((string7.length() < 7 || !string7.toLowerCase().substring(0, 7).matches("d[ei]part")) && (string7.length() < 4 || !string7.toLowerCase().substring(0, 4).equals("lab"))) continue;
                n2 = 1;
            }
            if (n != 0) {
                bl = false;
            }
            if (bl) {
                string2 = "Uni";
                for (String string7 : arrayList) {
                    if (string7.length() < 5 || string7.toLowerCase().substring(0, 5).equals("univ")) continue;
                    string2 = string2 + string7;
                }
                if (i <= 0 || string3 != null) continue;
                string3 = stringArray[i - 1];
                continue;
            }
            if (bl2 || n2 != 0) {
                if (bl2) {
                    string4 = "";
                }
                if (n2 != 0) {
                    string3 = "";
                }
                for (String string7 : arrayList) {
                    if (string7.length() < 7 || string7.toLowerCase().substring(0, 7).matches("d[ei]part") || string7.toLowerCase().equals("school") || string7.toLowerCase().equals("faculty") || string7.replaceAll("[^A-Z]", "").equals("")) continue;
                    if (bl2) {
                        string4 = string4 + string7.replaceAll("[^A-Z]", "");
                    }
                    if (n2 == 0) continue;
                    string3 = string3 + string7.replaceAll("[^A-Z]", "");
                }
                continue;
            }
            if (string5 != null) continue;
            string5 = "";
            if (arrayList.size() < 3) {
                for (String string7 : arrayList) {
                    string5 = string5 + string7;
                }
                continue;
            }
            for (String string7 : arrayList) {
                if ((string7 = string7.replaceAll("[^A-Z]", "")).equals("")) continue;
                string5 = string5 + string7;
            }
        }
        return (string2 == null ? string5 : string2) + (string4 == null ? "" : string4) + (string3 == null || string4 != null && string3.equals(string4) ? "" : string3);
    }

    public static ArrayList<String> split(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "[]", true);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    public static BibtexEntry makeLabel(MetaData metaData, BibtexDatabase bibtexDatabase, BibtexEntry bibtexEntry) {
        String string;
        int n;
        int n2;
        String string2;
        _db = bibtexDatabase;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        try {
            string2 = bibtexEntry.getType().getName().toLowerCase();
            ArrayList<String> arrayList = metaData.getLabelPattern().getValue(string2);
            int n3 = arrayList.size();
            n2 = 0;
            for (n = 1; n < n3; ++n) {
                String string3 = arrayList.get(n);
                if (string3.equals("[")) {
                    n2 = 1;
                    continue;
                }
                if (string3.equals("]")) {
                    n2 = 0;
                    continue;
                }
                if (n2 != 0) {
                    String[] stringArray = LabelPatternUtil.parseFieldMarker(string3);
                    string = LabelPatternUtil.makeLabel(bibtexEntry, stringArray[0]);
                    if (stringArray.length > 1) {
                        string = LabelPatternUtil.applyModifiers(string, stringArray, 1);
                    }
                    stringBuilder.append(string);
                    continue;
                }
                stringBuilder.append(string3);
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        String string4 = Util.checkLegalKey(stringBuilder.toString());
        string2 = Globals.prefs.get("KeyPatternRegex");
        if (string2 != null && string2.trim().length() > 0) {
            String string5 = Globals.prefs.get("KeyPatternReplacement");
            string4 = string4.replaceAll(string2, string5);
        }
        if (bl) {
            string4 = string4.toUpperCase();
        }
        if (bl2) {
            string4 = string4.toLowerCase();
        }
        String string6 = bibtexEntry.getCiteKey();
        n2 = _db.getNumberOfKeyOccurences(string4);
        if (string6 != null && string6.equals(string4)) {
            --n2;
        }
        n = Globals.prefs.getBoolean("keyGenAlwaysAddLetter") ? 1 : 0;
        boolean bl3 = Globals.prefs.getBoolean("keyGenFirstLetterA");
        if (n == 0 && n2 == 0) {
            if (!string4.equals(string6)) {
                if (_db.getEntryById(bibtexEntry.getId()) == null) {
                    bibtexEntry.setField("bibtexkey", string4);
                } else {
                    _db.setCiteKeyForEntry(bibtexEntry.getId(), string4);
                }
            }
        } else {
            int n4 = 0;
            if (n == 0 && !bl3) {
                n4 = 1;
            }
            string = string4 + LabelPatternUtil.getAddition(n4);
            n2 = _db.getNumberOfKeyOccurences(string);
            if (string6 != null && string6.equals(string)) {
                --n2;
            }
            while (n2 > 0) {
                string = string4 + LabelPatternUtil.getAddition(++n4);
                n2 = _db.getNumberOfKeyOccurences(string);
                if (string6 == null || !string6.equals(string)) continue;
                --n2;
            }
            if (!string.equals(string6)) {
                if (_db.getEntryById(bibtexEntry.getId()) == null) {
                    bibtexEntry.setField("bibtexkey", string);
                } else {
                    _db.setCiteKeyForEntry(bibtexEntry.getId(), string);
                }
            }
        }
        return bibtexEntry;
    }

    public static String applyModifiers(String string, String[] stringArray, int n) {
        if (stringArray.length > n) {
            for (int i = n; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (string2.equals("lower")) {
                    string = string.toLowerCase();
                    continue;
                }
                if (string2.equals("upper")) {
                    string = string.toUpperCase();
                    continue;
                }
                if (string2.equals("abbr")) {
                    String[] stringArray2;
                    StringBuilder stringBuilder = new StringBuilder();
                    for (String string3 : stringArray2 = string.replaceAll("[\\{\\}']", "").split("[\\(\\) \r\n\"]")) {
                        if (string3.length() <= 0) continue;
                        stringBuilder.append(string3.charAt(0));
                    }
                    string = stringBuilder.toString();
                    continue;
                }
                if (string2.startsWith("(") && string2.endsWith(")")) {
                    if (!string.equals("") || string2.length() <= 2) continue;
                    return string2.substring(1, string2.length() - 1);
                }
                LOGGER.info("Key generator warning: unknown modifier '" + string2 + "'.");
            }
        }
        return string;
    }

    public static String makeLabel(BibtexEntry bibtexEntry, String string) {
        try {
            if (string.startsWith("auth") || string.startsWith("pureauth")) {
                String string2 = bibtexEntry.getField("author");
                if (string2 != null) {
                    string2 = LabelPatternUtil.normalize(_db.resolveForStrings(string2));
                }
                if (string.startsWith("pure")) {
                    string = string.substring(4);
                } else if ((string2 == null || string2.equals("")) && (string2 = bibtexEntry.getField("editor")) != null) {
                    string2 = LabelPatternUtil.normalize(_db.resolveForStrings(string2));
                }
                if (string.equals("auth")) {
                    return LabelPatternUtil.firstAuthor(string2);
                }
                if (string.equals("authForeIni")) {
                    return LabelPatternUtil.firstAuthorForenameInitials(string2);
                }
                if (string.equals("authors")) {
                    return LabelPatternUtil.allAuthors(string2);
                }
                if (string.equals("authorsAlpha")) {
                    return LabelPatternUtil.authorsAlpha(string2);
                }
                if (string.equals("authorLast")) {
                    return LabelPatternUtil.lastAuthor(string2);
                }
                if (string.equals("authorLastForeIni")) {
                    return LabelPatternUtil.lastAuthorForenameInitials(string2);
                }
                if (string.equals("authorIni")) {
                    String string3 = LabelPatternUtil.oneAuthorPlusIni(string2);
                    return string3 == null ? "" : string3;
                }
                if (string.matches("authIni[\\d]+")) {
                    int n = Integer.parseInt(string.substring(7));
                    String string4 = LabelPatternUtil.authIniN(string2, n);
                    return string4 == null ? "" : string4;
                }
                if (string.equals("auth.auth.ea")) {
                    String string5 = LabelPatternUtil.authAuthEa(string2);
                    return string5 == null ? "" : string5;
                }
                if (string.equals("auth.etal")) {
                    String string6 = LabelPatternUtil.authEtal(string2, ".", ".etal");
                    return string6 == null ? "" : string6;
                }
                if (string.equals("authEtAl")) {
                    String string7 = LabelPatternUtil.authEtal(string2, "", "EtAl");
                    return string7 == null ? "" : string7;
                }
                if (string.equals("authshort")) {
                    String string8 = LabelPatternUtil.authshort(string2);
                    return string8 == null ? "" : string8;
                }
                if (string.matches("auth[\\d]+_[\\d]+")) {
                    String[] stringArray = string.substring(4).split("_");
                    String string9 = LabelPatternUtil.authN_M(string2, Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]) - 1);
                    return string9 == null ? "" : string9;
                }
                if (string.matches("auth\\d+")) {
                    int n = Integer.parseInt(string.substring(4));
                    String string10 = LabelPatternUtil.firstAuthor(string2);
                    if (string10 == null) {
                        return "";
                    }
                    if (n > string10.length()) {
                        n = string10.length();
                    }
                    return string10.substring(0, n);
                }
                if (string.matches("authors\\d+")) {
                    String string11 = LabelPatternUtil.NAuthors(string2, Integer.parseInt(string.substring(7)));
                    return string11 == null ? "" : string11;
                }
                return LabelPatternUtil.getField(bibtexEntry, string);
            }
            if (string.startsWith("ed")) {
                if (string.equals("edtr")) {
                    return LabelPatternUtil.firstAuthor(bibtexEntry.getField("editor"));
                }
                if (string.equals("edtrForeIni")) {
                    return LabelPatternUtil.firstAuthorForenameInitials(bibtexEntry.getField("editor"));
                }
                if (string.equals("editors")) {
                    return LabelPatternUtil.allAuthors(bibtexEntry.getField("editor"));
                }
                if (string.equals("editorLast")) {
                    return LabelPatternUtil.lastAuthor(bibtexEntry.getField("editor"));
                }
                if (string.equals("editorLastForeIni")) {
                    return LabelPatternUtil.lastAuthorForenameInitials(bibtexEntry.getField("editor"));
                }
                if (string.equals("editorIni")) {
                    String string12 = LabelPatternUtil.oneAuthorPlusIni(bibtexEntry.getField("editor"));
                    return string12 == null ? "" : string12;
                }
                if (string.matches("edtrIni[\\d]+")) {
                    int n = Integer.parseInt(string.substring(7));
                    String string13 = LabelPatternUtil.authIniN(bibtexEntry.getField("editor"), n);
                    return string13 == null ? "" : string13;
                }
                if (string.matches("edtr[\\d]+_[\\d]+")) {
                    String[] stringArray = string.substring(4).split("_");
                    String string14 = LabelPatternUtil.authN_M(bibtexEntry.getField("editor"), Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]) - 1);
                    return string14 == null ? "" : string14;
                }
                if (string.equals("edtr.edtr.ea")) {
                    String string15 = LabelPatternUtil.authAuthEa(bibtexEntry.getField("editor"));
                    return string15 == null ? "" : string15;
                }
                if (string.equals("edtrshort")) {
                    String string16 = LabelPatternUtil.authshort(bibtexEntry.getField("editor"));
                    return string16 == null ? "" : string16;
                }
                if (string.matches("edtr\\d+")) {
                    int n = Integer.parseInt(string.substring(4));
                    String string17 = LabelPatternUtil.firstAuthor(bibtexEntry.getField("editor"));
                    if (string17 == null) {
                        return "";
                    }
                    if (n > string17.length()) {
                        n = string17.length();
                    }
                    return string17.substring(0, n);
                }
                return LabelPatternUtil.getField(bibtexEntry, string);
            }
            if (string.equals("firstpage")) {
                return LabelPatternUtil.firstPage(bibtexEntry.getField("pages"));
            }
            if (string.equals("lastpage")) {
                return LabelPatternUtil.lastPage(bibtexEntry.getField("pages"));
            }
            if (string.equals("shorttitle")) {
                return LabelPatternUtil.getTitleWords(3, bibtexEntry);
            }
            if (string.equals("shortyear")) {
                String string18 = bibtexEntry.getFieldOrAlias("year");
                if (string18.startsWith("in") || string18.startsWith("sub")) {
                    return "IP";
                }
                if (string18.length() > 2) {
                    return string18.substring(string18.length() - 2);
                }
                return string18;
            }
            if (string.equals("veryshorttitle")) {
                return LabelPatternUtil.getTitleWords(1, bibtexEntry);
            }
            if (string.matches("keyword\\d+")) {
                StringBuilder stringBuilder = new StringBuilder();
                int n = Integer.parseInt(string.substring(7));
                String string19 = LabelPatternUtil.getField(bibtexEntry, "keywords");
                if (string19 != null) {
                    String[] stringArray = string19.split("[,;]\\s*");
                    if (n > 0 && n < stringArray.length) {
                        stringBuilder.append(stringArray[n - 1].trim());
                    }
                }
                return stringBuilder.toString();
            }
            return LabelPatternUtil.getField(bibtexEntry, string);
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    private static String getField(BibtexEntry bibtexEntry, String string) {
        String string2 = bibtexEntry.getFieldOrAlias(string);
        return string2 != null ? string2 : "";
    }

    private static String getAddition(int n) {
        if (n >= CHARS.length()) {
            int n2 = n % CHARS.length();
            return LabelPatternUtil.getAddition(n / CHARS.length() - 1) + CHARS.substring(n2, n2 + 1);
        }
        return CHARS.substring(n, n + 1);
    }

    private static String getTitleWords(int n, BibtexEntry bibtexEntry) {
        String string = new RemoveLatexCommands().format(bibtexEntry.getField("title"));
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = 0;
        block0: while (n2 < string.length() && n3 < n) {
            StringBuffer stringBuffer2 = new StringBuffer();
            while (n2 < string.length() && !Character.isWhitespace(string.charAt(n2)) && string.charAt(n2) != '-') {
                stringBuffer2.append(string.charAt(n2));
                ++n2;
            }
            ++n2;
            String string2 = stringBuffer2.toString().trim();
            if (string2.length() == 0) continue;
            for (int i = 0; i < Globals.SKIP_WORDS.length; ++i) {
                if (string2.equalsIgnoreCase(Globals.SKIP_WORDS[i])) continue block0;
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(string2);
            ++n3;
        }
        return LabelPatternUtil.keepLettersAndDigitsOnly(stringBuffer.toString());
    }

    private static String keepLettersAndDigitsOnly(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isLetterOrDigit(string.charAt(i))) continue;
            stringBuilder.append(string.charAt(i));
        }
        return stringBuilder.toString();
    }

    private static boolean isLabelUnique(String string) {
        boolean bl = true;
        int n = _db.getEntryCount();
        for (int i = 0; i < n; ++i) {
            BibtexEntry bibtexEntry = _db.getEntryById(String.valueOf(i));
            if (!bibtexEntry.getField("bibtexkey").equals(string)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static String firstAuthor(String string) {
        AuthorList authorList = AuthorList.getAuthorList(string);
        if (authorList.size() == 0) {
            return "";
        }
        String string2 = authorList.getAuthor(0).getLast();
        return string2 != null ? string2 : "";
    }

    private static String firstAuthorForenameInitials(String string) {
        AuthorList authorList = AuthorList.getAuthorList(string);
        if (authorList.size() == 0) {
            return "";
        }
        String string2 = authorList.getAuthor(0).getFirstAbbr();
        return string2 != null ? string2.substring(0, 1) : "";
    }

    public static String firstAuthorVonAndLast(String string) {
        AuthorList authorList = AuthorList.getAuthorList(string);
        if (authorList.size() == 0) {
            return "";
        }
        String string2 = authorList.getAuthor(0).getVon();
        StringBuilder stringBuilder = new StringBuilder();
        if (string2 != null) {
            stringBuilder.append(string2);
            stringBuilder.append(' ');
        }
        if ((string2 = authorList.getAuthor(0).getLast()) != null) {
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private static String lastAuthor(String string) {
        String[] stringArray = AuthorList.fixAuthorForAlphabetization(string).split("\\band\\b");
        if (stringArray.length > 0) {
            String[] stringArray2 = stringArray[stringArray.length - 1].replaceAll("\\s+", " ").trim().split(" ");
            return stringArray2[0];
        }
        return "";
    }

    private static String lastAuthorForenameInitials(String string) {
        AuthorList authorList = AuthorList.getAuthorList(string);
        if (authorList.size() == 0) {
            return "";
        }
        String string2 = authorList.getAuthor(authorList.size() - 1).getFirstAbbr();
        return string2 != null ? string2.substring(0, 1) : "";
    }

    private static String allAuthors(String string) {
        String string2 = "";
        String[] stringArray = AuthorList.fixAuthorForAlphabetization(string).split("\\band\\b");
        for (int i = 0; stringArray.length > i; ++i) {
            String[] stringArray2 = stringArray[i].replaceAll("\\s+", " ").trim().split(" ");
            string2 = string2 + stringArray2[0];
        }
        return string2;
    }

    private static String authorsAlpha(String string) {
        int n;
        String string2 = "";
        String string3 = AuthorList.fixAuthor_lastNameOnlyCommas(string, false);
        String[] stringArray = (string3 = string3.replace(" and ", ", ")).split(",");
        int n2 = n = stringArray.length > 4 ? 3 : stringArray.length;
        if (n == 1) {
            String[] stringArray2 = stringArray[0].replaceAll("\\s+", " ").trim().split(" ");
            for (int i = 0; i < stringArray2.length - 1; ++i) {
                string2 = string2.concat(stringArray2[i].substring(0, 1));
            }
            string2 = string2.concat(stringArray2[stringArray2.length - 1].substring(0, Math.min(3, stringArray2[stringArray2.length - 1].length())));
        } else {
            for (int i = 0; i < n; ++i) {
                String[] stringArray3;
                for (String string4 : stringArray3 = stringArray[i].replaceAll("\\s+", " ").trim().split(" ")) {
                    string2 = string2.concat(string4.substring(0, 1));
                }
            }
            if (stringArray.length > 4) {
                string2 = string2.concat("+");
            }
        }
        return string2;
    }

    private static String NAuthors(String string, int n) {
        String string2 = "";
        String[] stringArray = AuthorList.fixAuthorForAlphabetization(string).split("\\band\\b");
        for (int i = 0; stringArray.length > i && i < n; ++i) {
            String[] stringArray2 = stringArray[i].replaceAll("\\s+", " ").trim().split(" ");
            string2 = string2 + stringArray2[0];
        }
        if (stringArray.length <= n) {
            return string2;
        }
        return "EtAl";
    }

    private static String oneAuthorPlusIni(String string) {
        string = AuthorList.fixAuthorForAlphabetization(string);
        String string2 = "";
        String[] stringArray = string.split("\\band\\b");
        if (stringArray.length == 0) {
            return string2;
        }
        String[] stringArray2 = stringArray[0].replaceAll("\\s+", " ").split(" ");
        string2 = stringArray2[0].substring(0, Math.min(5, stringArray2[0].length()));
        for (int i = 1; stringArray.length > i; ++i) {
            string2 = string2 + stringArray[i].trim().charAt(0);
        }
        return string2;
    }

    private static String authAuthEa(String string) {
        string = AuthorList.fixAuthorForAlphabetization(string);
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = string.split("\\band\\b");
        if (stringArray.length == 0) {
            return "";
        }
        stringBuilder.append(stringArray[0].split(",")[0]);
        if (stringArray.length >= 2) {
            stringBuilder.append(".").append(stringArray[1].split(",")[0]);
        }
        if (stringArray.length > 2) {
            stringBuilder.append(".ea");
        }
        return stringBuilder.toString();
    }

    private static String authEtal(String string, String string2, String string3) {
        string = AuthorList.fixAuthorForAlphabetization(string);
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = string.split("\\band\\b");
        if (stringArray.length == 0) {
            return "";
        }
        stringBuilder.append(stringArray[0].split(",")[0]);
        if (stringArray.length == 2) {
            stringBuilder.append(string2).append(stringArray[1].split(",")[0]);
        } else if (stringArray.length > 2) {
            stringBuilder.append(string3);
        }
        return stringBuilder.toString();
    }

    private static String authN_M(String string, int n, int n2) {
        String[] stringArray = (string = AuthorList.fixAuthorForAlphabetization(string)).split("\\band\\b");
        if (stringArray.length <= n2 || n < 0 || n2 < 0) {
            return "";
        }
        String string2 = stringArray[n2].split(",")[0].trim();
        if (string2.length() <= n) {
            return string2;
        }
        return string2.substring(0, n);
    }

    private static String authshort(String string) {
        string = AuthorList.fixAuthorForAlphabetization(string);
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = string.split("\\band\\b");
        if (stringArray.length == 1) {
            stringBuilder.append(LabelPatternUtil.authN_M(string, string.length(), 0));
        } else if (stringArray.length >= 2) {
            for (int i = 0; stringArray.length > i && i < 3; ++i) {
                stringBuilder.append(LabelPatternUtil.authN_M(string, 1, i));
            }
            if (stringArray.length > 3) {
                stringBuilder.append("+");
            }
        }
        return stringBuilder.toString();
    }

    public static String authIniN(String string, int n) {
        if (n <= 0) {
            return "";
        }
        string = AuthorList.fixAuthorForAlphabetization(string);
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = string.split("\\band\\b");
        int n2 = n / stringArray.length;
        if (stringArray.length == 0) {
            return stringBuilder.toString();
        }
        for (int i = 0; stringArray.length > i; ++i) {
            if (i < n % stringArray.length) {
                stringBuilder.append(LabelPatternUtil.authN_M(string, n2 + 1, i));
                continue;
            }
            stringBuilder.append(LabelPatternUtil.authN_M(string, n2, i));
        }
        if (stringBuilder.length() <= n) {
            return stringBuilder.toString();
        }
        return stringBuilder.toString().substring(0, n);
    }

    public static String firstPage(String string) {
        String[] stringArray = string.split("\\D+");
        int n = Integer.MAX_VALUE;
        for (String string2 : stringArray) {
            if (!string2.matches("\\d+")) continue;
            n = Math.min(Integer.parseInt(string2), n);
        }
        if (n == Integer.MAX_VALUE) {
            return "";
        }
        return String.valueOf(n);
    }

    public static String lastPage(String string) {
        String[] stringArray = string.split("\\D+");
        int n = Integer.MIN_VALUE;
        for (String string2 : stringArray) {
            if (!string2.matches("\\d+")) continue;
            n = Math.max(Integer.parseInt(string2), n);
        }
        if (n == Integer.MIN_VALUE) {
            return "";
        }
        return String.valueOf(n);
    }

    private static String[] parseFieldMarker(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == ':' && !bl && n == 0) {
                arrayList.add(stringBuilder.toString());
                stringBuilder = new StringBuilder();
                continue;
            }
            if (string.charAt(i) == '(' && !bl) {
                ++n;
                stringBuilder.append(string.charAt(i));
                continue;
            }
            if (string.charAt(i) == ')' && !bl && n > 0) {
                --n;
                stringBuilder.append(string.charAt(i));
                continue;
            }
            if (string.charAt(i) == '\\') {
                if (bl) {
                    bl = false;
                    stringBuilder.append(string.charAt(i));
                    continue;
                }
                bl = true;
                continue;
            }
            if (bl) {
                stringBuilder.append(string.charAt(i));
                bl = false;
                continue;
            }
            stringBuilder.append(string.charAt(i));
        }
        arrayList.add(stringBuilder.toString());
        return arrayList.toArray(new String[arrayList.size()]);
    }

    static {
        LabelPatternUtil.updateDefaultPattern();
    }
}

