/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.labelPattern;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.MetaData;
import net.sf.jabref.PreviewPanel;

class ResolveDuplicateLabelDialog {
    private final JDialog diag;
    private final List<JCheckBox> cbs = new ArrayList<JCheckBox>();
    private boolean okPressed = false;
    private static final String layout = "<font face=\"arial\"><b><i>\\bibtextype</i><a name=\"\\bibtexkey\">\\begin{bibtexkey} (\\bibtexkey)</a>\\end{bibtexkey}</b><br>\n\\begin{author} \\format[HTMLChars,AuthorAbbreviator,AuthorAndsReplacer]{\\author}<BR>\\end{author}\n\\begin{editor} \\format[HTMLChars,AuthorAbbreviator,AuthorAndsReplacer]{\\editor} <i>(\\format[IfPlural(Eds.,Ed.)]{\\editor})</i><BR>\\end{editor}\n\\begin{title} \\format[HTMLChars]{\\title} \\end{title}<BR>\n\\begin{chapter} \\format[HTMLChars]{\\chapter}<BR>\\end{chapter}\n\\begin{journal} <em>\\format[HTMLChars]{\\journal}, </em>\\end{journal}\n\\begin{booktitle} <em>\\format[HTMLChars]{\\booktitle}, </em>\\end{booktitle}\n\\begin{school} <em>\\format[HTMLChars]{\\school}, </em>\\end{school}\n\\begin{institution} <em>\\format[HTMLChars]{\\institution}, </em>\\end{institution}\n\\begin{publisher} <em>\\format[HTMLChars]{\\publisher}, </em>\\end{publisher}\n\\begin{year}<b>\\year</b>\\end{year}\\begin{volume}<i>, \\volume</i>\\end{volume}\\begin{pages}, \\format[FormatPagesForHTML]{\\pages} \\end{pages}\n<p></p></font>";

    public ResolveDuplicateLabelDialog(BasePanel basePanel, String string, List<BibtexEntry> list) {
        Serializable serializable;
        AbstractButton abstractButton;
        this.diag = new JDialog(basePanel.frame(), Globals.lang("Duplicate BibTeX key"), true);
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(new FormLayout("left:pref, 4dlu, fill:pref", ""));
        defaultFormBuilder.append((Component)new JLabel(Globals.lang("Duplicate key") + ": " + string), 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        boolean bl = true;
        for (BibtexEntry object2 : list) {
            abstractButton = new JCheckBox(Globals.lang("Generate key"), !bl);
            defaultFormBuilder.append(abstractButton);
            serializable = new PreviewPanel(null, object2, null, new MetaData(), layout);
            serializable.setPreferredSize(new Dimension(800, 90));
            defaultFormBuilder.append(new JScrollPane((Component)serializable));
            defaultFormBuilder.nextLine();
            this.cbs.add((JCheckBox)abstractButton);
            bl = false;
        }
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.addGlue();
        JButton jButton = new JButton(Globals.lang("Ok"));
        buttonBarBuilder.addButton((JComponent)jButton);
        abstractButton = new JButton(Globals.lang("Cancel"));
        buttonBarBuilder.addButton((JComponent)abstractButton);
        buttonBarBuilder.addGlue();
        buttonBarBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.diag.getContentPane().add((Component)defaultFormBuilder.getPanel(), "Center");
        this.diag.getContentPane().add((Component)buttonBarBuilder.getPanel(), "South");
        this.diag.pack();
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ResolveDuplicateLabelDialog.this.okPressed = true;
                ResolveDuplicateLabelDialog.this.diag.dispose();
            }
        });
        abstractButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ResolveDuplicateLabelDialog.this.diag.dispose();
            }
        });
        serializable = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ResolveDuplicateLabelDialog.this.diag.dispose();
            }
        };
        ActionMap actionMap = defaultFormBuilder.getPanel().getActionMap();
        InputMap inputMap = defaultFormBuilder.getPanel().getInputMap(2);
        inputMap.put(Globals.prefs.getKey("Close dialog"), "close");
        actionMap.put("close", (Action)((Object)serializable));
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public List<JCheckBox> getCheckBoxes() {
        return this.cbs;
    }

    public void show() {
        this.okPressed = false;
        this.diag.setLocationRelativeTo(this.diag.getParent());
        this.diag.setVisible(true);
    }
}

