/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.labelPattern;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JCheckBox;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.labelPattern.LabelPatternUtil;
import net.sf.jabref.labelPattern.ResolveDuplicateLabelDialog;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableKeyChange;

public class SearchFixDuplicateLabels
extends AbstractWorker {
    private final BasePanel panel;
    private HashMap<String, List<BibtexEntry>> dupes = null;

    public SearchFixDuplicateLabels(BasePanel basePanel) {
        this.panel = basePanel;
    }

    @Override
    public void run() {
        this.dupes = new HashMap();
        HashMap<String, BibtexEntry> hashMap = new HashMap<String, BibtexEntry>();
        BibtexDatabase bibtexDatabase = this.panel.database();
        for (BibtexEntry bibtexEntry : bibtexDatabase.getEntries()) {
            String string = bibtexEntry.getCiteKey();
            if (string == null || string.length() <= 0) continue;
            if (!hashMap.containsKey(string)) {
                hashMap.put(string, bibtexEntry);
                continue;
            }
            if (this.dupes.containsKey(string)) {
                this.dupes.get(string).add(bibtexEntry);
                continue;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(hashMap.get(string));
            arrayList.add(bibtexEntry);
            this.dupes.put(string, arrayList);
        }
    }

    @Override
    public void init() throws Throwable {
        this.panel.output(Globals.lang("Resolving duplicate BibTeX keys..."));
    }

    @Override
    public void update() {
        Object object;
        ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
        for (String object2 : this.dupes.keySet()) {
            ResolveDuplicateLabelDialog resolveDuplicateLabelDialog = new ResolveDuplicateLabelDialog(this.panel, object2, this.dupes.get(object2));
            resolveDuplicateLabelDialog.show();
            if (!resolveDuplicateLabelDialog.isOkPressed()) continue;
            object = resolveDuplicateLabelDialog.getCheckBoxes();
            for (int i = 0; i < object.size(); ++i) {
                if (!((JCheckBox)object.get(i)).isSelected()) continue;
                arrayList.add(this.dupes.get(object2).get(i));
            }
        }
        if (arrayList.size() > 0) {
            NamedCompound namedCompound = new NamedCompound("resolve duplicate keys");
            for (BibtexEntry bibtexEntry : arrayList) {
                object = bibtexEntry.getCiteKey();
                BibtexEntry bibtexEntry2 = LabelPatternUtil.makeLabel(this.panel.metaData(), this.panel.database(), bibtexEntry);
                namedCompound.addEdit(new UndoableKeyChange(this.panel.database(), bibtexEntry2.getId(), (String)object, bibtexEntry2.getField("bibtexkey")));
            }
            namedCompound.end();
            this.panel.undoManager.addEdit(namedCompound);
            this.panel.markBaseChanged();
        }
        this.panel.output(Globals.lang("Finished resolving duplicate BibTeX keys. %0 entries modified.", String.valueOf(arrayList.size())));
    }
}

