/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.sql;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;

public class DBImportExportDialog
implements MouseListener,
KeyListener {
    private final JDialog diag;
    private final JTable table;
    public final List<String> listOfDBs = new ArrayList<String>();
    public boolean moreThanOne = false;
    public String selectedDB = "";
    public boolean hasDBSelected = false;
    public boolean removeAction = false;
    public int selectedInt = -1;
    private final DialogType dialogType;

    public DBImportExportDialog(JabRefFrame jabRefFrame, Vector<Vector<String>> vector, DialogType dialogType) {
        int n;
        String string;
        String string2;
        this.dialogType = dialogType;
        Vector<String> vector2 = new Vector<String>();
        vector2.add("Databases");
        this.table = new JTable();
        DefaultTableModel defaultTableModel = new DefaultTableModel(vector, vector2){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.table.setModel(defaultTableModel);
        if (this.isExporter()) {
            string2 = Globals.lang("SQL Database Exporter");
            string = Globals.lang("Select target SQL database:");
            n = 0;
            this.table.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "exportAction");
            this.table.getActionMap().put("exportAction", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DBImportExportDialog.this.exportAction();
                }
            });
        } else {
            string2 = Globals.lang("SQL Database Importer");
            string = Globals.lang("Please select which JabRef databases do you want to import:");
            n = 2;
            this.table.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "importAction");
            this.table.getActionMap().put("importAction", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DBImportExportDialog.this.importAction();
                }
            });
        }
        this.diag = new JDialog(jabRefFrame, string2, false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(string);
        jLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)jLabel, "North");
        this.table.setSelectionMode(n);
        this.table.setPreferredScrollableViewportSize(new Dimension(100, 100));
        this.table.setTableHeader(null);
        this.table.setRowSelectionInterval(0, 0);
        jPanel.add((Component)new JScrollPane(this.table), "Center");
        this.diag.getContentPane().add((Component)jPanel, "North");
        jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.diag.getContentPane().add((Component)jPanel, "Center");
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.addGlue();
        JButton jButton = new JButton(Globals.lang("Import"));
        JButton jButton2 = new JButton(Globals.lang("Export"));
        if (this.isImporter()) {
            buttonBarBuilder.addButton((JComponent)jButton);
        } else {
            buttonBarBuilder.addButton((JComponent)jButton2);
        }
        buttonBarBuilder.addRelatedGap();
        JButton jButton3 = new JButton(Globals.lang("Cancel"));
        buttonBarBuilder.addButton((JComponent)jButton3);
        buttonBarBuilder.addRelatedGap();
        JButton jButton4 = new JButton(Globals.lang("Remove Selected"));
        buttonBarBuilder.addButton((JComponent)jButton4);
        buttonBarBuilder.addGlue();
        buttonBarBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.diag.getContentPane().add((Component)buttonBarBuilder.getPanel(), "South");
        this.diag.pack();
        this.diag.setLocationRelativeTo(jabRefFrame);
        this.table.addMouseListener(this);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DBImportExportDialog.this.importAction();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DBImportExportDialog.this.exportAction();
            }
        });
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DBImportExportDialog.this.moreThanOne = false;
                DBImportExportDialog.this.hasDBSelected = false;
                DBImportExportDialog.this.diag.dispose();
            }
        });
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DBImportExportDialog.this.moreThanOne = false;
                DBImportExportDialog.this.hasDBSelected = true;
                DBImportExportDialog.this.selectedInt = DBImportExportDialog.this.table.getSelectedRow();
                DBImportExportDialog.this.selectedDB = (String)DBImportExportDialog.this.table.getValueAt(DBImportExportDialog.this.selectedInt, 0);
                int n = JOptionPane.showConfirmDialog(DBImportExportDialog.this.diag, "Are you sure you want to remove the already\nexistent SQL DBs?");
                if (n == 0) {
                    DBImportExportDialog.this.removeAction = true;
                    DBImportExportDialog.this.diag.dispose();
                }
            }
        });
        this.diag.setModal(true);
        this.diag.setVisible(true);
    }

    private boolean isImporter() {
        return this.dialogType.equals((Object)DialogType.IMPORTER);
    }

    public boolean isExporter() {
        return this.dialogType.equals((Object)DialogType.EXPORTER);
    }

    public JDialog getDiag() {
        return this.diag;
    }

    private void exportAction() {
        this.selectedInt = this.table.getSelectedRow();
        this.selectedDB = (String)this.table.getValueAt(this.selectedInt, 0);
        this.hasDBSelected = true;
        this.diag.dispose();
    }

    private void importAction() {
        int[] nArray;
        for (int n : nArray = this.table.getSelectedRows()) {
            this.listOfDBs.add((String)this.table.getValueAt(n, 0));
            this.moreThanOne = true;
        }
        this.diag.dispose();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2 && this.isExporter()) {
            this.exportAction();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    public static enum DialogType {
        IMPORTER,
        EXPORTER;

    }
}

