/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.sql.exporter;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.JOptionPane;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.BibtexString;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.export.FileActions;
import net.sf.jabref.groups.GroupTreeNode;
import net.sf.jabref.groups.structure.AbstractGroup;
import net.sf.jabref.groups.structure.ExplicitGroup;
import net.sf.jabref.groups.structure.GroupHierarchyType;
import net.sf.jabref.groups.structure.KeywordGroup;
import net.sf.jabref.groups.structure.SearchGroup;
import net.sf.jabref.sql.DBImportExportDialog;
import net.sf.jabref.sql.DBImporterExporter;
import net.sf.jabref.sql.DBStrings;
import net.sf.jabref.sql.SQLUtil;
import net.sf.jabref.util.StringUtil;

public abstract class DBExporter
extends DBImporterExporter {
    private final String fieldStr = SQLUtil.getFieldStr();
    DBStrings dbStrings = null;
    private final ArrayList<String> dbNames = new ArrayList();

    private void performExport(BibtexDatabase bibtexDatabase, MetaData metaData, Set<String> set, Object object, String string) throws Exception {
        List<BibtexEntry> list = FileActions.getSortedEntries(bibtexDatabase, metaData, set, false);
        GroupTreeNode groupTreeNode = metaData.getGroups();
        int n = this.getDatabaseIDByName(metaData, object, string);
        this.removeAllRecordsForAGivenDB(object, n);
        this.populateEntryTypesTable(object);
        this.populateEntriesTable(n, list, object);
        this.populateStringTable(bibtexDatabase, object, n);
        this.populateGroupTypesTable(object);
        this.populateGroupsTable(groupTreeNode, 0, 1, object, n);
        this.populateEntryGroupsTable(groupTreeNode, 0, 1, object, n);
    }

    private void populateEntriesTable(int n, List<BibtexEntry> list, Object object) throws SQLException {
        String string = "INSERT INTO entries (jabref_eid, entry_types_id, cite_key, " + this.fieldStr + ", database_id) VALUES (";
        for (BibtexEntry bibtexEntry : list) {
            String string2 = string + '\'' + bibtexEntry.getId() + '\'' + ", (SELECT entry_types_id FROM entry_types WHERE label='" + bibtexEntry.getType().getName().toLowerCase() + "'), '" + bibtexEntry.getCiteKey() + '\'';
            for (int i = 0; i < SQLUtil.getAllFields().size(); ++i) {
                string2 = string2 + ", ";
                String string3 = bibtexEntry.getField(SQLUtil.getAllFields().get(i));
                if (string3 != null) {
                    string3 = string3.replace("\\", "\\\\");
                    string3 = string3.replace("\"", "\\\"");
                    string3 = string3.replace("'", "''");
                    string3 = string3.replace("`", "\\`");
                    string2 = string2 + '\'' + string3 + '\'';
                    continue;
                }
                string2 = string2 + "NULL";
            }
            string2 = string2 + ", '" + n + "');";
            SQLUtil.processQuery(object, string2);
        }
    }

    private int populateEntryGroupsTable(GroupTreeNode groupTreeNode, int n, int n2, Object object, int n3) throws SQLException {
        Object object3;
        if (groupTreeNode.getGroup() instanceof ExplicitGroup) {
            object3 = (ExplicitGroup)groupTreeNode.getGroup();
            for (BibtexEntry object22 : ((ExplicitGroup)object3).getEntries()) {
                SQLUtil.processQuery(object, "INSERT INTO entry_group (entries_id, groups_id) VALUES ((SELECT entries_id FROM entries WHERE jabref_eid='" + object22.getId() + "' AND database_id = " + n3 + "), " + "(SELECT groups_id FROM groups WHERE database_id=" + '\'' + n3 + "' AND parent_id=" + '\'' + n + "' AND label=" + '\'' + ((AbstractGroup)object3).getName() + "')" + ");");
            }
        }
        object3 = SQLUtil.processQueryWithResults(object, "SELECT groups_id FROM groups WHERE label='" + groupTreeNode.getGroup().getName() + "' AND database_id='" + n3 + "' AND parent_id='" + n + "';");
        int n4 = ++n2;
        if (object3 instanceof Statement) {
            ResultSet resultSet = ((Statement)object3).getResultSet();
            resultSet.next();
            n4 = resultSet.getInt("groups_id");
        }
        Enumeration<GroupTreeNode> enumeration = groupTreeNode.children();
        while (enumeration.hasMoreElements()) {
            n2 = this.populateEntryGroupsTable(enumeration.nextElement(), n4, n2, object, n3);
        }
        return n2;
    }

    private void populateEntryTypesTable(Object object) throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (object instanceof Connection) {
            ResultSet resultSet = ((Statement)SQLUtil.processQueryWithResults(object, "SELECT label FROM entry_types")).getResultSet();
            while (resultSet.next()) {
                arrayList2.add(resultSet.getString(1));
            }
        }
        for (BibtexEntryType bibtexEntryType : BibtexEntryType.getAllValues()) {
            String string;
            Object object2;
            arrayList.clear();
            for (int i = 0; i < SQLUtil.getAllFields().size(); ++i) {
                arrayList.add(i, "gen");
            }
            List<String> list = Arrays.asList(bibtexEntryType.getRequiredFields() != null ? bibtexEntryType.getRequiredFields() : new String[]{});
            List<String> list2 = Arrays.asList(bibtexEntryType.getOptionalFields() != null ? bibtexEntryType.getOptionalFields() : new String[]{});
            List<String> list3 = Arrays.asList(bibtexEntryType.getUtilityFields() != null ? bibtexEntryType.getUtilityFields() : new String[]{});
            arrayList = SQLUtil.setFieldRequirement(SQLUtil.getAllFields(), list, list2, list3, arrayList);
            if (!arrayList2.contains(bibtexEntryType.getName().toLowerCase())) {
                object2 = "INSERT INTO entry_types (label, " + this.fieldStr + ") VALUES (";
                string = (String)object2 + '\'' + bibtexEntryType.getName().toLowerCase() + '\'';
                for (String string2 : arrayList) {
                    string = string + ", '" + string2 + '\'';
                }
                string = string + ");";
            } else {
                object2 = this.fieldStr.split(",");
                string = "UPDATE entry_types SET \n";
                for (int i = 0; i < arrayList.size(); ++i) {
                    string = string + object2[i] + "='" + arrayList.get(i) + "',";
                }
                string = string.substring(0, string.lastIndexOf(","));
                string = string + " WHERE label='" + bibtexEntryType.getName().toLowerCase() + '\'';
            }
            SQLUtil.processQuery(object, string);
        }
    }

    private int populateGroupsTable(GroupTreeNode groupTreeNode, int n, int n2, Object object, int n3) throws SQLException {
        Object object2;
        AbstractGroup abstractGroup = groupTreeNode.getGroup();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        GroupHierarchyType groupHierarchyType = abstractGroup.getHierarchicalContext();
        if (abstractGroup instanceof KeywordGroup) {
            string = ((KeywordGroup)abstractGroup).getSearchField();
            string2 = ((KeywordGroup)abstractGroup).getSearchExpression();
            string3 = ((KeywordGroup)abstractGroup).isCaseSensitive() ? "1" : "0";
            string4 = ((KeywordGroup)abstractGroup).isRegExp() ? "1" : "0";
        } else if (abstractGroup instanceof SearchGroup) {
            string2 = ((SearchGroup)abstractGroup).getSearchExpression();
            string3 = ((SearchGroup)abstractGroup).isCaseSensitive() ? "1" : "0";
            String string5 = string4 = ((SearchGroup)abstractGroup).isRegExp() ? "1" : "0";
        }
        if (string != null) {
            string = StringUtil.quote(string, "'", '\\');
        }
        if (string2 != null) {
            string2 = StringUtil.quote(string2, "'", '\\');
        }
        SQLUtil.processQuery(object, "INSERT INTO groups (label, parent_id, group_types_id, search_field, search_expression, case_sensitive, reg_exp, hierarchical_context, database_id) VALUES ('" + abstractGroup.getName() + "', " + n + ", (SELECT group_types_id FROM group_types where label='" + abstractGroup.getTypeId() + "')" + ", " + (string != null ? '\'' + string + '\'' : "NULL") + ", " + (string2 != null ? '\'' + string2 + '\'' : "NULL") + ", " + (string3 != null ? '\'' + string3 + '\'' : "NULL") + ", " + (string4 != null ? '\'' + string4 + '\'' : "NULL") + ", " + groupHierarchyType.ordinal() + ", '" + n3 + "');");
        Object object3 = SQLUtil.processQueryWithResults(object, "SELECT groups_id FROM groups WHERE label='" + groupTreeNode.getGroup().getName() + "' AND database_id='" + n3 + "' AND parent_id='" + n + "';");
        int n4 = n2;
        if (object3 instanceof Statement) {
            object2 = ((Statement)object3).getResultSet();
            object2.next();
            n4 = object2.getInt("groups_id");
        }
        object2 = groupTreeNode.children();
        while (object2.hasMoreElements()) {
            ++n2;
            n2 = this.populateGroupsTable((GroupTreeNode)object2.nextElement(), n4, n2, object, n3);
        }
        return n2;
    }

    private void populateGroupTypesTable(Object object) throws SQLException {
        String[] stringArray;
        int n = 0;
        if (object instanceof Connection) {
            stringArray = ((Statement)SQLUtil.processQueryWithResults(object, "SELECT COUNT(*) AS amount FROM group_types")).getResultSet();
            stringArray.next();
            n = stringArray.getInt("amount");
            stringArray.getStatement().close();
        }
        if (n == 0) {
            for (String string : stringArray = new String[]{"AllEntriesGroup:", "ExplicitGroup:", "KeywordGroup:", "SearchGroup:"}) {
                String string2 = "INSERT INTO group_types (label) VALUES ('" + string + "');";
                SQLUtil.processQuery(object, string2);
            }
        }
    }

    private void populateStringTable(BibtexDatabase bibtexDatabase, Object object, int n) throws SQLException {
        String string = "INSERT INTO strings (label, content, database_id) VALUES (";
        if (bibtexDatabase.getPreamble() != null) {
            String string2 = string + "'@PREAMBLE', " + '\'' + StringUtil.quote(bibtexDatabase.getPreamble(), "'", '\\') + "', " + '\'' + n + "');";
            SQLUtil.processQuery(object, string2);
        }
        for (String string3 : bibtexDatabase.getStringKeySet()) {
            BibtexString bibtexString = bibtexDatabase.getString(string3);
            String string4 = string + '\'' + StringUtil.quote(bibtexString.getName(), "'", '\\') + "', " + '\'' + StringUtil.quote(bibtexString.getContent(), "'", '\\') + "', " + '\'' + n + '\'' + ");";
            SQLUtil.processQuery(object, string4);
        }
    }

    public abstract Connection connectToDB(DBStrings var1) throws Exception;

    protected abstract void createTables(Object var1) throws SQLException;

    public void exportDatabaseAsFile(BibtexDatabase bibtexDatabase, MetaData metaData, Set<String> set, String string) throws Exception {
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        PrintStream printStream = new PrintStream(bufferedOutputStream);
        this.performExport(bibtexDatabase, metaData, set, printStream, "file");
        printStream.close();
    }

    public void exportDatabaseToDBMS(BibtexDatabase bibtexDatabase, MetaData metaData, Set<String> set, DBStrings dBStrings, JabRefFrame jabRefFrame) throws Exception {
        Connection connection = null;
        boolean bl = false;
        try {
            connection = this.connectToDB(dBStrings);
            this.createTables(connection);
            Vector<Vector<String>> vector = this.createExistentDBNamesMatrix(dBStrings);
            DBImportExportDialog dBImportExportDialog = new DBImportExportDialog(jabRefFrame, vector, DBImportExportDialog.DialogType.EXPORTER);
            if (dBImportExportDialog.removeAction) {
                String string = this.getDBName(vector, dBStrings, jabRefFrame, dBImportExportDialog);
                this.removeDB(dBImportExportDialog, string, connection, metaData);
                bl = true;
            } else if (dBImportExportDialog.hasDBSelected) {
                String string = this.getDBName(vector, dBStrings, jabRefFrame, dBImportExportDialog);
                this.performExport(bibtexDatabase, metaData, set, connection, string);
            }
            if (!connection.getAutoCommit()) {
                connection.commit();
                connection.setAutoCommit(true);
            }
            connection.close();
            if (bl) {
                this.exportDatabaseToDBMS(bibtexDatabase, metaData, set, dBStrings, jabRefFrame);
            }
        }
        catch (SQLException sQLException) {
            if (connection != null && !connection.getAutoCommit()) {
                connection.rollback();
            }
            throw sQLException;
        }
    }

    private String getDBName(Vector<Vector<String>> vector, DBStrings dBStrings, JabRefFrame jabRefFrame, DBImportExportDialog dBImportExportDialog) throws Exception {
        String string = "";
        if (vector.size() > 1) {
            if (dBImportExportDialog.hasDBSelected) {
                string = dBImportExportDialog.selectedDB;
                if (dBImportExportDialog.selectedInt == 0 && !dBImportExportDialog.removeAction) {
                    string = JOptionPane.showInputDialog(dBImportExportDialog.getDiag(), "Please enter the desired name:", "SQL Export", 1);
                    if (string != null) {
                        while (!this.isValidDBName(this.dbNames, string)) {
                            string = JOptionPane.showInputDialog(dBImportExportDialog.getDiag(), "You have entered an invalid or already existent DB name.\n Please enter the desired name:", "SQL Export", 0);
                        }
                    } else {
                        this.getDBName(vector, dBStrings, jabRefFrame, new DBImportExportDialog(jabRefFrame, vector, DBImportExportDialog.DialogType.EXPORTER));
                    }
                }
            }
        } else {
            string = JOptionPane.showInputDialog(jabRefFrame, "Please enter the desired name:", "SQL Export", 1);
        }
        return string;
    }

    private Vector<Vector<String>> createExistentDBNamesMatrix(DBStrings dBStrings) throws Exception {
        ResultSet resultSet = SQLUtil.queryAllFromTable(this.connectToDB(dBStrings), "jabref_database");
        Vector<Vector<String>> vector = new Vector<Vector<String>>();
        this.dbNames.clear();
        Vector<String> vector2 = new Vector<String>();
        vector2.add(Globals.lang("< CREATE NEW DATABASE >"));
        vector.add(vector2);
        while (resultSet.next()) {
            vector2 = new Vector();
            vector2.add(resultSet.getString("database_name"));
            vector.add(vector2);
            this.dbNames.add(resultSet.getString("database_name"));
        }
        return vector;
    }

    private boolean isValidDBName(ArrayList<String> arrayList, String string) {
        return string.trim().length() > 1 && !arrayList.contains(string);
    }
}

