/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.sql.importer;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.MutableTreeNode;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.BibtexString;
import net.sf.jabref.IdGenerator;
import net.sf.jabref.MetaData;
import net.sf.jabref.groups.GroupTreeNode;
import net.sf.jabref.groups.structure.AbstractGroup;
import net.sf.jabref.groups.structure.AllEntriesGroup;
import net.sf.jabref.groups.structure.ExplicitGroup;
import net.sf.jabref.groups.structure.GroupHierarchyType;
import net.sf.jabref.groups.structure.KeywordGroup;
import net.sf.jabref.groups.structure.SearchGroup;
import net.sf.jabref.sql.DBImporterExporter;
import net.sf.jabref.sql.DBStrings;
import net.sf.jabref.sql.SQLUtil;
import net.sf.jabref.util.StringUtil;

public abstract class DBImporter
extends DBImporterExporter {
    private final ArrayList<String> columnsNotConsideredForEntries = new ArrayList<String>(Arrays.asList("cite_key", "entry_types_id", "database_id", "jabref_eid", "entries_id"));

    protected abstract Connection connectToDB(DBStrings var1) throws Exception;

    protected abstract ResultSet readColumnNames(Connection var1) throws SQLException;

    public ArrayList<Object[]> performImport(Set<String> set, DBStrings dBStrings, List<String> list) throws Exception {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        Connection connection = this.connectToDB(dBStrings);
        Iterator<String> iterator = list.iterator();
        String string = "(";
        while (iterator.hasNext()) {
            string = string + '\'' + iterator.next() + "',";
        }
        string = string.substring(0, string.length() - 1) + ')';
        ResultSet resultSet = SQLUtil.queryAllFromTable(connection, "jabref_database WHERE database_name IN " + string);
        while (resultSet.next()) {
            Object object;
            Object object2;
            BibtexDatabase bibtexDatabase = new BibtexDatabase();
            HashMap<String, BibtexEntryType> hashMap = new HashMap<String, BibtexEntryType>();
            ResultSet resultSet2 = SQLUtil.queryAllFromTable(connection, "entry_types");
            while (resultSet2.next()) {
                hashMap.put(resultSet2.getString("entry_types_id"), BibtexEntryType.getType(resultSet2.getString("label")));
            }
            resultSet2.getStatement().close();
            ResultSet resultSet3 = this.readColumnNames(connection);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            while (resultSet3.next()) {
                if (this.columnsNotConsideredForEntries.contains(resultSet3.getString(1))) continue;
                arrayList2.add(resultSet3.getString(1));
            }
            resultSet3.getStatement().close();
            String string2 = resultSet.getString("database_id");
            HashMap<String, BibtexEntry> hashMap2 = new HashMap<String, BibtexEntry>();
            ResultSet resultSet4 = SQLUtil.queryAllFromTable(connection, "entries WHERE database_id= '" + string2 + "';");
            while (resultSet4.next()) {
                object2 = resultSet4.getString("entries_id");
                object = new BibtexEntry(IdGenerator.next(), (BibtexEntryType)hashMap.get(resultSet4.getString("entry_types_id")));
                ((BibtexEntry)object).setField("bibtexkey", resultSet4.getString("cite_key"));
                for (String string3 : arrayList2) {
                    String string4 = resultSet4.getString(string3);
                    if (string4 == null) continue;
                    String string5 = string3.charAt(string3.length() - 1) == '_' ? string3.substring(0, string3.length() - 1) : string3;
                    ((BibtexEntry)object).setField(string5, string4);
                }
                hashMap2.put((String)object2, (BibtexEntry)object);
                bibtexDatabase.insertEntry((BibtexEntry)object);
            }
            resultSet4.getStatement().close();
            object2 = SQLUtil.queryAllFromTable(connection, "strings WHERE database_id='" + string2 + '\'');
            while (object2.next()) {
                object = object2.getString("label");
                String string4 = object2.getString("content");
                if (((String)object).equals("@PREAMBLE")) {
                    bibtexDatabase.setPreamble(string4);
                    continue;
                }
                BibtexString bibtexString = new BibtexString(IdGenerator.next(), (String)object, string4);
                bibtexDatabase.addString(bibtexString);
            }
            object2.getStatement().close();
            object = new MetaData();
            ((MetaData)object).initializeNewDatabase();
            this.importGroupsTree((MetaData)object, hashMap2, connection, string2);
            arrayList.add(new Object[]{bibtexDatabase, object, resultSet.getString("database_name")});
        }
        return arrayList;
    }

    private String findGroupTypeName(String string, Connection connection) throws SQLException {
        return SQLUtil.processQueryWithSingleResult(connection, "SELECT label FROM group_types WHERE group_types_id='" + string + "';");
    }

    private void importGroupsTree(MetaData metaData, HashMap<String, BibtexEntry> hashMap, Connection connection, String string) throws SQLException {
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        LinkedHashMap<Object, String> linkedHashMap = new LinkedHashMap<Object, String>();
        GroupTreeNode groupTreeNode = new GroupTreeNode(new AllEntriesGroup());
        ResultSet resultSet = SQLUtil.queryAllFromTable(connection, "groups WHERE database_id='" + string + "' ORDER BY groups_id");
        while (resultSet.next()) {
            GroupTreeNode groupTreeNode2;
            String string2;
            Object object;
            AbstractGroup abstractGroup = null;
            String string3 = this.findGroupTypeName(resultSet.getString("group_types_id"), connection);
            if (string3.equals("AllEntriesGroup:")) {
                hashMap2.put(resultSet.getString("groups_id"), groupTreeNode);
            } else if (string3.equals("ExplicitGroup:")) {
                abstractGroup = new ExplicitGroup(resultSet.getString("label"), GroupHierarchyType.getByNumber(resultSet.getInt("hierarchical_context")));
            } else if (string3.equals("KeywordGroup:")) {
                System.out.println("Keyw: " + resultSet.getBoolean("case_sensitive"));
                abstractGroup = new KeywordGroup(resultSet.getString("label"), StringUtil.unquote(resultSet.getString("search_field"), '\\'), StringUtil.unquote(resultSet.getString("search_expression"), '\\'), resultSet.getBoolean("case_sensitive"), resultSet.getBoolean("reg_exp"), GroupHierarchyType.getByNumber(resultSet.getInt("hierarchical_context")));
            } else if (string3.equals("SearchGroup:")) {
                System.out.println("Search: " + resultSet.getBoolean("case_sensitive"));
                abstractGroup = new SearchGroup(resultSet.getString("label"), StringUtil.unquote(resultSet.getString("search_expression"), '\\'), resultSet.getBoolean("case_sensitive"), resultSet.getBoolean("reg_exp"), GroupHierarchyType.getByNumber(resultSet.getInt("hierarchical_context")));
            }
            if (abstractGroup != null) {
                object = new GroupTreeNode(abstractGroup);
                linkedHashMap.put(object, resultSet.getString("parent_id"));
                hashMap2.put(resultSet.getString("groups_id"), object);
            }
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                string2 = (String)entry.getValue();
                groupTreeNode2 = (GroupTreeNode)hashMap2.get(string2);
                if (groupTreeNode2 == null) continue;
                groupTreeNode2.add((MutableTreeNode)entry.getKey());
            }
            object = SQLUtil.queryAllFromTable(connection, "entry_group");
            while (object.next()) {
                String string4 = object.getString("entries_id");
                string2 = object.getString("groups_id");
                groupTreeNode2 = (GroupTreeNode)hashMap2.get(string2);
                if (groupTreeNode2 == null || !(groupTreeNode2.getGroup() instanceof ExplicitGroup)) continue;
                ExplicitGroup explicitGroup = (ExplicitGroup)groupTreeNode2.getGroup();
                explicitGroup.addEntry(hashMap.get(string4));
            }
            object.getStatement().close();
            metaData.setGroups(groupTreeNode);
        }
        resultSet.getStatement().close();
    }
}

