/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.gui.shortcut;

import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;
import javax.swing.text.Utilities;
import net.sf.jabref.JabRefPreferences;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EmacsKeyBindings {
    private static final String killLineAction = "emacs-kill-line";
    private static final String killRingSaveAction = "emacs-kill-ring-save";
    private static final String killRegionAction = "emacs-kill-region";
    private static final String backwardKillWordAction = "emacs-backward-kill-word";
    private static final String capitalizeWordAction = "emacs-capitalize-word";
    private static final String downcaseWordAction = "emacs-downcase-word";
    private static final String killWordAction = "emacs-kill-word";
    private static final String setMarkCommandAction = "emacs-set-mark-command";
    private static final String yankAction = "emacs-yank";
    private static final String yankPopAction = "emacs-yank-pop";
    private static final String upcaseWordAction = "emacs-upcase-word";
    private static final JTextComponent.KeyBinding[] EMACS_KEY_BINDINGS_BASE = new JTextComponent.KeyBinding[]{new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(69, 2), "caret-end-line"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(68, 2), "delete-next"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(78, 2), "caret-down"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(80, 2), "caret-up"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(66, 8), "caret-previous-word"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(153, 8), "caret-begin"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(153, 9), "caret-end"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(70, 8), "caret-next-word"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(66, 2), "caret-backward"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(68, 8), "emacs-kill-word"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(8, 8), "emacs-backward-kill-word"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(32, 2), "emacs-set-mark-command"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(87, 8), "emacs-kill-ring-save"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(87, 2), "emacs-kill-region"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(75, 2), "emacs-kill-line"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(89, 2), "emacs-yank"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(89, 8), "emacs-yank-pop"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(67, 8), "emacs-capitalize-word"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(76, 8), "emacs-downcase-word"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(85, 8), "emacs-upcase-word")};
    private static final JTextComponent.KeyBinding EMACS_KEY_BINDING_C_A = new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(65, 2), "caret-begin-line");
    private static final JTextComponent.KeyBinding EMACS_KEY_BINDING_C_F = new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(70, 2), "caret-forward");
    private static final TextAction[] EMACS_ACTIONS = new TextAction[]{new KillWordAction("emacs-kill-word"), new BackwardKillWordAction("emacs-backward-kill-word"), new SetMarkCommandAction("emacs-set-mark-command"), new KillRingSaveAction("emacs-kill-ring-save"), new KillRegionAction("emacs-kill-region"), new KillLineAction("emacs-kill-line"), new YankAction("emacs-yank"), new YankPopAction("emacs-yank-pop"), new CapitalizeWordAction("emacs-capitalize-word"), new DowncaseWordAction("emacs-downcase-word"), new UpcaseWordAction("emacs-upcase-word")};
    private static final JTextComponent[] JTCS = new JTextComponent[]{new JTextArea(), new JTextPane(), new JTextField(), new JEditorPane()};
    private static final Log logger = LogFactory.getLog(EmacsKeyBindings.class);

    public static void load() {
        EmacsKeyBindings.createBackup();
        EmacsKeyBindings.loadEmacsKeyBindings();
    }

    private static void createBackup() {
        Keymap keymap = JTextComponent.getKeymap(JTCS[0].getClass().getName());
        if (keymap != null) {
            return;
        }
        for (JTextComponent jTextComponent : JTCS) {
            Action[] actionArray;
            Keymap keymap2 = jTextComponent.getKeymap();
            Keymap keymap3 = JTextComponent.addKeymap(jTextComponent.getClass().getName(), null);
            for (Action action : actionArray = keymap2.getBoundActions()) {
                KeyStroke[] keyStrokeArray;
                for (KeyStroke keyStroke : keyStrokeArray = keymap2.getKeyStrokesForAction(action)) {
                    keymap3.addActionForKeyStroke(keyStroke, action);
                }
            }
            keymap3.setDefaultAction(keymap2.getDefaultAction());
        }
    }

    public static void unload() {
        for (int i = 0; i < JTCS.length; ++i) {
            Action[] actionArray;
            Keymap keymap = JTextComponent.getKeymap(JTCS[i].getClass().getName());
            if (keymap == null) continue;
            Keymap keymap2 = JTCS[i].getKeymap();
            keymap2.removeBindings();
            for (Action action : actionArray = keymap.getBoundActions()) {
                KeyStroke[] keyStrokeArray;
                for (KeyStroke keyStroke : keyStrokeArray = keymap.getKeyStrokesForAction(actionArray[i])) {
                    keymap2.addActionForKeyStroke(keyStroke, action);
                }
            }
            keymap2.setDefaultAction(keymap.getDefaultAction());
        }
    }

    private static void loadEmacsKeyBindings() {
        logger.debug("Loading emacs keybindings");
        for (JTextComponent jTextComponent : JTCS) {
            JTextComponent.KeyBinding[] keyBindingArray;
            Action[] actionArray = jTextComponent.getActions();
            Action[] actionArray2 = new Action[actionArray.length + EMACS_ACTIONS.length];
            System.arraycopy(actionArray, 0, actionArray2, 0, actionArray.length);
            System.arraycopy(EMACS_ACTIONS, 0, actionArray2, actionArray.length, EMACS_ACTIONS.length);
            Keymap keymap = jTextComponent.getKeymap();
            boolean bl = JabRefPreferences.getInstance().getBoolean("editorEMACSkeyBindingsRebindCA");
            boolean bl2 = JabRefPreferences.getInstance().getBoolean("editorEMACSkeyBindingsRebindCF");
            if (bl || bl2) {
                int n = EMACS_KEY_BINDINGS_BASE.length;
                int n2 = -1;
                int n3 = -1;
                if (bl) {
                    n2 = n++;
                }
                if (bl2) {
                    n3 = n++;
                }
                keyBindingArray = new JTextComponent.KeyBinding[n];
                System.arraycopy(EMACS_KEY_BINDINGS_BASE, 0, keyBindingArray, 0, EMACS_KEY_BINDINGS_BASE.length);
                if (bl) {
                    keyBindingArray[n2] = EMACS_KEY_BINDING_C_A;
                }
                if (bl2) {
                    keyBindingArray[n3] = EMACS_KEY_BINDING_C_F;
                }
            } else {
                keyBindingArray = EMACS_KEY_BINDINGS_BASE;
            }
            JTextComponent.loadKeymap(keymap, keyBindingArray, actionArray2);
        }
    }

    private static void doCopyOrCut(JTextComponent jTextComponent, boolean bl) {
        if (jTextComponent != null) {
            int n;
            int n2 = jTextComponent.getCaretPosition();
            String string = jTextComponent.getSelectedText();
            if (string == null && SetMarkCommandAction.isMarked(jTextComponent)) {
                n = n2;
                int n3 = SetMarkCommandAction.getCaretPosition();
                if (n > n3) {
                    int n4 = n3;
                    n3 = n;
                    n = n4;
                }
                jTextComponent.select(n, n3);
                SetMarkCommandAction.reset();
            }
            if ((string = jTextComponent.getSelectedText()) != null) {
                if (bl) {
                    jTextComponent.copy();
                    jTextComponent.select(n2, n2);
                } else {
                    n = jTextComponent.getSelectionStart();
                    jTextComponent.cut();
                    jTextComponent.setCaretPosition(n);
                }
                KillRing.getInstance().add(string);
            } else {
                jTextComponent.getToolkit().beep();
            }
        }
    }

    private static int getWordEnd(JTextComponent jTextComponent, int n) throws BadLocationException {
        try {
            return Utilities.getNextWord(jTextComponent, n);
        }
        catch (BadLocationException badLocationException) {
            int n2 = jTextComponent.getText().length();
            if (n < n2) {
                return n2;
            }
            throw badLocationException;
        }
    }

    public static class UpcaseWordAction
    extends TextAction {
        public UpcaseWordAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    int n = jTextComponent.getCaretPosition();
                    int n2 = EmacsKeyBindings.getWordEnd(jTextComponent, n);
                    jTextComponent.setSelectionStart(n);
                    jTextComponent.setSelectionEnd(n2);
                    String string = jTextComponent.getText(n, n2 - n);
                    jTextComponent.replaceSelection(string.toUpperCase());
                    jTextComponent.setCaretPosition(n2);
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class DowncaseWordAction
    extends TextAction {
        public DowncaseWordAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    int n = jTextComponent.getCaretPosition();
                    int n2 = EmacsKeyBindings.getWordEnd(jTextComponent, n);
                    jTextComponent.setSelectionStart(n);
                    jTextComponent.setSelectionEnd(n2);
                    String string = jTextComponent.getText(n, n2 - n);
                    jTextComponent.replaceSelection(string.toLowerCase());
                    jTextComponent.setCaretPosition(n2);
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class CapitalizeWordAction
    extends TextAction {
        public CapitalizeWordAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    int n = jTextComponent.getCaretPosition();
                    int n2 = EmacsKeyBindings.getWordEnd(jTextComponent, n);
                    jTextComponent.setSelectionStart(n);
                    jTextComponent.setSelectionEnd(n2);
                    String string = jTextComponent.getText(n, n2 - n);
                    jTextComponent.replaceSelection(string.toLowerCase());
                    int n3 = Utilities.getWordStart(jTextComponent, n);
                    String string2 = jTextComponent.getText(n3, 1);
                    if (string2.equals(" ")) {
                        ++n3;
                        n3 = Utilities.getWordStart(jTextComponent, n3);
                        string2 = jTextComponent.getText(n3, 1);
                    }
                    if (Character.isLetter(string2.charAt(0))) {
                        jTextComponent.setSelectionStart(n3);
                        jTextComponent.setSelectionEnd(n3 + 1);
                        jTextComponent.replaceSelection(string2.toUpperCase());
                    }
                    n2 = Utilities.getWordEnd(jTextComponent, n3);
                    jTextComponent.setCaretPosition(n2);
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class KillRing {
        private JTextComponent jtc;
        private final LinkedList<String> ring = new LinkedList();
        Iterator<String> iter = this.ring.iterator();
        private static final KillRing instance = new KillRing();

        public static KillRing getInstance() {
            return instance;
        }

        void setCurrentTextComponent(JTextComponent jTextComponent) {
            this.jtc = jTextComponent;
        }

        JTextComponent getCurrentTextComponent() {
            return this.jtc;
        }

        void add(String string) {
            if (string.length() == 0) {
                return;
            }
            this.ring.remove(string);
            this.ring.addFirst(string);
            while (this.ring.size() > 60) {
                this.ring.removeLast();
            }
            this.iter = this.ring.iterator();
            this.iter.next();
        }

        public List<String> getRing() {
            return Collections.unmodifiableList(this.ring);
        }

        public boolean isEmpty() {
            return this.ring.isEmpty();
        }

        String next() {
            if (this.ring.isEmpty()) {
                return null;
            }
            if (this.iter.hasNext()) {
                return this.iter.next();
            }
            this.iter = this.ring.iterator();
            return this.iter.next();
        }
    }

    public static class YankPopAction
    extends TextAction {
        public YankPopAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl;
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            boolean bl2 = jTextComponent != null;
            boolean bl3 = KillRing.getInstance().getCurrentTextComponent() == jTextComponent;
            boolean bl4 = jTextComponent.getCaretPosition() == YankAction.end;
            boolean bl5 = bl = !KillRing.getInstance().isEmpty();
            if (bl2 && bl3 && bl4 && bl) {
                jTextComponent.setSelectionStart(YankAction.start);
                jTextComponent.setSelectionEnd(YankAction.end);
                String string = KillRing.getInstance().next();
                if (string != null) {
                    jTextComponent.replaceSelection(string);
                    YankAction.end = jTextComponent.getCaretPosition();
                } else {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class YankAction
    extends TextAction {
        public static int start = -1;
        public static int end = -1;

        public YankAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    start = jTextComponent.getCaretPosition();
                    jTextComponent.paste();
                    end = jTextComponent.getCaretPosition();
                    KillRing.getInstance().add(jTextComponent.getText(start, end));
                    KillRing.getInstance().setCurrentTextComponent(jTextComponent);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static class SetMarkCommandAction
    extends TextAction {
        private static int position = -1;
        private static JTextComponent jtc;

        public SetMarkCommandAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            jtc = this.getTextComponent(actionEvent);
            if (jtc != null) {
                position = jtc.getCaretPosition();
            }
        }

        public static boolean isMarked(JTextComponent jTextComponent) {
            return jtc == jTextComponent && position != -1;
        }

        public static void reset() {
            jtc = null;
            position = -1;
        }

        public static int getCaretPosition() {
            return position;
        }
    }

    public static class KillLineAction
    extends TextAction {
        public KillLineAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    int n = jTextComponent.getCaretPosition();
                    int n2 = Utilities.getRowEnd(jTextComponent, n);
                    if (n == n2 && jTextComponent.isEditable()) {
                        Document document = jTextComponent.getDocument();
                        document.remove(n2, 1);
                    } else {
                        jTextComponent.setSelectionStart(n);
                        jTextComponent.setSelectionEnd(n2);
                        KillRing.getInstance().add(jTextComponent.getSelectedText());
                        jTextComponent.cut();
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class KillRegionAction
    extends TextAction {
        public KillRegionAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            EmacsKeyBindings.doCopyOrCut(jTextComponent, false);
        }
    }

    public static class KillRingSaveAction
    extends TextAction {
        public KillRingSaveAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            EmacsKeyBindings.doCopyOrCut(jTextComponent, true);
        }
    }

    public static class BackwardKillWordAction
    extends TextAction {
        public BackwardKillWordAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    int n = jTextComponent.getCaretPosition();
                    jTextComponent.setSelectionEnd(n);
                    n = Utilities.getPreviousWord(jTextComponent, n);
                    jTextComponent.setSelectionStart(n);
                    KillRing.getInstance().add(jTextComponent.getSelectedText());
                    jTextComponent.cut();
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class KillWordAction
    extends TextAction {
        public KillWordAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    int n = jTextComponent.getCaretPosition();
                    jTextComponent.setSelectionStart(n);
                    n = EmacsKeyBindings.getWordEnd(jTextComponent, n);
                    jTextComponent.setSelectionEnd(n);
                    KillRing.getInstance().add(jTextComponent.getSelectedText());
                    jTextComponent.cut();
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }
}

