/*
 * Decompiled with CFR 0.152.
 */
package spl;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import javax.ws.rs.core.MediaType;
import org.sciplore.beans.Author;
import org.sciplore.beans.Document;
import org.sciplore.deserialize.creator.AuthorBeanCreator;
import org.sciplore.deserialize.creator.AuthorsBeanCreator;
import org.sciplore.deserialize.creator.DefaultStringCreator;
import org.sciplore.deserialize.creator.DocumentBeanCreator;
import org.sciplore.deserialize.creator.DocumentsBeanCreator;
import org.sciplore.deserialize.creator.TitleBeanCreator;
import org.sciplore.deserialize.creator.YearBeanCreator;
import org.sciplore.deserialize.reader.ObjectCreatorMapper;
import org.sciplore.deserialize.reader.XmlResourceReader;
import org.sciplore.formatter.Bean;
import org.sciplore.formatter.SimpleTypeElementBean;
import spl.Tools;

public class SplWebClient {
    private static final Client CLIENT = Client.create();
    private static final WebResource WEBRESOURCE;
    private static final WebResource INTERNETRESOURCE;
    public static Document metadata;

    public static WebServiceStatus getMetaData(File file) {
        try {
            if (!SplWebClient.isWebServiceAvailable()) {
                if (SplWebClient.isInternetAvailable()) {
                    return WebServiceStatus.WEBSERVICE_DOWN;
                }
                return WebServiceStatus.NO_INTERNET;
            }
            if (SplWebClient.isWebServiceOutDated()) {
                return WebServiceStatus.OUTDATED;
            }
            if (!SplWebClient.isMetaDataServiceAvailable()) {
                return WebServiceStatus.UNAVAILABLE;
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[(int)file.length()];
            fileInputStream.read(byArray);
            FormDataMultiPart formDataMultiPart = new FormDataMultiPart();
            formDataMultiPart.field("file", byArray, MediaType.APPLICATION_OCTET_STREAM_TYPE);
            formDataMultiPart.field("source", "jabref", MediaType.TEXT_PLAIN_TYPE);
            formDataMultiPart.field("filename", file.getName(), MediaType.TEXT_PLAIN_TYPE);
            ClientResponse clientResponse = WEBRESOURCE.path("documents").type(MediaType.MULTIPART_FORM_DATA_TYPE).post(ClientResponse.class, (Object)formDataMultiPart);
            if (clientResponse.getClientResponseStatus() == ClientResponse.Status.OK && clientResponse.hasEntity()) {
                String string = clientResponse.getEntity(String.class);
                byte[] byArray2 = new byte[]{};
                try {
                    byArray2 = string.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return null;
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
                if (byteArrayInputStream != null) {
                    ObjectCreatorMapper objectCreatorMapper = new ObjectCreatorMapper();
                    DefaultStringCreator defaultStringCreator = new DefaultStringCreator();
                    objectCreatorMapper.addCreator("documents", new DocumentsBeanCreator());
                    objectCreatorMapper.addCreator("authors", new AuthorsBeanCreator());
                    objectCreatorMapper.addCreator("document", new DocumentBeanCreator());
                    objectCreatorMapper.addCreator("title", new TitleBeanCreator());
                    objectCreatorMapper.addCreator("year", new YearBeanCreator());
                    objectCreatorMapper.addCreator("author", new AuthorBeanCreator());
                    objectCreatorMapper.addCreator("name_first", defaultStringCreator);
                    objectCreatorMapper.addCreator("name_middle", defaultStringCreator);
                    objectCreatorMapper.addCreator("name_last", defaultStringCreator);
                    objectCreatorMapper.addCreator("name_last_prefix", defaultStringCreator);
                    objectCreatorMapper.addCreator("name_last_suffix", defaultStringCreator);
                    XmlResourceReader xmlResourceReader = new XmlResourceReader(objectCreatorMapper);
                    Document document = (Document)xmlResourceReader.parse(byteArrayInputStream);
                    for (Bean bean : document.getAuthors().getCollection()) {
                        Author author = (Author)bean;
                        System.out.println(((SimpleTypeElementBean)author.getName_Last()).getValue() + ' ' + author.getRank());
                    }
                    metadata = document;
                    return WebServiceStatus.OK;
                }
                return WebServiceStatus.NO_METADATA;
            }
            if (clientResponse.getClientResponseStatus() == ClientResponse.Status.SERVICE_UNAVAILABLE) {
                return WebServiceStatus.UNAVAILABLE;
            }
        }
        catch (Exception exception) {
            System.out.println(Tools.getStackTraceAsString(exception));
        }
        return WebServiceStatus.NO_METADATA;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isWebServiceOutDated() {
        try {
            String string;
            byte[] byArray;
            ByteArrayInputStream byteArrayInputStream;
            ClientResponse clientResponse = WEBRESOURCE.path("service/versioncheck/9/current").get(ClientResponse.class);
            if (clientResponse.getClientResponseStatus() == ClientResponse.Status.OK && clientResponse.hasEntity() && (byteArrayInputStream = new ByteArrayInputStream(byArray = (string = clientResponse.getEntity(String.class)).getBytes())) == null) return false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static boolean isMetaDataServiceAvailable() {
        try {
            String string;
            ClientResponse clientResponse = WEBRESOURCE.path("service/metadata/available").get(ClientResponse.class);
            if (clientResponse.getClientResponseStatus() == ClientResponse.Status.OK && clientResponse.hasEntity() && (string = clientResponse.getEntity(String.class)) != null && string.equalsIgnoreCase("false")) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private static boolean isWebServiceAvailable() {
        try {
            ClientResponse clientResponse = WEBRESOURCE.path("service/metadata/available").get(ClientResponse.class);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private static boolean isInternetAvailable() {
        try {
            ClientResponse clientResponse = INTERNETRESOURCE.get(ClientResponse.class);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    static {
        CLIENT.setConnectTimeout(1000);
        CLIENT.setReadTimeout(70000);
        WEBRESOURCE = CLIENT.resource("http://api.mr-dlib.org/");
        INTERNETRESOURCE = CLIENT.resource("http://www.google.com");
    }

    public static enum WebServiceStatus {
        OK,
        NO_METADATA,
        UNAVAILABLE,
        OUTDATED,
        WEBSERVICE_DOWN,
        NO_INTERNET;

    }
}

