/*
 * Decompiled with CFR 0.152.
 */
package spl.gui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import net.sf.jabref.Globals;
import spl.listener.LabelLinkListener;
import spl.localization.LocalizationSupport;

public class ImportDialog
extends JDialog {
    public static final int NOMETA = 0;
    public static final int XMP = 1;
    public static final int CONTENT = 2;
    public static final int MRDLIB = 3;
    public static final int ONLYATTACH = 4;
    public static final int UPDATEEMPTYFIELDS = 5;
    private final JPanel contentPane;
    private final JCheckBox checkBoxDoNotShowAgain;
    private final JCheckBox useDefaultPDFImportStyle;
    private final JRadioButton radioButtonXmp;
    private final JRadioButton radioButtonPDFcontent;
    private final JRadioButton radioButtonMrDlib;
    private final JRadioButton radioButtonNoMeta;
    private final JRadioButton radioButtononlyAttachPDF;
    private final JRadioButton radioButtonUpdateEmptyFields;
    private int result;

    public ImportDialog(boolean bl, String string) {
        String string2;
        Boolean bl2 = bl;
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BorderLayout());
        this.setContentPane(this.contentPane);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(new Color(-1643275));
        JLabel jLabel = new JLabel(Globals.lang("Import_Metadata_from:"));
        jLabel.setFont(new Font(jLabel.getFont().getName(), 1, 14));
        JLabel jLabel2 = new JLabel(Globals.lang("Choose_the_source_for_the_metadata_import"));
        jLabel2.setFont(new Font(jLabel2.getFont().getName(), jLabel2.getFont().getStyle(), 13));
        JLabel jLabel3 = new JLabel();
        jLabel3.setFont(new Font(jLabel.getFont().getName(), 1, 14));
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jLabel);
        jPanel2.add(jLabel3);
        jPanel2.setBackground(new Color(-1643275));
        GridLayout gridLayout = new GridLayout(2, 1);
        gridLayout.setVgap(10);
        gridLayout.setHgap(10);
        jPanel.setLayout(gridLayout);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.add(jPanel2);
        jPanel.add(jLabel2);
        this.radioButtonNoMeta = new JRadioButton(Globals.lang("Create_blank_entry_linking_the_PDF"));
        this.radioButtonXmp = new JRadioButton(Globals.lang("Create_entry_based_on_XMP_data"));
        this.radioButtonPDFcontent = new JRadioButton(Globals.lang("Create_entry_based_on_content"));
        this.radioButtonMrDlib = new JRadioButton(Globals.lang("Create_entry_based_on_data_fetched_from"));
        this.radioButtononlyAttachPDF = new JRadioButton(Globals.lang("Only_attach_PDF"));
        this.radioButtonUpdateEmptyFields = new JRadioButton(Globals.lang("Update_empty_fields_with_data_fetched_from"));
        JLabel jLabel4 = new JLabel("Mr._dLib");
        jLabel4.setFont(new Font(jLabel4.getFont().getName(), 1, 13));
        jLabel4.setForeground(new Color(-16776961));
        JLabel jLabel5 = new JLabel("Mr._dLib");
        jLabel5.setFont(new Font(jLabel4.getFont().getName(), 1, 13));
        jLabel5.setForeground(new Color(-16776961));
        JButton jButton = new JButton(Globals.lang("Ok"));
        JButton jButton2 = new JButton(Globals.lang("Cancel"));
        this.checkBoxDoNotShowAgain = new JCheckBox(Globals.lang("Do not show this box again for this import"));
        this.useDefaultPDFImportStyle = new JCheckBox(Globals.lang("Always use this PDF import style (and do not ask for each import)"));
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(new FormLayout("left:pref, 5dlu, left:pref:grow", ""));
        defaultFormBuilder.appendSeparator(Globals.lang("Create New Entry"));
        defaultFormBuilder.append((Component)this.radioButtonNoMeta, 3);
        defaultFormBuilder.append((Component)this.radioButtonXmp, 3);
        defaultFormBuilder.append((Component)this.radioButtonPDFcontent, 3);
        defaultFormBuilder.append(this.radioButtonMrDlib);
        defaultFormBuilder.append(jLabel4);
        defaultFormBuilder.appendSeparator(Globals.lang("Update_Existing_Entry"));
        defaultFormBuilder.append((Component)this.radioButtononlyAttachPDF, 3);
        defaultFormBuilder.append(this.radioButtonUpdateEmptyFields);
        defaultFormBuilder.append(jLabel5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.checkBoxDoNotShowAgain);
        defaultFormBuilder.append(this.useDefaultPDFImportStyle);
        defaultFormBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton((JComponent)jButton);
        buttonBarBuilder.addButton((JComponent)jButton2);
        buttonBarBuilder.addGlue();
        buttonBarBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.contentPane.add((Component)jPanel, "North");
        this.contentPane.add((Component)defaultFormBuilder.getPanel(), "Center");
        this.contentPane.add((Component)buttonBarBuilder.getPanel(), "South");
        if (!bl2.booleanValue()) {
            this.radioButtononlyAttachPDF.setEnabled(false);
            this.radioButtonUpdateEmptyFields.setEnabled(false);
            jLabel5.setEnabled(false);
        }
        if ((string2 = new File(string).getName()).length() < 34) {
            jLabel3.setText(string2);
        } else {
            jLabel3.setText(new File(string).getName().substring(0, 33) + "...");
        }
        jLabel4.addMouseListener(new LabelLinkListener(jLabel4, "www.mr-dlib.org/docs/pdf_metadata_extraction.php"));
        jLabel5.addMouseListener(new LabelLinkListener(jLabel5, "www.mr-dlib.org/docs/pdf_metadata_extraction.php"));
        this.setTitle(LocalizationSupport.message("Import_Metadata_From_PDF"));
        this.setModal(true);
        this.getRootPane().setDefaultButton(jButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.radioButtonNoMeta);
        buttonGroup.add(this.radioButtonXmp);
        buttonGroup.add(this.radioButtonPDFcontent);
        buttonGroup.add(this.radioButtonMrDlib);
        buttonGroup.add(this.radioButtononlyAttachPDF);
        buttonGroup.add(this.radioButtonUpdateEmptyFields);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImportDialog.this.onOK();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImportDialog.this.onCancel();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ImportDialog.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImportDialog.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        switch (Globals.prefs.getInt("importDefaultPDFimportStyle")) {
            case 0: {
                this.radioButtonNoMeta.setSelected(true);
                break;
            }
            case 1: {
                this.radioButtonXmp.setSelected(true);
                break;
            }
            case 2: {
                this.radioButtonPDFcontent.setSelected(true);
                break;
            }
            case 3: {
                this.radioButtonMrDlib.setSelected(true);
                break;
            }
            case 4: {
                this.radioButtononlyAttachPDF.setSelected(true);
                break;
            }
            case 5: {
                this.radioButtonUpdateEmptyFields.setSelected(true);
                break;
            }
            default: {
                this.radioButtonPDFcontent.setSelected(true);
            }
        }
        this.setSize(555, 371);
    }

    private void onOK() {
        this.result = 0;
        Globals.prefs.putInt("importDefaultPDFimportStyle", this.getChoice());
        if (this.useDefaultPDFImportStyle.isSelected()) {
            Globals.prefs.putBoolean("importAlwaysUsePDFImportStyle", true);
        }
        this.dispose();
    }

    private void onCancel() {
        this.result = 2;
        this.dispose();
    }

    public void showDialog() {
        this.pack();
        this.setVisible(true);
    }

    public int getChoice() {
        if (this.radioButtonXmp.isSelected()) {
            return 1;
        }
        if (this.radioButtonPDFcontent.isSelected()) {
            return 2;
        }
        if (this.radioButtonMrDlib.isSelected()) {
            return 3;
        }
        if (this.radioButtonNoMeta.isSelected()) {
            return 0;
        }
        if (this.radioButtononlyAttachPDF.isSelected()) {
            return 4;
        }
        if (this.radioButtonUpdateEmptyFields.isSelected()) {
            return 5;
        }
        throw new IllegalStateException();
    }

    public boolean getDoNotShowAgain() {
        return this.checkBoxDoNotShowAgain.isSelected();
    }

    public int getResult() {
        return this.result;
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    public void disableXMPChoice() {
        this.radioButtonXmp.setEnabled(false);
    }
}

