/*
 * Decompiled with CFR 0.152.
 */
package jpdftweak.cli;

import com.itextpdf.text.DocumentException;
import java.io.IOException;
import jpdftweak.cli.CommandOption;
import jpdftweak.core.PdfInputFile;
import jpdftweak.core.PdfToImage;
import jpdftweak.core.PdfTweak;

public class BurstImagesOption
implements CommandOption {
    private PdfToImage.ColorMode colorMode = PdfToImage.ColorMode.RGB;
    private PdfToImage.ImageType fileType;
    private PdfToImage.TiffCompression compressionType = PdfToImage.TiffCompression.NONE;
    private int quality = 100;
    private boolean transparent = false;

    public boolean supportsOption(String string) {
        return string.equals("-colormode") || string.equals("-tiffcompression") || string.equals("-transparency") || string.equals("-imagequality") || string.equals("-burstfiletype");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setOption(String string, String string2) throws IOException, DocumentException {
        if (string.equals("-colormode")) {
            try {
                this.colorMode = PdfToImage.ColorMode.valueOf(string2);
            }
            catch (Throwable throwable) {
                throw new DocumentException("Please refer to \"-help -colormode\"");
            }
        }
        if (string.equals("-tiffcompression")) {
            try {
                this.compressionType = PdfToImage.TiffCompression.valueOf(string2);
            }
            catch (Throwable throwable) {
                throw new DocumentException("Please refer to \"-help -tiffcompression\"");
            }
        }
        if (string.equals("-transparency")) {
            if (string2.equals("YES")) {
                this.transparent = true;
            } else {
                if (!string2.equals("NO")) throw new DocumentException("Please refer to \"-help -transparency\"");
                this.transparent = false;
            }
        } else if (string.equals("-imagequality")) {
            if (!this.checkQuality(string2)) {
                throw new DocumentException("Please refer to \"-help -imagequality\"");
            }
            this.quality = Integer.parseInt(string2);
        } else if (string.equals("-burstfiletype")) {
            try {
                this.fileType = PdfToImage.ImageType.valueOf(string2);
            }
            catch (Throwable throwable) {
                throw new DocumentException("Please refer to \"-help -burstfiletype\"");
            }
        }
        if (string2.equals("PDF")) return true;
        String string3 = PdfToImage.getJarFolder();
        try {
            PdfToImage.setJavaLibraryPath();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            System.err.println("Error: Could not change Java Library Path " + noSuchFieldException);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Error: Could not change Java Library Path " + illegalAccessException);
        }
        String string4 = PdfToImage.checkForLibraries();
        if (string4 == null) return true;
        if (string4.equals("nojmupdf")) {
            throw new DocumentException("\"JmuPdf.jar\" does not exist in lib folder");
        }
        if (!string4.contains(".")) return true;
        throw new DocumentException("\"" + string4 + "\" does not exist in \"" + string3 + "\"");
    }

    private boolean checkQuality(String string) throws IOException {
        try {
            int n = Integer.parseInt(string);
            return n >= 0 && n <= 100;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public void run(PdfTweak pdfTweak, PdfInputFile pdfInputFile) throws IOException, DocumentException {
        if (this.fileType != null && this.fileType != PdfToImage.ImageType.PDF) {
            if (this.fileType == PdfToImage.ImageType.TIFF && this.colorMode != PdfToImage.ColorMode.RGB) {
                this.transparent = false;
            }
            pdfTweak.setPdfImages(new PdfToImage(true, this.colorMode, this.fileType, this.compressionType, this.quality, this.transparent));
        } else {
            pdfTweak.setPdfImages(new PdfToImage(false, this.colorMode, this.fileType, this.compressionType, this.quality, this.transparent));
        }
    }

    public String getSummary() {
        return " -colormode              Set the color mode of the exported images\n -tiffcompression        Set compression type for TIFF image files\n -transparency           Set if your image has transparent layers\n -imagequality           Set the quality for the exported images\n -burstfiletype          Set the file type of the burst pages\n";
    }

    public String getHelp(String string) {
        if (string.equals("-colormode")) {
            return " -colormode {MODE}\n    Set the color mode of the exported images\n\t accepted values:{RGB, GRAY, BNW, BNWI}]\n\t *option applicable only on burst pages function.\n";
        }
        if (string.equals("-tiffcompression")) {
            return " -tiffcompression {COMPRESSIONTYPE}\n    Set compression type for TIFF image files\n\t accepted values:{NONE, LWZ, JPEG, ZLIB, PACKBITS, DEFLATE}\n\t *option applicable only on burst pages function \n";
        }
        if (string.equals("-transparency")) {
            return " -transparency {YES/NO}\n    Set if your image has transparent layers\n\t accepted values:{YES, NO}\n\t *option applicable only on burst pages function \n     and PNG,TIFF,PAM,GIF images\n";
        }
        if (string.equals("-imagequality")) {
            return " -imagequality {0-100}\n    Set the quality for the exported images\n\t accepted values:{Integers [0,100]}\n\t *option applicable only on burst pages function \n";
        }
        return " -burstfiletype {FILETYPE}\n    Set the file type of the burst pages\n\t accepted values:{PDF, JPG, PNG, GIF, PAM, PNM, BMP, TIFF}\n\t *option applicable only on burst pages function\n";
    }
}

