/*
 * Decompiled with CFR 0.152.
 */
package jpdftweak.cli;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfPageLabels;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import jpdftweak.cli.CommandOption;
import jpdftweak.core.PdfBookmark;
import jpdftweak.core.PdfInputFile;
import jpdftweak.core.PdfTweak;

public class InfoOption
implements CommandOption {
    String infoFilename = null;
    boolean moreInfo = false;
    boolean savebookmarks = false;

    public boolean supportsOption(String string) {
        return string.equals("-info") || string.equals("-moreinfo") || string.equals("-savebookmarks");
    }

    public boolean setOption(String string, String string2) {
        this.infoFilename = string2;
        this.moreInfo = string.equals("-moreinfo");
        this.savebookmarks = string.equals("-savebookmarks");
        return true;
    }

    public void run(PdfTweak pdfTweak, PdfInputFile pdfInputFile) throws IOException, DocumentException {
        if ("-".equals(this.infoFilename)) {
            this.writeInfo(System.out, pdfInputFile, this.moreInfo);
        } else if (this.infoFilename != null) {
            this.writeInfo(new FileOutputStream(this.infoFilename), pdfInputFile, this.moreInfo);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeInfo(OutputStream outputStream, PdfInputFile pdfInputFile, boolean bl) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        if (this.savebookmarks) {
            for (PdfBookmark pdfBookmark : pdfInputFile.getBookmarks(1)) {
                String string;
                String string2 = pdfBookmark.toString();
                if (!string2.equals(string = PdfBookmark.parseBookmark(string2).toString())) {
                    throw new RuntimeException(string2 + " != " + string);
                }
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
            }
        } else {
            bufferedWriter.write("PAGECOUNT " + pdfInputFile.getPageCount());
            bufferedWriter.newLine();
            bufferedWriter.write("ENCRYPTION " + pdfInputFile.getCryptoMode() + (pdfInputFile.isMetadataEncrypted() ? " METADATA" : "") + this.printPermissions(pdfInputFile.getPermissions()));
            bufferedWriter.newLine();
            bufferedWriter.write("    OWNERPW " + pdfInputFile.getOwnerPassword());
            bufferedWriter.newLine();
            bufferedWriter.write("    USERPW " + pdfInputFile.getUserPassword());
            bufferedWriter.newLine();
            for (Map.Entry<String, String> object2 : pdfInputFile.getInfoDictionary().entrySet()) {
                bufferedWriter.write("DOCINFO " + object2.getKey() + "=" + object2.getValue());
                bufferedWriter.newLine();
            }
            PdfPageLabels.PdfPageLabelFormat[] pdfPageLabelFormatArray = pdfInputFile.getPageLabels();
            if (pdfPageLabelFormatArray != null) {
                for (PdfPageLabels.PdfPageLabelFormat pdfPageLabelFormat : pdfPageLabelFormatArray) {
                    bufferedWriter.write("PAGELABELS " + pdfPageLabelFormat.physicalPage + "=" + (pdfPageLabelFormat.prefix == "" ? "" : pdfPageLabelFormat.prefix + ":") + pdfPageLabelFormat.logicalPage + (pdfPageLabelFormat.numberStyle == 0 ? "" : Character.valueOf("xIiAa-".charAt(pdfPageLabelFormat.numberStyle))));
                    bufferedWriter.newLine();
                }
            }
            if (bl) {
                void var6_13;
                for (PdfBookmark pdfBookmark : pdfInputFile.getBookmarks(1)) {
                    String string;
                    String string3 = pdfBookmark.toString();
                    if (!string3.equals(string = PdfBookmark.parseBookmark(string3).toString())) {
                        throw new RuntimeException(string3 + " != " + string);
                    }
                    bufferedWriter.write("BOOKMARK " + string3);
                    bufferedWriter.newLine();
                }
                Rectangle rectangle = new Rectangle(0.0f, 0.0f);
                int n = 0;
                for (int i = 1; i <= pdfInputFile.getPageCount(); ++i) {
                    Rectangle rectangle2 = pdfInputFile.getPageSize(i);
                    if (rectangle2.getWidth() == var6_13.getWidth() && rectangle2.getHeight() == var6_13.getHeight()) continue;
                    if (n != 0) {
                        bufferedWriter.write("PAGESIZE " + n + "-" + i + " " + var6_13.getWidth() + "x" + var6_13.getHeight());
                        bufferedWriter.newLine();
                    }
                    Rectangle rectangle3 = rectangle2;
                    n = i;
                }
                if (n != 0) {
                    bufferedWriter.write("PAGESIZE " + n + "-" + pdfInputFile.getPageCount() + " " + var6_13.getWidth() + "x" + var6_13.getHeight());
                    bufferedWriter.newLine();
                }
            }
        }
        bufferedWriter.flush();
        if (outputStream != System.out) {
            bufferedWriter.close();
        }
    }

    private String printPermissions(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < PdfTweak.permissionTexts.length; ++i) {
            if ((n & PdfTweak.permissionBits[i]) == 0) continue;
            stringBuffer.append(" ").append(PdfTweak.permissionTexts[i]);
        }
        return stringBuffer.toString();
    }

    public String getSummary() {
        return " -info                   Show information about a PDF file.\n -moreinfo               Show more information about a PDF file.\n -savebookmarks          Save PDF bookmarks to CSV file\n";
    }

    public String getHelp(String string) {
        String string2;
        if (string.equals("-info")) {
            string2 = "Write information about the input PDF file";
        } else if (string.equals("-moreinfo")) {
            string2 = "Write more information about the input PDF file";
        } else if (string.equals("-savebookmarks")) {
            string2 = "Save PDF bookmarks";
        } else {
            throw new RuntimeException();
        }
        return " " + string + " {TEXTFILE}\n" + "    " + string2 + " to {TEXTFILE}.\n" + " " + string + " -\n" + "    " + string2 + " to standard output.";
    }
}

