/*
 * Decompiled with CFR 0.152.
 */
package jpdftweak.cli;

import com.itextpdf.text.DocumentException;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jpdftweak.cli.CommandOption;
import jpdftweak.core.PdfInputFile;
import jpdftweak.core.PdfTweak;

public class ScaleOption
implements CommandOption {
    boolean enabled;
    boolean center;
    boolean preserveRatio;
    float width;
    float height;

    public boolean supportsOption(String string) {
        return string.equals("-scale");
    }

    public boolean setOption(String string, String string2) {
        if (this.enabled) {
            System.err.println("Error: more than one -scale option used.");
            return false;
        }
        Matcher matcher = Pattern.compile("([0-9.]+),([0-9.]+)(,[cr]*)?").matcher(string2);
        if (!matcher.matches()) {
            System.err.println("Error: Could not parse -scale option: " + string2);
            return false;
        }
        this.enabled = true;
        this.width = Float.parseFloat(matcher.group(1));
        this.height = Float.parseFloat(matcher.group(2));
        String string3 = matcher.group(3);
        if (string3 == null) {
            string3 = "";
        }
        this.center = string3.contains("c");
        this.preserveRatio = !string3.contains("r");
        return true;
    }

    public void run(PdfTweak pdfTweak, PdfInputFile pdfInputFile) throws IOException, DocumentException {
        if (this.enabled) {
            pdfTweak.scalePages(this.width, this.height, this.center, this.preserveRatio);
        }
    }

    public String getSummary() {
        return " -scale                  Scale pages\n";
    }

    public String getHelp(String string) {
        return " -scale {WIDTH},{HEIGHT}[,{OPTIONS}]\n    Scale all pages to fit to new page size.\n    If {OPTIONS} includes \"c\", center pages instead of enlarging them,\n    \"r\" in {OPTIONS} ignores aspect ratio.\n    Specify {WIDTH} and {HEIGHT} in postscript points.";
    }
}

