/*
 * Decompiled with CFR 0.152.
 */
package jpdftweak.cli;

import com.itextpdf.text.DocumentException;
import java.io.IOException;
import jpdftweak.cli.CommandOption;
import jpdftweak.core.PdfInputFile;
import jpdftweak.core.PdfTweak;
import jpdftweak.core.ShuffleRule;

public class ShuffleOption
implements CommandOption {
    String shuffleRule = null;

    public boolean supportsOption(String string) {
        return string.equals("-shuffle");
    }

    public boolean setOption(String string, String string2) {
        if (this.shuffleRule != null) {
            System.err.println("Error: more than one -shuffle option used.");
            return false;
        }
        this.shuffleRule = string2;
        return true;
    }

    public void run(PdfTweak pdfTweak, PdfInputFile pdfInputFile) throws IOException, DocumentException {
        if (this.shuffleRule != null) {
            int[] nArray = new int[2];
            ShuffleRule[] shuffleRuleArray = ShuffleRule.parseRuleSet(this.shuffleRule, nArray);
            pdfTweak.shufflePages(nArray[0], nArray[1], shuffleRuleArray);
        }
    }

    public String getSummary() {
        return " -shuffle                Shuffle pages\n";
    }

    public String getHelp(String string) {
        return " -shuffle {RULE}\n   shuffle all pages. {RULE} uses the same syntax as used in the GUI.";
    }
}

