/*
 * Decompiled with CFR 0.152.
 */
package jpdftweak.cli;

import com.itextpdf.text.DocumentException;
import java.io.File;
import java.io.IOException;
import jpdftweak.cli.CommandOption;
import jpdftweak.core.PdfInputFile;
import jpdftweak.core.PdfTweak;

public class SignOptions
implements CommandOption {
    private String keystore = new File(System.getProperty("user.home"), ".keystore").getAbsolutePath();
    private String alias = "mykey";
    private int certlevel = 0;
    private boolean visible = false;
    private String passphrase = null;

    public boolean supportsOption(String string) {
        return string.equals("-keystore") || string.equals("-keyalias") || string.equals("-certlevel") || string.equals("-sign") || string.equals("-signvisible");
    }

    public boolean setOption(String string, String string2) {
        if (string.equals("-keystore")) {
            this.keystore = string2;
        } else if (string.equals("-keyalias")) {
            this.alias = string2;
        } else if (string.equals("-certlevel")) {
            this.certlevel = Integer.parseInt(string2);
        } else {
            this.passphrase = string2;
            this.visible = string.equals("-signvisible");
        }
        return true;
    }

    public void run(PdfTweak pdfTweak, PdfInputFile pdfInputFile) throws IOException, DocumentException {
        if (this.passphrase != null) {
            pdfTweak.setSignature(new File(this.keystore), this.alias, this.passphrase.toCharArray(), this.certlevel, this.visible);
        }
    }

    public String getSummary() {
        return " -sign                   Sign PDF\n -signvisible            Sign PDF and show signature on page 1\n -keystore               Set keystore filename for signing\n -keyalias               Set key alias for signing\n -certlevel              Set certification level\n";
    }

    public String getHelp(String string) {
        if (string.equals("-keystore")) {
            return " -keystore {FILENAME}\n    Set the keystore to get the signing key from.";
        }
        if (string.equals("-keyalias")) {
            return " -keyalias {ALIAS}\n    Set the alias of the signing key in the keystore.\n    Default is 'mykey'.";
        }
        if (string.equals("-certlevel")) {
            return " -certlevel {LEVEL}\n    Set the certification level of the new signature.\n    Available levels:\n        0 = Not certified (default)\n        1 = No changes allowed\n        2 = Form filling allowed\n        3 = Form filling and annotations allowed";
        }
        return " -sign {PASSPHRASE}\n -signvisible {PASSPHRASE}\n    Sign this pdf with the selected key.\n    Use {PASSPHRASE} to unlock key in keystore.\n    Signature will be visible on page 1 if -signvisible\n    is used.";
    }
}

