/*
 * Decompiled with CFR 0.152.
 */
package jpdftweak.cli;

import com.itextpdf.text.DocumentException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jpdftweak.cli.CommandOption;
import jpdftweak.core.PdfInputFile;
import jpdftweak.core.PdfTweak;

public class TransitionOption
implements CommandOption {
    private List<String> transitions = new ArrayList<String>();

    public boolean supportsOption(String string) {
        return string.equals("-trans") || string.equals("-transition") || string.equals("-transitionfile") || string.equals("-transfile");
    }

    public boolean setOption(String string, String string2) throws IOException {
        if (string.endsWith("file")) {
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));
            while ((string3 = bufferedReader.readLine()) != null) {
                this.transitions.add(string3);
            }
            bufferedReader.close();
        } else {
            this.transitions.add(string2);
        }
        return true;
    }

    public void run(PdfTweak pdfTweak, PdfInputFile pdfInputFile) throws IOException, DocumentException {
        Pattern pattern = Pattern.compile("(~?[0-9])(?:-(~?[0-9]))?:([A-Za-z_-]+),([0-9]+)(,[0-9]+)?");
        if (this.transitions.size() > 0) {
            for (String string : this.transitions) {
                Matcher matcher = pattern.matcher(string);
                if (matcher.matches()) {
                    int n;
                    int n2;
                    int n3 = Integer.parseInt(matcher.group(1).replace('~', '-'));
                    int n4 = n2 = matcher.group(2) == null ? n3 : Integer.parseInt(matcher.group(2).replace('~', '-'));
                    if (n3 < 0) {
                        n3 += pdfTweak.getPageCount() + 1;
                    }
                    if (n2 < 0) {
                        n2 += pdfTweak.getPageCount() + 1;
                    }
                    String string2 = matcher.group(3).replace('_', ' ');
                    int n5 = Arrays.asList(PdfTweak.TRANSITION_NAMES).indexOf(string2);
                    int n6 = Integer.parseInt(matcher.group(4));
                    int n7 = n = matcher.group(5) == null ? -1 : Integer.parseInt(matcher.group(5).substring(1));
                    if (n5 == -1) {
                        System.err.println("Skipping unknown transition name: " + string2);
                        continue;
                    }
                    for (int i = n3; i <= n2; ++i) {
                        pdfTweak.setTransition(i, n5, n6, n);
                    }
                    continue;
                }
                System.err.println("Skipping unparsable transition: " + string);
            }
        }
    }

    public String getSummary() {
        return " -trans[ition]           Add a page transition\n -trans[ition]file       Load page transitions from a file\n";
    }

    public String getHelp(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string2 : PdfTweak.TRANSITION_NAMES) {
            stringBuffer.append("\n    " + string2.replace(' ', '_'));
        }
        return " -trans[ition] {FROM}[-{TO}]:{TRANS},{DURATION}[,{PAGEDUR}]\n    Add page transition {TRANS} to pages {FROM} to {TO}.\n    The transition will have a duration of {DURATION}.\n    If {PAGEDUR} is given, these pages remain visible for\n    that many seconds.\n\n -trans[ition]file {FILENAME}\n    Load page transitions from a file. The format is the same\n    as in the -trans command.\n\n Available transitions:" + stringBuffer.toString();
    }
}

