/*
 * Decompiled with CFR 0.152.
 */
package jpdftweak.core;

import com.itextpdf.text.PageSize;
import com.itextpdf.text.Rectangle;

public class PageDimension {
    private final String name;
    private final float width;
    private final float height;
    private static PageDimension[] commonSizes = null;

    public static PageDimension[] getCommonSizes() {
        if (commonSizes == null) {
            commonSizes = new PageDimension[100];
            PageDimension.addCommonSize(0, "A4", PageSize.A4);
            PageDimension.addCommonSize(1, "Letter", PageSize.LETTER);
            PageDimension.addCommonSize(2, "Note", PageSize.NOTE);
            PageDimension.addCommonSize(3, "Legal", PageSize.LEGAL);
            PageDimension.addCommonSize(4, "Tabloid", PageSize.TABLOID);
            PageDimension.addCommonSize(5, "Executive", PageSize.EXECUTIVE);
            PageDimension.addCommonSize(6, "Postcard", PageSize.POSTCARD);
            PageDimension.addCommonSize(7, "A0", PageSize.A0);
            PageDimension.addCommonSize(8, "A1", PageSize.A1);
            PageDimension.addCommonSize(9, "A2", PageSize.A2);
            PageDimension.addCommonSize(10, "A3", PageSize.A3);
            PageDimension.addCommonSize(11, "A5", PageSize.A5);
            PageDimension.addCommonSize(12, "A6", PageSize.A6);
            PageDimension.addCommonSize(13, "A7", PageSize.A7);
            PageDimension.addCommonSize(14, "A8", PageSize.A8);
            PageDimension.addCommonSize(15, "A9", PageSize.A9);
            PageDimension.addCommonSize(16, "A10", PageSize.A10);
            PageDimension.addCommonSize(17, "B0", PageSize.B0);
            PageDimension.addCommonSize(18, "B1", PageSize.B1);
            PageDimension.addCommonSize(19, "B2", PageSize.B2);
            PageDimension.addCommonSize(20, "B3", PageSize.B3);
            PageDimension.addCommonSize(21, "B4", PageSize.B4);
            PageDimension.addCommonSize(22, "B5", PageSize.B5);
            PageDimension.addCommonSize(23, "B6", PageSize.B6);
            PageDimension.addCommonSize(24, "B7", PageSize.B7);
            PageDimension.addCommonSize(25, "B8", PageSize.B8);
            PageDimension.addCommonSize(26, "B9", PageSize.B9);
            PageDimension.addCommonSize(27, "B10", PageSize.B10);
            PageDimension.addCommonSize(28, "archE", PageSize.ARCH_E);
            PageDimension.addCommonSize(29, "archD", PageSize.ARCH_D);
            PageDimension.addCommonSize(30, "archC", PageSize.ARCH_C);
            PageDimension.addCommonSize(31, "archB", PageSize.ARCH_B);
            PageDimension.addCommonSize(32, "archA", PageSize.ARCH_A);
            PageDimension.addCommonSize(33, "American Foolscap", PageSize.FLSA);
            PageDimension.addCommonSize(34, "European Foolscap", PageSize.FLSE);
            PageDimension.addCommonSize(35, "Halfletter", PageSize.HALFLETTER);
            PageDimension.addCommonSize(36, "11x17", PageSize._11X17);
            PageDimension.addCommonSize(37, "Crown Quarto", PageSize.CROWN_QUARTO);
            PageDimension.addCommonSize(38, "Large Crown Quarto", PageSize.LARGE_CROWN_QUARTO);
            PageDimension.addCommonSize(39, "Crown Octavo", PageSize.CROWN_OCTAVO);
            PageDimension.addCommonSize(40, "Large Crown Octavo", PageSize.LARGE_CROWN_OCTAVO);
            PageDimension.addCommonSize(41, "Demy Octavo", PageSize.DEMY_OCTAVO);
            PageDimension.addCommonSize(42, "Demy Quarto", PageSize.DEMY_QUARTO);
            PageDimension.addCommonSize(43, "Royal Quarto", PageSize.ROYAL_QUARTO);
            PageDimension.addCommonSize(44, "Royal Octavo", PageSize.ROYAL_OCTAVO);
            PageDimension.addCommonSize(45, "Small paperback", PageSize.SMALL_PAPERBACK);
            PageDimension.addCommonSize(46, "Penguin small paperback", PageSize.PENGUIN_SMALL_PAPERBACK);
            PageDimension.addCommonSize(47, "Penguin large paperback", PageSize.PENGUIN_LARGE_PAPERBACK);
            PageDimension.commonSizes[96] = new PageDimension("Ledger", PageSize.LEDGER, false);
            PageDimension.commonSizes[97] = new PageDimension("ISO 7810 ID-1", PageSize.ID_1, false);
            PageDimension.commonSizes[98] = new PageDimension("ISO 7810 ID-2", PageSize.ID_2, false);
            PageDimension.commonSizes[99] = new PageDimension("ISO 7810 ID-3", PageSize.ID_3, false);
        }
        return commonSizes;
    }

    private static void addCommonSize(int n, String string, Rectangle rectangle) {
        if (rectangle.getWidth() > rectangle.getHeight()) {
            throw new RuntimeException(string);
        }
        PageDimension.commonSizes[n * 2] = new PageDimension(string + " Portrait", rectangle, false);
        PageDimension.commonSizes[n * 2 + 1] = new PageDimension(string + " Landscape", rectangle, true);
    }

    public PageDimension(String string, float f, float f2) {
        this.name = string;
        this.width = f;
        this.height = f2;
    }

    public PageDimension(String string, Rectangle rectangle, boolean bl) {
        this.name = string;
        this.width = bl ? rectangle.getHeight() : rectangle.getWidth();
        this.height = bl ? rectangle.getWidth() : rectangle.getHeight();
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public String toString() {
        return this.name;
    }
}

