/*
 * Decompiled with CFR 0.152.
 */
package jpdftweak.core;

import com.itextpdf.text.Document;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.exceptions.BadPasswordException;
import com.itextpdf.text.exceptions.InvalidPdfException;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfPageLabels;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.RandomAccessFileOrArray;
import com.itextpdf.text.pdf.SimpleBookmark;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jpdftweak.core.PdfBookmark;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfInputFile {
    private final File file;
    private final String ownerPassword;
    private PdfReader rdr;

    public PdfInputFile(File file, String string) throws IOException {
        this.file = file;
        this.ownerPassword = string;
        this.open();
    }

    private void open() throws IOException {
        try {
            RandomAccessFileOrArray randomAccessFileOrArray = new RandomAccessFileOrArray(this.file.getAbsolutePath(), false, true);
            this.open(new PdfReader(randomAccessFileOrArray, this.ownerPassword.getBytes("ISO-8859-1")));
        }
        catch (ExceptionConverter exceptionConverter) {
            ExceptionConverter exceptionConverter2;
            while (exceptionConverter2.getException() instanceof ExceptionConverter) {
                exceptionConverter2 = (ExceptionConverter)exceptionConverter2.getCause();
            }
            if (exceptionConverter2.getException() instanceof InvalidPdfException) {
                try {
                    this.open(new PdfReader(this.file.getAbsolutePath(), this.ownerPassword.getBytes("ISO-8859-1")));
                }
                catch (ExceptionConverter exceptionConverter3) {
                    throw exceptionConverter2;
                }
            }
            throw exceptionConverter2;
        }
    }

    private void open(PdfReader pdfReader) throws IOException {
        this.rdr = pdfReader;
        if (!this.rdr.isOpenedWithFullPermissions()) {
            throw new BadPasswordException("PdfReader not opened with owner password");
        }
        this.rdr.consolidateNamedDestinations();
        this.rdr.removeUnusedObjects();
        this.rdr.shuffleSubsetNames();
    }

    public void close() {
        this.rdr.close();
    }

    public void reopen() throws IOException {
        this.close();
        this.open();
    }

    public File getFile() {
        return this.file;
    }

    public int getPageCount() {
        return this.rdr.getNumberOfPages();
    }

    public Rectangle getPageSize(int n) {
        return this.rdr.getPageSizeWithRotation(n);
    }

    public String toString() {
        return this.file.getName();
    }

    protected PdfReader getReader() {
        return this.rdr;
    }

    protected PdfImportedPage getImportedPage(PdfWriter pdfWriter, int n) {
        return pdfWriter.getImportedPage(this.rdr, n);
    }

    public Map<String, String> getInfoDictionary() {
        HashMap<String, String> hashMap = this.rdr.getInfo();
        if (hashMap.containsKey("Producer") && ((String)hashMap.get("Producer")).indexOf(Document.getProduct()) == -1) {
            hashMap.put("Producer", (String)hashMap.get("Producer") + "; modified by jPDF Tweak " + "1.1" + " (based on " + Document.getVersion() + ")");
        }
        return hashMap;
    }

    public int getCryptoMode() {
        return this.rdr.getCryptoMode();
    }

    public boolean isMetadataEncrypted() {
        return this.rdr.isMetadataEncrypted();
    }

    public int getPermissions() {
        if (this.rdr.getCryptoMode() == 0) {
            return this.rdr.getPermissions() & 0xFFFF00FF;
        }
        return this.rdr.getPermissions();
    }

    public String getOwnerPassword() {
        return this.ownerPassword == null ? "" : this.ownerPassword;
    }

    public String getUserPassword() {
        byte[] byArray = this.rdr.computeUserPassword();
        if (byArray == null) {
            return "";
        }
        return new String(byArray);
    }

    public List<PdfBookmark> getBookmarks(int n) {
        List<HashMap> list = SimpleBookmark.getBookmark(this.rdr);
        return PdfBookmark.parseBookmarks(list, n);
    }

    public PdfPageLabels.PdfPageLabelFormat[] getPageLabels() {
        return PdfPageLabels.getPageLabelFormats(this.rdr);
    }
}

