/*
 * Decompiled with CFR 0.152.
 */
package jpdftweak.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import jpdftweak.gui.TableComponentModel;

public class TableComponent
extends JPanel {
    private final JScrollPane jsp;
    private final JButton add;
    private final JButton up;
    private final JButton down;
    private final JButton delete;
    private final JTable jt;
    private final TableComponentModel tcm;
    private final Object[] sample;

    public TableComponent(String[] stringArray, Class[] classArray, Object[] objectArray) {
        if (objectArray.length != classArray.length) {
            throw new IllegalArgumentException();
        }
        this.sample = objectArray;
        this.setLayout((LayoutManager)new FormLayout("f:p:g,f:p:g,f:p:g,f:p:g", "f:p:g, f:p"));
        CellConstraints cellConstraints = new CellConstraints();
        this.tcm = new TableComponentModel(stringArray, classArray);
        this.jt = new JTable(this.tcm);
        this.jsp = new JScrollPane(this.jt);
        this.add((Component)this.jsp, cellConstraints.xyw(1, 1, 4));
        this.jsp.setPreferredSize(new Dimension(750, 400));
        this.add = new JButton("Add");
        this.add((Component)this.add, cellConstraints.xy(1, 2));
        this.add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TableComponent.this.jt.getCellEditor() != null && !TableComponent.this.jt.getCellEditor().stopCellEditing()) {
                    return;
                }
                TableComponent.this.tcm.addRow(TableComponent.this.sample);
            }
        });
        this.jt.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                if (TableComponent.this.jt.getEditorComponent() != null) {
                    TableComponent.this.jt.getEditorComponent().addFocusListener(new FocusAdapter(){

                        public void focusLost(FocusEvent focusEvent) {
                            if (TableComponent.this.jt.getCellEditor() != null) {
                                TableComponent.this.jt.getCellEditor().stopCellEditing();
                            }
                        }
                    });
                }
            }
        });
        this.up = new JButton("Up");
        this.add((Component)this.up, cellConstraints.xy(2, 2));
        this.up.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = TableComponent.this.jt.getSelectedRow();
                if (n == -1 || n == 0) {
                    return;
                }
                if (TableComponent.this.jt.getCellEditor() != null && !TableComponent.this.jt.getCellEditor().stopCellEditing()) {
                    return;
                }
                TableComponent.this.tcm.moveRow(n, -1);
                TableComponent.this.jt.getSelectionModel().setSelectionInterval(n - 1, n - 1);
            }
        });
        this.down = new JButton("Down");
        this.add((Component)this.down, cellConstraints.xy(3, 2));
        this.down.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = TableComponent.this.jt.getSelectedRow();
                if (n == -1 || n == TableComponent.this.tcm.getRowCount() - 1) {
                    return;
                }
                if (TableComponent.this.jt.getCellEditor() != null && !TableComponent.this.jt.getCellEditor().stopCellEditing()) {
                    return;
                }
                TableComponent.this.tcm.moveRow(n, 1);
                TableComponent.this.jt.getSelectionModel().setSelectionInterval(n + 1, n + 1);
            }
        });
        this.delete = new JButton("Delete");
        this.add((Component)this.delete, cellConstraints.xy(4, 2));
        this.delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = TableComponent.this.jt.getSelectedRowCount() - 1; i >= 0; --i) {
                    int n = TableComponent.this.jt.getSelectedRows()[i];
                    if (TableComponent.this.jt.getCellEditor() != null && !TableComponent.this.jt.getCellEditor().stopCellEditing()) {
                        return;
                    }
                    TableComponent.this.tcm.deleteRow(n);
                }
            }
        });
    }

    public void setEnabled(boolean bl) {
        this.add.setEnabled(bl);
        this.up.setEnabled(bl);
        this.down.setEnabled(bl);
        this.delete.setEnabled(bl);
        this.jsp.setEnabled(bl);
        this.jt.setEnabled(bl);
        super.setEnabled(bl);
    }

    public void clear() {
        if (this.jt.getCellEditor() != null && !this.jt.getCellEditor().stopCellEditing()) {
            return;
        }
        this.tcm.clear();
    }

    public void addRow(Object ... objectArray) {
        if (this.jt.getCellEditor() != null && !this.jt.getCellEditor().stopCellEditing()) {
            return;
        }
        this.tcm.addRow(objectArray);
    }

    public JTable getTable() {
        return this.jt;
    }

    public int getRowCount() {
        return this.tcm.getRowCount();
    }

    public Object[] getRow(int n) {
        return this.tcm.getRow(n);
    }

    public JComponent getScrollPane() {
        return this.jsp;
    }

    public void setRowListener(TableComponentModel.RowListener rowListener) {
        this.tcm.setRowListener(rowListener);
    }

    public void checkRun(String string) throws IOException {
        if (this.jt.getCellEditor() != null && !this.jt.getCellEditor().stopCellEditing()) {
            throw new IOException("Please finish editing the " + string + " table!");
        }
    }
}

