/*
 * Decompiled with CFR 0.152.
 */
package com.jmupdf;

import com.jmupdf.Document;
import com.jmupdf.JmuPdf;
import com.jmupdf.PageLinks;
import com.jmupdf.PageRect;
import com.jmupdf.PageRenderer;
import com.jmupdf.PageText;
import com.jmupdf.interfaces.PageTypes;

public class Page
extends JmuPdf
implements PageTypes {
    private Document document;
    private PageRect mediabox;
    private PageLinks[] pageLinks;
    private int pn;
    private int px;
    private int py;
    private int pw;
    private int ph;
    private int pr;

    public Page(Document pdfDoc, int page) {
        this.document = pdfDoc;
        this.pn = page;
        this.loadPageInfo();
    }

    public int getPageNumber() {
        return this.pn;
    }

    public PageRect getMediaBox() {
        return this.mediabox;
    }

    public int getX() {
        return this.px;
    }

    public int getY() {
        return this.py;
    }

    public int getWidth() {
        return this.pw;
    }

    public int getHeight() {
        return this.ph;
    }

    public int getRotation() {
        return this.pr;
    }

    public Document getDocument() {
        return this.document;
    }

    public String getText() {
        return this.getText(null, this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public String getText(PageRenderer renderer, int x, int y, int w, int h) {
        String text = "";
        PageText[] pdfTextSpan = this.getTextSpan(renderer, x, y, w, h);
        if (pdfTextSpan == null) {
            return text;
        }
        int i = 0;
        while (i < pdfTextSpan.length) {
            text = String.valueOf(text) + pdfTextSpan[i].getText();
            if (pdfTextSpan[i].isEndOfLine()) {
                if (i == pdfTextSpan.length - 1) {
                    text = String.valueOf(text) + "\n";
                } else if (pdfTextSpan[i].getY0() == pdfTextSpan[i + 1].getY0()) {
                    int len = pdfTextSpan[i + 1].getX1() - pdfTextSpan[i].getX1();
                    if (len > 1) {
                        text = String.valueOf(text) + " ";
                    }
                } else {
                    text = String.valueOf(text) + "\n";
                }
            }
            ++i;
        }
        return text;
    }

    public PageText[] getTextSpan(PageRenderer renderer, int x, int y, int w, int h) {
        if (renderer == null) {
            return Page.getPageText(this.document.getHandle(), this.getPageNumber(), 1.0f, this.getRotation(), x, y, x + w, y + h);
        }
        int rotate = renderer.getNormalizedRotation();
        PageRect m = this.getMediaBox().scale(renderer.getZoom());
        m = m.rotate(m, rotate);
        PageRect r = new PageRect(x, y, x + w, y + h);
        r = r.rotate(m, -(rotate - this.getRotation()));
        x = r.getX();
        y = r.getY();
        w = r.getWidth();
        h = r.getHeight();
        return Page.getPageText(this.document.getHandle(), this.getPageNumber(), renderer.getZoom(), this.getRotation(), x, y, x + w, y + h);
    }

    public PageLinks[] getLinks(PageRenderer renderer) {
        if (this.pageLinks == null) {
            if (this.getDocument().getType() == 0) {
                this.pageLinks = Page.muPdfGetPageLinks(this.document.getHandle(), this.getPageNumber());
            } else if (this.getDocument().getType() == 1) {
                this.pageLinks = null;
            }
            if (this.pageLinks == null) {
                this.pageLinks = new PageLinks[1];
                this.pageLinks[0] = new PageLinks(0.0f, 0.0f, 0.0f, 0.0f, 0, "");
            } else if (renderer != null) {
                int rotate = renderer.getNormalizedRotation();
                int i = 0;
                while (i < this.pageLinks.length) {
                    PageRect rect = new PageRect(this.pageLinks[i].getX0(), this.pageLinks[i].getY0(), this.pageLinks[i].getX1(), this.pageLinks[i].getY1());
                    rect = rect.translate(this.getMediaBox());
                    rect = rect.rotate(this.getMediaBox(), rotate);
                    rect = rect.scale(renderer.getZoom());
                    this.pageLinks[i].setX0(rect.getX0());
                    this.pageLinks[i].setY0(rect.getY0());
                    this.pageLinks[i].setX1(rect.getX1());
                    this.pageLinks[i].setY1(rect.getY1());
                    ++i;
                }
            }
        }
        return this.pageLinks;
    }

    private void loadPageInfo() {
        this.px = 0;
        this.py = 0;
        this.pw = 0;
        this.ph = 0;
        this.pr = 0;
        float[] pageInfo = Page.getPageInfo(this.document.getHandle(), this.getPageNumber());
        if (pageInfo != null) {
            this.mediabox = new PageRect(pageInfo[0], pageInfo[1], pageInfo[2], pageInfo[3]);
            this.px = this.mediabox.getX();
            this.py = this.mediabox.getY();
            this.pw = this.mediabox.getWidth();
            this.ph = this.mediabox.getHeight();
            this.pr = (int)pageInfo[4];
            if (this.pr == 90 || this.pr == 270) {
                PageRect r = this.mediabox.rotate(this.mediabox, this.pr);
                this.px = r.getX();
                this.py = r.getY();
                this.pw = r.getWidth();
                this.ph = r.getHeight();
            }
        }
    }
}

