/*
 * Decompiled with CFR 0.152.
 */
package com.jmupdf;

import com.jmupdf.interfaces.PageTypes;

public class PageRect
implements PageTypes {
    private float p1x;
    private float p1y;
    private float p2x;
    private float p2y;
    private int x;
    private int y;
    private int w;
    private int h;

    public PageRect(float x0, float y0, float x1, float y1) {
        this.p1x = x0;
        this.p1y = y0;
        this.p2x = x1;
        this.p2y = y1;
        this.normalizeCoordinates(this.p1x, this.p1y, this.p2x, this.p2y);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public float getX0() {
        return this.p1x;
    }

    public float getY0() {
        return this.p1y;
    }

    public float getX1() {
        return this.p2x;
    }

    public float getY1() {
        return this.p2y;
    }

    public PageRect translate(PageRect mediabox) {
        float x1 = this.getX0();
        float y1 = mediabox.getY1() - mediabox.getY0() - this.getY1();
        float x2 = this.getX1() - this.getX0() + x1;
        float y2 = this.getY1() - this.getY0() + y1;
        return new PageRect(x1, y1, x2, y2);
    }

    public PageRect scale(float zoom) {
        return new PageRect(this.p1x * zoom, this.p1y * zoom, this.p2x * zoom, this.p2y * zoom);
    }

    public PageRect rotate(PageRect mediabox, int rotation) {
        if ((rotation %= 360) < 0) {
            rotation += 360;
        }
        if (rotation == 0 || rotation == 360) {
            return new PageRect(this.p1x, this.p1y, this.p2x, this.p2y);
        }
        float rad = (float)Math.toRadians(rotation);
        float cx = (mediabox.getX() + mediabox.getWidth()) / 2;
        float cy = (mediabox.getY() + mediabox.getHeight()) / 2;
        float[] r1 = this.rotate(mediabox, rad, cx, cy);
        float p_mbx1 = r1[0];
        float p_mby1 = r1[1];
        float p_mbx2 = r1[2];
        float p_mby2 = r1[3];
        float[] r2 = this.rotate(this, rad, cx, cy);
        float p_x1 = r2[0];
        float p_y1 = r2[1];
        float p_x2 = r2[2];
        float p_y2 = r2[3];
        float p_w = Math.abs(p_x2 - p_x1);
        float p_h = Math.abs(p_y2 - p_y1);
        float mbx1 = 0.0f;
        float mby1 = 0.0f;
        float x0 = 0.0f;
        float y0 = 0.0f;
        float x1 = 0.0f;
        float y1 = 0.0f;
        if (rotation == 90) {
            mbx1 = Math.max(p_mbx2, p_mby2) + Math.min(p_mbx1, p_mby1);
            mby1 = Math.max(p_mbx2, p_mby2) - Math.min(p_mbx1, p_mby1);
            x0 = mbx1 - Math.abs(p_mbx1 - p_x1) - p_w;
            y0 = Math.abs(p_mby1 - p_y1);
        } else if (rotation == 180) {
            mbx1 = p_mbx1;
            mby1 = p_mby1;
            x0 = mbx1 - Math.abs(p_mbx1 - p_x1) - p_w;
            y0 = mby1 - Math.abs(p_mby1 - p_y1) - p_h;
        } else if (rotation == 270) {
            mbx1 = Math.max(p_mbx2, p_mby2) - Math.min(p_mbx1, p_mby1);
            mby1 = Math.max(p_mbx2, p_mby2) + Math.min(p_mbx1, p_mby1);
            x0 = Math.abs(p_mbx1 - p_x1);
            y0 = mby1 - Math.abs(p_mby1 - p_y1) - p_h;
        }
        x1 = x0 + p_w;
        y1 = y0 + p_h;
        return new PageRect(x0, y0, x1, y1);
    }

    private float[] rotate(PageRect rect, float rad, float cx, float cy) {
        float[] cor = new float[4];
        float x0 = rect.getX0();
        float y0 = rect.getY0();
        float x1 = rect.getX1();
        float y1 = rect.getY1();
        cor[0] = (float)((double)(x0 - cx) * Math.cos(rad) - (double)(y0 - cy) * Math.sin(rad) + (double)cx);
        cor[1] = (float)((double)(x0 - cx) * Math.sin(rad) + (double)(y0 - cy) * Math.cos(rad) + (double)cy);
        cor[2] = (float)((double)(x1 - cx) * Math.cos(rad) - (double)(y1 - cy) * Math.sin(rad) + (double)cx);
        cor[3] = (float)((double)(x1 - cx) * Math.sin(rad) + (double)(y1 - cy) * Math.cos(rad) + (double)cy);
        return cor;
    }

    private void normalizeCoordinates(float x1, float y1, float x2, float y2) {
        this.x = (int)x1;
        this.y = (int)y1;
        this.w = (int)Math.abs(x2 - x1);
        this.h = (int)Math.abs(y2 - y1);
    }

    protected void log(String text) {
        System.out.println(text);
    }
}

