/*
 * Decompiled with CFR 0.152.
 */
package com.jmupdf.xps;

import com.jmupdf.Document;
import com.jmupdf.exceptions.DocException;
import com.jmupdf.exceptions.DocSecurityException;

public class XpsDocument
extends Document {
    public XpsDocument(String document) throws DocException, DocSecurityException {
        this.open(document, null, 1);
        this.validate();
    }

    public XpsDocument(byte[] document) throws DocException, DocSecurityException {
        this.open(document, null, 0);
        this.validate();
    }

    private void validate() throws DocException, DocSecurityException {
        if (this.getHandle() > 0L) {
            return;
        }
        if (this.getHandle() == -1L || this.getHandle() == -2L) {
            throw new DocException("Error " + this.getHandle() + ": Document " + this.getDocumentName() + " could not be opened.");
        }
        throw new DocException("Unexpected error opening document.");
    }

    public void dispose() {
        this.close();
    }

    public XpsDocument clone() {
        XpsDocument doc = null;
        if (this.getHandle() > 0L) {
            try {
                doc = new XpsDocument(this.getDocumentName());
            }
            catch (DocException e) {
                e.printStackTrace();
            }
            catch (DocSecurityException e) {
                e.printStackTrace();
            }
        }
        return doc;
    }

    protected void log(String text) {
        System.out.println(text);
    }
}

