/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingConstants;

public class LayoutControlPanel
extends JPanel
implements SwingConstants {
    private boolean absolutePositions;
    private SwingSet swing;
    private Vector controls;
    private DirectionPanel textPosition;
    private DirectionPanel labelAlignment;

    LayoutControlPanel(SwingSet swingSet, Vector vector) {
        Object object;
        JLabel jLabel;
        this.swing = swingSet;
        this.controls = vector;
        this.setLayout(new BoxLayout(this, 1));
        this.setAlignmentX(0.0f);
        this.setAlignmentY(0.0f);
        if (swingSet.componentOrientationChanger != null) {
            jLabel = new JLabel("Positioning:");
            this.add(jLabel);
            jLabel.setFont(swingSet.boldFont);
            ButtonGroup buttonGroup = new ButtonGroup();
            object = new PositioningListener();
            JRadioButton jRadioButton = new JRadioButton("Absolute");
            jRadioButton.setMnemonic('a');
            jRadioButton.setToolTipText("Text/Content positioning is independant of line direction");
            buttonGroup.add(jRadioButton);
            jRadioButton.addItemListener((ItemListener)object);
            this.add(jRadioButton);
            JRadioButton jRadioButton2 = new JRadioButton("Relative");
            jRadioButton2.setMnemonic('r');
            jRadioButton2.setToolTipText("Text/Content positioning depends on line direction.");
            buttonGroup.add(jRadioButton2);
            jRadioButton2.addItemListener((ItemListener)object);
            this.add(jRadioButton2);
            this.add(Box.createRigidArea(SwingSet.vpad20));
            this.absolutePositions = false;
            jRadioButton2.setSelected(true);
            swingSet.componentOrientationChanger.addActionListener(new OrientationChangeListener());
        } else {
            this.absolutePositions = true;
        }
        this.textPosition = new DirectionPanel(true, "E", new TextPositionListener());
        this.labelAlignment = new DirectionPanel(true, "C", new LabelAlignmentListener());
        int n = 0;
        while (n < vector.size()) {
            object = (Component)vector.elementAt(n);
            this.setPosition((Component)object, 4, 0);
            this.setAlignment((Component)object, 0, 0);
            ++n;
        }
        jLabel = new JLabel("Text Position:");
        this.add(jLabel);
        jLabel.setFont(swingSet.boldFont);
        this.add(this.textPosition);
        this.add(Box.createRigidArea(SwingSet.vpad20));
        jLabel = new JLabel("Content Alignment:");
        this.add(jLabel);
        jLabel.setFont(swingSet.boldFont);
        this.add(this.labelAlignment);
        this.add(Box.createGlue());
    }

    void setPosition(Component component, int n, int n2) {
        boolean bl = true;
        if (this.absolutePositions) {
            if (n == 10) {
                n = bl ? 2 : 4;
            } else if (n == 11) {
                n = bl ? 4 : 2;
            }
        } else if (n == 2) {
            n = bl ? 10 : 11;
        } else if (n == 4) {
            int n3 = n = bl ? 11 : 10;
        }
        if (component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            abstractButton.setHorizontalTextPosition(n);
            abstractButton.setVerticalTextPosition(n2);
            return;
        }
        if (component instanceof JLabel) {
            JLabel jLabel = (JLabel)component;
            jLabel.setHorizontalTextPosition(n);
            jLabel.setVerticalTextPosition(n2);
        }
    }

    void setAlignment(Component component, int n, int n2) {
        boolean bl = true;
        if (this.absolutePositions) {
            if (n == 10) {
                n = bl ? 2 : 4;
            } else if (n == 11) {
                n = bl ? 4 : 2;
            }
        } else if (n == 2) {
            n = bl ? 10 : 11;
        } else if (n == 4) {
            int n3 = n = bl ? 11 : 10;
        }
        if (component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            abstractButton.setHorizontalAlignment(n);
            abstractButton.setVerticalAlignment(n2);
            return;
        }
        if (component instanceof JLabel) {
            JLabel jLabel = (JLabel)component;
            jLabel.setHorizontalAlignment(n);
            jLabel.setVerticalAlignment(n2);
        }
    }

    class OrientationChangeListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (!actionEvent.getActionCommand().equals("OrientationChanged")) {
                return;
            }
            if (LayoutControlPanel.this.absolutePositions) {
                return;
            }
            String string = LayoutControlPanel.this.textPosition.getSelection();
            if (string.equals("NW")) {
                LayoutControlPanel.this.textPosition.setSelection("NE");
            } else if (string.equals("NE")) {
                LayoutControlPanel.this.textPosition.setSelection("NW");
            } else if (string.equals("E")) {
                LayoutControlPanel.this.textPosition.setSelection("W");
            } else if (string.equals("W")) {
                LayoutControlPanel.this.textPosition.setSelection("E");
            } else if (string.equals("SE")) {
                LayoutControlPanel.this.textPosition.setSelection("SW");
            } else if (string.equals("SW")) {
                LayoutControlPanel.this.textPosition.setSelection("SE");
            }
            String string2 = LayoutControlPanel.this.labelAlignment.getSelection();
            if (string2.equals("NW")) {
                LayoutControlPanel.this.labelAlignment.setSelection("NE");
                return;
            }
            if (string2.equals("NE")) {
                LayoutControlPanel.this.labelAlignment.setSelection("NW");
                return;
            }
            if (string2.equals("E")) {
                LayoutControlPanel.this.labelAlignment.setSelection("W");
                return;
            }
            if (string2.equals("W")) {
                LayoutControlPanel.this.labelAlignment.setSelection("E");
                return;
            }
            if (string2.equals("SE")) {
                LayoutControlPanel.this.labelAlignment.setSelection("SW");
                return;
            }
            if (string2.equals("SW")) {
                LayoutControlPanel.this.labelAlignment.setSelection("SE");
            }
        }

        OrientationChangeListener() {
            LayoutControlPanel.this = LayoutControlPanel.this;
        }
    }

    class PositioningListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            JRadioButton jRadioButton = (JRadioButton)itemEvent.getSource();
            if (jRadioButton.getText().equals("Absolute") && jRadioButton.isSelected()) {
                LayoutControlPanel.this.absolutePositions = true;
            } else if (jRadioButton.getText().equals("Relative") && jRadioButton.isSelected()) {
                LayoutControlPanel.this.absolutePositions = false;
            }
            int n = 0;
            while (n < LayoutControlPanel.this.controls.size()) {
                block9: {
                    int n2;
                    int n3;
                    int n4;
                    int n5;
                    Component component;
                    block8: {
                        block7: {
                            component = (Component)LayoutControlPanel.this.controls.elementAt(n);
                            if (!(component instanceof AbstractButton)) break block7;
                            n5 = ((AbstractButton)component).getHorizontalTextPosition();
                            n4 = ((AbstractButton)component).getVerticalTextPosition();
                            n3 = ((AbstractButton)component).getHorizontalAlignment();
                            n2 = ((AbstractButton)component).getVerticalAlignment();
                            break block8;
                        }
                        if (!(component instanceof JLabel)) break block9;
                        n5 = ((JLabel)component).getHorizontalTextPosition();
                        n4 = ((JLabel)component).getVerticalTextPosition();
                        n3 = ((JLabel)component).getHorizontalAlignment();
                        n2 = ((JLabel)component).getVerticalAlignment();
                    }
                    LayoutControlPanel.this.setPosition(component, n5, n4);
                    LayoutControlPanel.this.setAlignment(component, n3, n2);
                }
                ++n;
            }
            int n6 = ((LayoutControlPanel)LayoutControlPanel.this).swing.tabbedPane.getSelectedIndex();
            Component component = ((LayoutControlPanel)LayoutControlPanel.this).swing.tabbedPane.getComponentAt(n6);
            component.invalidate();
            component.validate();
            component.repaint();
        }

        PositioningListener() {
            LayoutControlPanel.this = LayoutControlPanel.this;
        }
    }

    class TextPositionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int n2;
            JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
            if (!jRadioButton.isSelected()) {
                return;
            }
            String string = jRadioButton.getActionCommand();
            if (string.equals("NW")) {
                n2 = 2;
                n = 1;
            } else if (string.equals("N")) {
                n2 = 0;
                n = 1;
            } else if (string.equals("NE")) {
                n2 = 4;
                n = 1;
            } else if (string.equals("W")) {
                n2 = 2;
                n = 0;
            } else if (string.equals("C")) {
                n2 = 0;
                n = 0;
            } else if (string.equals("E")) {
                n2 = 4;
                n = 0;
            } else if (string.equals("SW")) {
                n2 = 2;
                n = 3;
            } else if (string.equals("S")) {
                n2 = 0;
                n = 3;
            } else {
                n2 = 4;
                n = 3;
            }
            int n3 = 0;
            while (n3 < LayoutControlPanel.this.controls.size()) {
                Component component = (Component)LayoutControlPanel.this.controls.elementAt(n3);
                LayoutControlPanel.this.setPosition(component, n2, n);
                ++n3;
            }
            int n4 = ((LayoutControlPanel)LayoutControlPanel.this).swing.tabbedPane.getSelectedIndex();
            Component component = ((LayoutControlPanel)LayoutControlPanel.this).swing.tabbedPane.getComponentAt(n4);
            component.invalidate();
            component.validate();
            component.repaint();
        }

        TextPositionListener() {
            LayoutControlPanel.this = LayoutControlPanel.this;
        }
    }

    class LabelAlignmentListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int n2;
            JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
            if (!jRadioButton.isSelected()) {
                return;
            }
            String string = jRadioButton.getActionCommand();
            if (string.equals("NW")) {
                n2 = 2;
                n = 1;
            } else if (string.equals("N")) {
                n2 = 0;
                n = 1;
            } else if (string.equals("NE")) {
                n2 = 4;
                n = 1;
            } else if (string.equals("W")) {
                n2 = 2;
                n = 0;
            } else if (string.equals("C")) {
                n2 = 0;
                n = 0;
            } else if (string.equals("E")) {
                n2 = 4;
                n = 0;
            } else if (string.equals("SW")) {
                n2 = 2;
                n = 3;
            } else if (string.equals("S")) {
                n2 = 0;
                n = 3;
            } else {
                n2 = 4;
                n = 3;
            }
            int n3 = 0;
            while (n3 < LayoutControlPanel.this.controls.size()) {
                Component component = (Component)LayoutControlPanel.this.controls.elementAt(n3);
                LayoutControlPanel.this.setAlignment(component, n2, n);
                component.invalidate();
                ++n3;
            }
            int n4 = ((LayoutControlPanel)LayoutControlPanel.this).swing.tabbedPane.getSelectedIndex();
            Component component = ((LayoutControlPanel)LayoutControlPanel.this).swing.tabbedPane.getComponentAt(n4);
            component.invalidate();
            component.validate();
            component.repaint();
        }

        LabelAlignmentListener() {
            LayoutControlPanel.this = LayoutControlPanel.this;
        }
    }
}

