/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;

public class TreeCombo
extends JComboBox {
    static final int OFFSET = 16;
    static Border emptyBorder = new EmptyBorder(0, 0, 0, 0);

    public TreeCombo(TreeModel treeModel) {
        this.setModel(new TreeToListModel(treeModel));
        this.setRenderer(new ListEntryRenderer());
    }

    class TreeToListModel
    extends AbstractListModel
    implements ComboBoxModel,
    TreeModelListener {
        TreeModel source;
        boolean invalid = true;
        Object currentValue;
        Vector cache = new Vector();

        public TreeToListModel(TreeModel treeModel) {
            TreeCombo.this = TreeCombo.this;
            this.source = treeModel;
            treeModel.addTreeModelListener(this);
            TreeCombo.this.setRenderer(new ListEntryRenderer());
        }

        public void setSelectedItem(Object object) {
            this.currentValue = object;
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return this.currentValue;
        }

        public int getSize() {
            this.validate();
            return this.cache.size();
        }

        public Object getElementAt(int n) {
            return this.cache.elementAt(n);
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            this.invalid = true;
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            this.invalid = true;
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            this.invalid = true;
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            this.invalid = true;
        }

        void validate() {
            if (this.invalid) {
                this.cache = new Vector();
                this.cacheTree(this.source.getRoot(), 0);
                if (this.cache.size() > 0) {
                    this.currentValue = this.cache.elementAt(0);
                }
                this.invalid = false;
                this.fireContentsChanged(this, 0, 0);
            }
        }

        void cacheTree(Object object, int n) {
            if (this.source.isLeaf(object)) {
                this.addListEntry(object, n, false);
                return;
            }
            int n2 = this.source.getChildCount(object);
            this.addListEntry(object, n, true);
            ++n;
            int n3 = 0;
            while (n3 < n2) {
                Object object2 = this.source.getChild(object, n3);
                this.cacheTree(object2, n);
                ++n3;
            }
            --n;
        }

        void addListEntry(Object object, int n, boolean bl) {
            this.cache.addElement(new ListEntry(object, n, bl));
        }
    }

    class ListEntry {
        Object object;
        int level;
        boolean isNode;

        public ListEntry(Object object, int n, boolean bl) {
            TreeCombo.this = TreeCombo.this;
            this.object = object;
            this.level = n;
            this.isNode = bl;
        }

        public Object object() {
            return this.object;
        }

        public int level() {
            return this.level;
        }

        public boolean isNode() {
            return this.isNode;
        }
    }

    class ListEntryRenderer
    extends JLabel
    implements ListCellRenderer {
        ImageIcon leafIcon = SwingSet.sharedInstance().loadImageIcon("images/document.gif", "Document");
        ImageIcon nodeIcon = SwingSet.sharedInstance().loadImageIcon("images/folder.gif", "Folder");

        public ListEntryRenderer() {
            TreeCombo.this = TreeCombo.this;
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            ListEntry listEntry = (ListEntry)object;
            if (listEntry != null) {
                this.setText(listEntry.object().toString());
                this.setIcon(listEntry.isNode() ? this.nodeIcon : this.leafIcon);
                Border border = n != -1 ? new EmptyBorder(0, 16 * listEntry.level(), 0, 0) : emptyBorder;
                if (UIManager.getLookAndFeel().getName().equals("CDE/Motif")) {
                    if (n == -1) {
                        this.setOpaque(false);
                    } else {
                        this.setOpaque(true);
                    }
                } else {
                    this.setOpaque(true);
                }
                this.setBorder(border);
                if (bl) {
                    this.setBackground(UIManager.getColor("ComboBox.selectionBackground"));
                    this.setForeground(UIManager.getColor("ComboBox.selectionForeground"));
                } else {
                    this.setBackground(UIManager.getColor("ComboBox.background"));
                    this.setForeground(UIManager.getColor("ComboBox.foreground"));
                }
            } else {
                this.setText("");
            }
            return this;
        }
    }
}

