/*
 * @(#)MacBorders.java	1.2 99/04/22
 *
 * Copyright 1998, 1999 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 * 
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package com.sun.java.swing.plaf.mac;

import java.awt.*;
import javax.swing.plaf.*;
import javax.swing.*;
import javax.swing.plaf.basic.*;
import javax.swing.border.*;
import javax.swing.text.JTextComponent;
import javax.swing.text.DefaultEditorKit;

import java.awt.Font;
import java.awt.Color;
import java.awt.SystemColor;
import java.awt.event.KeyEvent;
import java.awt.event.InputEvent;

import java.net.URL;
import java.io.Serializable;


/**
 * Implements The Macintosh Platinum Look and Feel.
 * <p>
 *
 * @version 1.2 04/22/99
 * @author Steve Wilson
 */
public class MacBorders {

    static class ButtonBorder implements Border {
        private static Insets insets = new Insets(3,3,3,3);

        public void paintBorder(Component c, Graphics g, int x, int y,
                                int w, int h) {
            JButton button = (JButton)c;
            ButtonModel model = button.getModel();

            g.translate(x,y);
            if ( model.isEnabled() ) {
                if ( model.isPressed() && model.isArmed() ) {
                    drawPressedBorder(c,g,w,h);


                } else {
                    drawActiveBorder(c,g,w,h);

                }

            } else {
                drawOutlineBorder(c,g,
                                  MacLookAndFeel.getGray6(), w,h);
            }
        }

        private void drawActiveBorder(Component c, Graphics g, int w, int h) {
            drawOutlineBorder(c,g,
                              MacLookAndFeel.getBlack(), w,h);

            // corner dots
            g.setColor(MacLookAndFeel.getGray3());
            g.drawLine(1,2, 2,1);
            g.drawLine(w-2,2, w-3, 1);
            g.drawLine(1, h-3, 2, h-2);

            // white highlight
            g.setColor(MacLookAndFeel.getWhite());  
            g.drawLine(2,2, 2, h-4);
            g.drawLine(2,2, w-4, 2);
            g.drawLine(2,2,3,3);

            //shadow
            g.setColor(MacLookAndFeel.getGray4()); 
            g.drawLine(3, h-3, w-4, h-3);
            g.drawLine( w-4, h-4, w-4, h-4);
            g.drawLine( w-3, h-4, w-3, 3);

            //dark shadow
            g.setColor(MacLookAndFeel.getGray7()); 
            g.drawLine(3, h-2, w-3, h-2);
            g.drawLine( w-3, h-3, w-3, h-3);
            g.drawLine( w-2, h-3, w-2, 3);

        }

        private void drawPressedBorder(Component c, Graphics g, int w, int h) {
            drawOutlineBorder(c,g,
                              MacLookAndFeel.getBlack(), w,h);

            // dark shadow
            g.setColor(MacLookAndFeel.getGray10());
            g.drawLine(1,2, 1,h-3);
            g.drawLine(2,2, 2, 2);
            g.drawLine(2, 1, w-3, 1);

            //shadow
            g.setColor(MacLookAndFeel.getGray9());
            g.drawLine(2,3, 2,h-4);
            g.drawLine(3,3, 3, 3);
            g.drawLine(2, 2, w-4, 2);

            //highlight
            g.setColor(MacLookAndFeel.getGray7());
            g.drawLine(3,h-3, w-4,h-3);
            g.drawLine(w-3,3, w-3,h-4);
            g.drawLine(w-4,h-4, w-4,h-4);
            g.drawLine(3,h-2, 3,h-2);         
            g.drawLine(w-2,2, w-2,2);  

            //light highlight
            g.setColor(MacLookAndFeel.getGray6());
            g.drawLine(3,h-2, w-3,h-2);
            g.drawLine(w-2,3, w-2,h-4);
            g.drawLine(w-3,h-3, w-3,h-3);

        }

        private void drawOutlineBorder(Component c, Graphics g, 
                                       Color color, int w, int h) {
            g.setColor(color);
            g.drawLine(2,0, w-3, 0); //top
            g.drawLine(0,2,0, h-3); //left
            g.drawLine(2, h-1, w-3, h-1);   // bottom
            g.drawLine(w-1, 2, w-1, h-3);   //right

            g.drawLine(1,1,1,1);
            g.drawLine(w-2,1,w-2,1);
            g.drawLine(1,h-2,1,h-2);
            g.drawLine(w-2, h-2, w-2, h-2);

        }

        public boolean isBorderOpaque() {
            return true;
        }

        public Insets getBorderInsets(Component c) {
            return insets;
        }
    }


    static class DefaultButtonBorder implements Border {
        private static Insets insets = new Insets(3,3,3,3);
        private static Insets zeroInsets = new Insets(0,0,0,0);
        

        public void paintBorder(Component c, Graphics g, int x, int y,
                                int w, int h) {
            JButton button = (JButton)c;
            ButtonModel model = button.getModel();

            if (button.isDefaultButton()) {

               g.translate(x,y);
         
               g.setColor(MacLookAndFeel.getBlack());
               g.drawLine(3,0, w-4,0);  //top
               g.drawLine(3,h-1, w-4,h-1);  //bottom
               g.drawLine(0,3, 0,h-4);  //left
               g.drawLine(w-1,3, w-1,h-4);  //right

               g.drawLine(3,0, 0,3);
               g.drawLine(0, h-4, 3, h-1);
               g.drawLine(w-4, 0, w-1, 3);
               g.drawLine(w-4, h-1, w-1, h-4);
               
               g.setColor(MacLookAndFeel.getGray4());
               g.drawLine(4,2, w-4,2);  //top
               g.drawLine(3,h-3, w-5,h-3);  //bottom
               g.drawLine(2,4, 2,h-4);  //left
               g.drawLine(w-3,3, w-3,h-5);  //right
               
               g.drawLine(4,2, 2,4); 
               g.drawLine(w-5,h-3, w-3,h-5);                
               g.drawLine(3,h-4, 3,h-4); 
               g.drawLine(w-4,3, w-4,3); 

               g.setColor(MacLookAndFeel.getGray7());
               g.drawLine(3,4, 4,3); 
               g.drawLine(3,h-5, 4,h-4); 
               g.drawLine(w-4,h-5, w-5,h-4); 
               g.drawLine(w-4,4, w-5,3);

               g.drawLine(4,h-2, w-4,h-2); 
               g.drawLine(w-2,4, w-2,h-4);
               g.drawLine(w-3,h-3, w-3,h-3);

               g.setColor(MacLookAndFeel.getGray6());
               g.drawLine(w-4,h-3, w-3,h-4);
               g.drawLine(3,h-2, 3,h-2);
               g.drawLine(w-2, 3, w-2,3);

               g.setColor(MacLookAndFeel.getGray3());
               g.drawLine(1,h-4, 2,h-3);
               g.drawLine(w-4,1, w-3,2);

               g.translate(-x,-y);
               
            }
            
            
        }

 
        public boolean isBorderOpaque() {
            return true;
        }

        public Insets getBorderInsets(Component c) {
            JButton button = (JButton)c;
            if (button.isDefaultCapable()) {
               return insets;               
            }
            else {
               return zeroInsets;
            }
        }
    
    }

    static class ToggleButtonBorder implements Border {
        private static Insets insets = new Insets(3,3,3,3);

        public void paintBorder(Component c, Graphics g, int x, int y,
                                int w, int h) {

            JToggleButton button = (JToggleButton)c;
            ButtonModel model = button.getModel();


            g.translate(x,y);


            Color outline;
            Color highlight;
            Color shadow;
            Color corners;

            if (button.isEnabled()) {
                outline = MacLookAndFeel.getBlack();
                if (button.isSelected()) {
                    highlight = MacLookAndFeel.getGray9();
                    shadow =  MacLookAndFeel.getGray4();
                    corners =  MacLookAndFeel.getGray7();
                } else {
                    highlight = MacLookAndFeel.getWhite();
                    shadow =  MacLookAndFeel.getGray5();
                    corners =  MacLookAndFeel.getGray2();
                }
            } else {
                if (model.isSelected()) {

                    outline = MacLookAndFeel.getGray7();
                    highlight = MacLookAndFeel.getGray3();
                    shadow =  MacLookAndFeel.getGray3();
                    corners =  MacLookAndFeel.getGray3();

                } else {
                    outline = MacLookAndFeel.getGray4();
                    highlight = MacLookAndFeel.getGray1();
                    shadow =  MacLookAndFeel.getGray1();
                    corners =  MacLookAndFeel.getGray1();
                }

            }


            g.setColor(outline);
            g.drawRect(0,0,w-1,h-1);


            g.setColor(highlight);
            g.drawRect(1, 1, w-3, h-3);
            g.drawRect(2, 2, w-5, h-5);

            g.setColor(shadow); 
            g.drawLine( w-2, 1, w-2, h-2);
            g.drawLine( w-3, 1, w-3, h-2);
            g.drawLine( 1, h-2, w-2, h-2);
            g.drawLine( 1, h-3, w-2, h-3);

            g.setColor(corners);
            g.drawRect(w-3, 1, 1,1);
            g.drawRect( 1, h-3,1,1);

            g.translate(-x,-y);

        }  
        public boolean isBorderOpaque() {
            return true;
        }

        public Insets getBorderInsets(Component c) {
            return insets;
        }

    }

    public static class TextFieldBorder implements Border {
        private static Insets insets = new Insets(4, 4, 4, 4);

        public void paintBorder(Component c, Graphics g, int x, int y, 
                                int w, int h) {

            g.translate(x,y);
            if (c.isEnabled()) {
                g.setColor(MacLookAndFeel.getBlack());
                g.drawRect(2,2, w-5, h-5);

                if ( ((JComponent)c).hasFocus() ) {
                    g.setColor(MacLookAndFeel.getFocusColor());
                    g.drawRect(0,0,w-1,h-1);
                    g.drawRect(1,1,w-3,h-3);
                    g.setColor(MacLookAndFeel.getGray1());
                    g.drawLine(0,0,0,0);
                    g.drawLine(0,h-1,0,h-1);
                    g.drawLine(w-1,0,w-1,0);
                    g.drawLine(w-1,h-1,w-1,h-1);
                } else {
                    g.setColor(MacLookAndFeel.getGray1());
                    g.drawRect(0,0,w-1,h-1);
                    g.drawRect(1,1,w-3,h-3);

                    g.setColor(MacLookAndFeel.getGray6());
                    g.drawLine(1,1, w-3, 1);
                    g.drawLine(1,1, 1, h-3);

                    g.setColor(MacLookAndFeel.getWhite());
                    g.drawLine(w-2, 2, w-2, h-2);
                    g.drawLine(2, h-2, w-2, h-2);
                }


                //g.setColor(MacLookAndFeel.getFocusColor());

            } else {

            }

            g.translate(-x,-y);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public Insets getBorderInsets(Component c) {
            return insets;
        }

    }


    static class CheckBoxIcon implements Icon, UIResource, Serializable {

        protected int getControlSize() {return 12;}

        public void paintIcon(Component c, Graphics g, int x, int y) {

            JCheckBox cb = (JCheckBox)c;
            ButtonModel model = cb.getModel();
            int controlSize = getControlSize();

            boolean drawCheck = model.isSelected();
            int size = getControlSize();

            // if (model.isPressed() && model.isArmed()) {

            Color back;
            Color highlight;
            Color shadow;
            Color checkShadow;
            Color checkDarkShadow;

            if (model.isPressed() && model.isArmed()) {
                back = MacLookAndFeel.getGray7();
                highlight = MacLookAndFeel.getGray9();
                shadow = MacLookAndFeel.getGray6();
                checkShadow = MacLookAndFeel.getGray5();
                checkDarkShadow = MacLookAndFeel.getGray8();
            } else {
                back = MacLookAndFeel.getGray1();
                highlight = MacLookAndFeel.getWhite();
                shadow = MacLookAndFeel.getGray6();
                checkShadow = MacLookAndFeel.getGray4();
                checkDarkShadow = MacLookAndFeel.getGray4();
            }

            g.translate(x,y);
            if ( model.isEnabled() ) {

                g.setColor(back);
                g.fillRect(0,0,size-1, size-1);

                g.setColor(shadow); 
                g.drawLine(2, size-2, size-2, size-2);
                g.drawLine(size-2, 2, size-2, size-2);
                g.setColor(highlight);
                g.drawLine(1, 2, 1, size-2);
                g.drawLine(2, 1, size-2, 1);

                if (drawCheck) {
                    drawCheck(c,g,
                              MacLookAndFeel.getBlack(),
                              checkShadow, 
                              checkDarkShadow,
                              size );
                }

                g.setColor(MacLookAndFeel.getBlack());
                g.drawRect(0,0, size-1, size-1);

            } else {

                if (drawCheck) {
                    drawCheck(c,g,
                              MacLookAndFeel.getGray6(),
                              MacLookAndFeel.getGray1(), 
                              MacLookAndFeel.getGray1(),
                              size );
                }

                g.setColor(MacLookAndFeel.getGray6());
                g.drawRect(0,0, size-1, size-1);
            }
            g.translate(-x,-y);

        }

        protected void drawCheck(Component c, Graphics g, 
                                 Color checkColor, 
                                 Color shadow, 
                                 Color darkShadow, int size) {
            g.setColor(checkColor);
            g.drawLine(5, size-4, 2, size-7);
            g.drawLine(5, size-4, size, 1);

            g.drawLine(5, size-5, 3, size-7);
            g.drawLine(5, size-5, size-2, 2);

            g.setColor( shadow );
            g.drawLine(4, size-4, 3, size-5);
            g.drawLine(6, size-3, size+1, 2);

            g.setColor( darkShadow );
            g.drawLine(5, size-3, size, 2);

        }

        public int getIconWidth() {
            return getControlSize()+2;
        }

        public int getIconHeight() {
            return getControlSize();
        }
    }


    static class RadioButtonIcon implements Icon, UIResource, Serializable {
        public void paintIcon(Component c, Graphics g, int x, int y) {

            AbstractButton b = (AbstractButton)c;
            ButtonModel model = b.getModel();

            if (model.isEnabled()) {
                if ( model.isSelected() ) {
                    if (model.isPressed() && model.isArmed()) {
                        UIManager.getIcon("RadioButton.pressedOn").paintIcon(c,g,x,y);
                        return;
                    } else {

                        UIManager.getIcon("RadioButton.on").paintIcon(c,g,x,y);
                        return;
                    }
                } else {
                    if (model.isPressed() && model.isArmed()) {
                        UIManager.getIcon("RadioButton.pressedOff").paintIcon(c,g,x,y);
                        return;
                    } else {

                        UIManager.getIcon("RadioButton.off").paintIcon(c,g,x,y);
                        return;
                    }
                }
            } else {
                if (model.isSelected()) {
                    UIManager.getIcon("RadioButton.disabledOn").paintIcon(c,g,x,y);
                    return;
                } else {
                    UIManager.getIcon("RadioButton.disabledOff").paintIcon(c,g,x,y);
                    return;
                }

            }


            //  System.out.println("Fell Through "+model);



        }

        public int getIconWidth() {
            return 13;
        }

        public int getIconHeight() {
            return 13;
        }
    } // end class RadioButtonIcon



    static class WindowShadeBorder implements Border {
        private static Insets insets = new Insets(2,6,2,7);

        private static final int titleBarHeight = MacInternalFrameTitlePane.titleBarHeight;

        public void paintBorder(Component c, Graphics g, int x, int y,
                                int w, int h) {

            if (c instanceof JInternalFrame && ((JInternalFrame)c).isSelected()) {
                g.setColor(MacLookAndFeel.getGray2());
                g.fillRect(0,0,w-2,h-2);

                g.setColor(MacLookAndFeel.getBlack());
                drawOutline(c,g,x,y,w,h);

                g.setColor(MacLookAndFeel.getWhite());
                g.drawLine(1,1,1, h-4);
                g.drawLine(1,1,w-4,1);

                g.setColor(MacLookAndFeel.getGray4());
                g.drawLine(4, titleBarHeight+1, 4, h-7);
                g.drawLine(2, h-3, w-3,h-3);
                g.drawLine(w-3,h-3, w-3, 2);
            } else {
                g.setColor(MacLookAndFeel.getGray1());
                g.fillRect(0,0,w-2,h-2);

                g.setColor(MacLookAndFeel.getGray8());
                drawOutline(c,g,x,y,w,h);
            }

        }

        public void drawOutline(Component c, Graphics g, int x, int y,
                                int w, int h) {
            g.drawRect(0,0, w-2, h-2);
            g.drawLine(w-1, 2, w-1, h-1);
            g.drawLine(2, h-1, w-1, h-1);
        }

        public boolean isBorderOpaque() {
            return false;
        }

        public Insets getBorderInsets(Component c) {
            return insets;
        }

    }

    static class InternalFrameBorder implements Border {
        private static Insets insets = new Insets(2,6,7,7);

        private static final int titleBarHeight = MacInternalFrameTitlePane.titleBarHeight;

        public void paintBorder(Component c, Graphics g, int x, int y,
                                int w, int h) {

            if (c instanceof JInternalFrame && ((JInternalFrame)c).isSelected()) {
                g.setColor(MacLookAndFeel.getGray2());
                g.fillRect(0,0,w-2,h-2);

                g.setColor(MacLookAndFeel.getBlack());
                drawOutline(c,g,x,y,w,h);

                g.setColor(MacLookAndFeel.getWhite());
                g.drawLine(1,1,1, h-4);
                g.drawLine(1,1,w-4,1);
                g.drawLine(4,h-6,w-6,h-6);
                g.drawLine(w-6,h-6,w-6,titleBarHeight+1);

                g.setColor(MacLookAndFeel.getGray4());
                g.drawLine(4, titleBarHeight+1, 4, h-7);
                g.drawLine(2, h-3, w-3,h-3);
                g.drawLine(w-3,h-3, w-3, 2);
            } else {
                g.setColor(MacLookAndFeel.getGray1());
                g.fillRect(0,0,w-2,h-2);

                g.setColor(MacLookAndFeel.getGray8());
                drawOutline(c,g,x,y,w,h);
            }

        }

        public void drawOutline(Component c, Graphics g, int x, int y,
                                int w, int h) {
            g.drawRect(0,0, w-2, h-2);
            g.drawLine(w-1, 2, w-1, h-1);
            g.drawLine(2, h-1, w-1, h-1);
            g.drawLine(5, titleBarHeight+1, 5, h-7);
            g.drawLine(5, h-7, w-7, h-7);
            g.drawLine(w-7, h-7, w-7, titleBarHeight+1);

        }
        public boolean isBorderOpaque() {
            return false;
        }

        public Insets getBorderInsets(Component c) {
            return insets;
        }

    }


    static class MenuBarBorder extends AbstractBorder implements UIResource {
        protected static Insets borderInsets = new Insets( 0, 0, 1, 0 );

        public void paintBorder( Component c, Graphics g, int x, int y, int w, int h ) {
            g.translate( x, y );

            g.setColor( MacLookAndFeel.getWhite() );
            g.drawLine( 0, 0, w-1, 0 );

            g.setColor( MacLookAndFeel.getGray4() );
            g.drawLine( 0, h-2, w-1, h-2 );


            g.setColor( MacLookAndFeel.getBlack() );
            g.drawLine( 0, h-1, w-1, h-1 );


            g.translate( -x, -y );

        }

        public Insets getBorderInsets( Component c ) {
            return borderInsets;
        }
    }

    static class MenuItemBorder extends AbstractBorder implements UIResource {
        static Insets borderInsets = new Insets( 2, 2, 2, 2 );

        public void paintBorder( Component c, Graphics g, int x, int y, int w, int h ) {
            JMenuItem b = (JMenuItem) c;
            ButtonModel model = b.getModel();

            g.translate( x, y );

            Color light;
            Color dark;
            if (model.isArmed() || model.isSelected() ) {
                light = MacLookAndFeel.getAccentHighlight();
                dark = MacLookAndFeel.getBlack();
            } else {
                light = MacLookAndFeel.getWhite();
                dark = MacLookAndFeel.getGray6();
            }

            Component parent = c.getParent();
            if ( parent instanceof JMenuBar ) {
                g.setColor( light );
                g.drawLine( 0, 0, w - 1, 0 );
                g.setColor( dark );
                g.drawLine( 0, h-1, w - 1, h-1 );

            } else {

                boolean paintTop = false;
                if (parent instanceof JPopupMenu) {
                    paintTop = (((JPopupMenu)parent).getComponentIndex(c) == 0);
                }
                g.setColor( light );
                g.drawLine( 0, 0, 0, h-1 );
                if (paintTop) {
                    g.drawLine( 0, 0, w-1, 0 );
                }
                g.setColor( dark );
                g.drawLine( w-1, 0, w - 1, h-1 );
            }

            g.translate( -x, -y );
        }

        public Insets getBorderInsets( Component c ) {
            return borderInsets;
        }
    }

    static class PopupMenuBorder extends AbstractBorder implements UIResource {
        static Insets borderInsets = new Insets( 1,1,2,2 );

        public void paintBorder( Component c, Graphics g, int x, int y, int w, int h ) {
            g.translate( x, y );

            g.setColor( MacLookAndFeel.getBlack() );
            g.drawRect( 0, 0, w - 2, h - 2 );

            g.setColor( MacLookAndFeel.getGray10() );
            g.drawLine( w-1, 0, w - 1, h - 1 );
            g.drawLine( 0, h-1, w - 1, h - 1 );

            /*          g.setColor(MacLookAndFeel.getWhite());
                      g.drawLine(1,1,w-3,1);
                      g.drawLine(1,1,1,h-3);
          
                   // g.setColor(MacLookAndFeel.getGray6());
                       g.setColor(Color.red);
                      g.drawLine(w-3,2,w-3,h-3);
                      g.drawLine(2,h-3,w-3,h-3);     */


            g.translate( -x, -y );

        }

        public Insets getBorderInsets( Component c ) {
            return borderInsets;
        }
    }

    static class ScrollBarBorder implements Border, UIResource {
        public void paintBorder( Component c, Graphics g, int x, int y, int width, int height ) {
            JScrollBar scrollBar = (JScrollBar)c;
            MacScrollBarUI ui = (MacScrollBarUI)scrollBar.getUI();

            g.setColor( MacLookAndFeel.getBlack() );
            //g.setColor( Color.red );

            g.translate( x, y );

            if ( ui.isFreeStanding ) {
                g.drawRect( 0, 0, width - 1, height - 1 );
            } else {
                if ( scrollBar.getOrientation() == JScrollBar.VERTICAL ) {
                    g.drawLine( 0, 0, width - 1, 0 );
                    g.drawLine( 0, 0, 0, height - 1 );
                    g.drawLine( 0, height - 1, width -1, height - 1 );
                } else {
                    g.drawLine( 0, 0, 0, height - 1 );
                    g.drawLine( 0, height - 1, width - 1, height - 1 );
                    g.drawLine( width - 1, 0, width - 1, height - 1 );
                }
            }

            g.translate( -x, -y );
        }

        public Insets getBorderInsets( Component c ) {
            JScrollBar scrollBar = (JScrollBar)c;
            MacScrollBarUI ui = (MacScrollBarUI)scrollBar.getUI();

            if ( ui.isFreeStanding ) {
                return new Insets( 1, 1, 1, 1 );
            } else {
                if ( scrollBar.getOrientation() == JScrollBar.VERTICAL ) {
                    return new Insets( 1, 1, 1, 0 );
                } else {
                    return new Insets( 1, 1, 0, 1 );
                }
            }
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

}
