/*
* @(#)MacButtonUI.java	1.18 98/05/10
*
* Copyright 1998 by Sun Microsystems, Inc.,
* 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
* All rights reserved.
*
* This software is the confidential and proprietary information
* of Sun Microsystems, Inc. ("Confidential Information").  You
* shall not disclose such Confidential Information and shall use
* it only in accordance with the terms of the license agreement
* you entered into with Sun.
*/

package com.sun.java.swing.plaf.mac;

import javax.swing.*;
import javax.swing.border.*;
import javax.swing.plaf.basic.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.plaf.*;

/**
 * MacButtonUI implementation
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.18 05/10/98
 * @author Steve Wilson
 */
public class MacButtonUI extends BasicButtonUI {

	private final static MacButtonUI metalButtonUI = new MacButtonUI(); 

	private boolean defaults_initialized = false;

	protected Color selectColor;
	protected Color selectTextColor;
	protected Color disabledTextColor;

	// ********************************
	//          Create PLAF
	// ********************************
	public static ComponentUI createUI(JComponent c) {
		return metalButtonUI;
	}

	// ********************************
	//          Install
	// ********************************
	public void installDefaults(AbstractButton b) {
		super.installDefaults(b);
		if (!defaults_initialized) {
			selectColor = UIManager.getColor(getPropertyPrefix() + "select");
			selectTextColor = UIManager.getColor(getPropertyPrefix() + "selectText");
			disabledTextColor = UIManager.getColor(getPropertyPrefix() + "disabledText");
			defaults_initialized = true;
		}
		b.setOpaque(false);

	}

	public void uninstallDefaults(AbstractButton b) {
		super.uninstallDefaults(b);
		defaults_initialized = false;
	}

	// ********************************
	//         Create Listeners
	// ********************************
	protected BasicButtonListener createButtonListener(AbstractButton b) {
		return new MacButtonListener(b);
	}


	// ********************************
	//         Default Accessors 
	// ********************************
	protected Color getSelectColor() {
		return selectColor;
	}

	protected Color getDisabledTextColor() {
		return disabledTextColor;
	}

	protected Color getSelectTextColor() {
		return selectTextColor;
	}

	// ********************************
	//          Paint
	// ********************************
	protected void paintButtonPressed(Graphics g, AbstractButton b) {
		if ( b.isContentAreaFilled() ) {
			Dimension size = b.getSize();
			g.setColor(getSelectColor());
         if ( ((JButton)b).isDefaultCapable() ) {
            g.fillRect(4, 4, size.width-8, size.height-8); 
         } else {
            g.fillRect(1, 1, size.width-2, size.height-2);            
         }
		}
	}

	protected void paintFocus(Graphics g, AbstractButton b,
									  Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {

		// do nothing
	}


	protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
		AbstractButton b = (AbstractButton) c;            
		ButtonModel model = b.getModel();
		FontMetrics fm = g.getFontMetrics();

		final int noMnemonic = -1;
		/* Draw the Text */
		if (model.isEnabled()) {
			/*** paint the text normally */
			if ( model.isPressed() && model.isArmed() ) {
				g.setColor(getSelectTextColor());
				BasicGraphicsUtils.drawString(g,text, noMnemonic,
														textRect.x,
														textRect.y + fm.getAscent());

			} else {
				g.setColor(b.getForeground());
				BasicGraphicsUtils.drawString(g,text, noMnemonic,
														textRect.x,
														textRect.y + fm.getAscent());
			}

		} else {
			/*** paint the text disabled ***/
			g.setColor(getDisabledTextColor());
			BasicGraphicsUtils.drawString(g,text,noMnemonic,
													textRect.x, textRect.y + fm.getAscent());

		}
	}

	public void paint(Graphics g, JComponent c) {
      AbstractButton b = (AbstractButton)c;
		if ( b.isContentAreaFilled() ) {
			Dimension size = b.getSize();
			g.setColor(c.getBackground());
         if ( ((JButton)b).isDefaultCapable() ) {
            g.fillRect(4, 4, size.width-8, size.height-8); 
         } else {
            g.fillRect(1, 1, size.width-2, size.height-2);            
         }
		}

		super.paint(g,c);
	}


}

class MacButtonListener extends BasicButtonListener {

	public MacButtonListener(AbstractButton b) {
		super(b);  
	}

	public void focusGained(FocusEvent e) {
		Component c = (Component)e.getSource();
		c.repaint();
	}
}


