/*
 * Decompiled with CFR 0.152.
 */
package com.imaginary.sql;

import com.imaginary.sql.RowSetEventSupport;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.sql.RowSetListener;

public class ImaginaryRowSet
implements RowSet {
    private String command = null;
    private Connection connection = null;
    private ResultSet currentResults = null;
    private PreparedStatement currentStatement = null;
    private DataSource dataSource = null;
    private String dataSourceName = null;
    private boolean escapeProcessing = true;
    private RowSetEventSupport eventSupport = null;
    private int fetchDirection = 1000;
    private int fetchSize = 0;
    private int maxFieldSize = 0;
    private int maxRows = 0;
    private String password = null;
    private int queryTimeout = 0;
    private boolean readOnly = false;
    private int resultSetConcurrency = 1007;
    private int resultSetType = 1003;
    private int transactionIsolation = 0;
    private Map typeMap = null;
    private String url = null;
    private String username = null;

    public ImaginaryRowSet() {
        this.eventSupport = new RowSetEventSupport(this);
    }

    public ImaginaryRowSet(int n, int n2) {
        this.resultSetConcurrency = n2;
        this.resultSetType = n;
        this.eventSupport = new RowSetEventSupport(this);
    }

    public ImaginaryRowSet(DataSource dataSource) {
        this.dataSource = dataSource;
        this.eventSupport = new RowSetEventSupport(this);
    }

    public ImaginaryRowSet(DataSource dataSource, int n, int n2) {
        this.dataSource = dataSource;
        this.resultSetType = n;
        this.resultSetConcurrency = n2;
        this.eventSupport = new RowSetEventSupport(this);
    }

    public synchronized boolean absolute(int n) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        boolean bl = n == this.getRow();
        boolean bl2 = this.currentResults.absolute(n);
        if (!bl) {
            this.eventSupport.cursorMoved();
        }
        return bl2;
    }

    public synchronized void addRowSetListener(RowSetListener rowSetListener) {
        this.eventSupport.addListener(rowSetListener);
    }

    public synchronized void afterLast() throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        boolean bl = this.isAfterLast();
        this.currentResults.afterLast();
        if (!bl) {
            this.eventSupport.cursorMoved();
        }
    }

    public synchronized void beforeFirst() throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        boolean bl = this.isBeforeFirst();
        this.currentResults.beforeFirst();
        if (!bl) {
            this.eventSupport.cursorMoved();
        }
    }

    public synchronized void cancelRowUpdates() throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.cancelRowUpdates();
    }

    public void clearParameters() throws SQLException {
        if (this.currentStatement == null) {
            throw new SQLException("Row set references no statement.");
        }
        this.currentStatement.clearParameters();
    }

    public synchronized void clearWarnings() throws SQLException {
        if (this.connection != null) {
            this.connection.clearWarnings();
        }
        if (this.currentResults != null) {
            this.currentResults.clearWarnings();
        }
        if (this.currentStatement != null) {
            this.currentStatement.clearWarnings();
        }
    }

    public synchronized void close() throws SQLException {
        SQLException sQLException = null;
        if (this.connection != null) {
            if (!this.connection.getAutoCommit()) {
                try {
                    this.connection.commit();
                }
                catch (SQLException sQLException2) {
                    try {
                        this.connection.rollback();
                    }
                    catch (SQLException sQLException3) {
                        sQLException3.printStackTrace();
                    }
                    throw sQLException2;
                }
            }
            try {
                this.connection.close();
            }
            catch (SQLException sQLException4) {
                sQLException = sQLException4;
            }
            this.connection = null;
            this.currentStatement = null;
            this.currentResults = null;
            if (sQLException != null) {
                throw sQLException;
            }
        } else if (this.currentStatement != null) {
            try {
                this.currentStatement.close();
            }
            catch (SQLException sQLException5) {
                sQLException = sQLException5;
            }
            this.currentStatement = null;
            this.currentResults = null;
            if (sQLException != null) {
                throw sQLException;
            }
        } else if (this.currentResults != null) {
            try {
                this.currentResults.close();
            }
            catch (SQLException sQLException6) {
                sQLException = sQLException6;
            }
            this.currentResults = null;
            if (sQLException != null) {
                throw sQLException;
            }
        }
    }

    public synchronized void deleteRow() throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.deleteRow();
        this.eventSupport.rowChanged();
    }

    public synchronized void execute() throws SQLException {
        if (this.currentStatement == null) {
            throw new SQLException("No current statement to execute.");
        }
        this.currentResults = this.currentStatement.executeQuery();
        this.eventSupport.rowSetChanged();
    }

    public synchronized int findColumn(String string) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.findColumn(string);
    }

    public synchronized boolean first() throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        boolean bl = this.isFirst();
        boolean bl2 = this.currentResults.first();
        if (!bl) {
            this.eventSupport.cursorMoved();
        }
        return bl2;
    }

    public synchronized Array getArray(int n) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getArray(n);
    }

    public synchronized Array getArray(String string) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getArray(string);
    }

    public synchronized InputStream getAsciiStream(int n) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getAsciiStream(n);
    }

    public synchronized InputStream getAsciiStream(String string) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getAsciiStream(string);
    }

    public synchronized BigDecimal getBigDecimal(int n) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getBigDecimal(n);
    }

    public synchronized BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getBigDecimal(n);
    }

    public synchronized BigDecimal getBigDecimal(String string) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getBigDecimal(string);
    }

    public synchronized BigDecimal getBigDecimal(String string, int n) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getBigDecimal(string);
    }

    public synchronized InputStream getBinaryStream(int n) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getBinaryStream(n);
    }

    public synchronized InputStream getBinaryStream(String string) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getBinaryStream(string);
    }

    public synchronized Blob getBlob(int n) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getBlob(n);
    }

    public synchronized Blob getBlob(String string) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getBlob(string);
    }

    public synchronized boolean getBoolean(int n) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getBoolean(n);
    }

    public synchronized boolean getBoolean(String string) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getBoolean(string);
    }

    public synchronized byte getByte(int n) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getByte(n);
    }

    public synchronized byte getByte(String string) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getByte(string);
    }

    public synchronized byte[] getBytes(int n) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getBytes(n);
    }

    public synchronized byte[] getBytes(String string) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getBytes(string);
    }

    public synchronized Reader getCharacterStream(int n) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getCharacterStream(n);
    }

    public synchronized Reader getCharacterStream(String string) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getCharacterStream(string);
    }

    public synchronized Clob getClob(int n) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getClob(n);
    }

    public synchronized Clob getClob(String string) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getClob(string);
    }

    public synchronized String getCommand() {
        return this.command;
    }

    public synchronized int getConcurrency() throws SQLException {
        return this.resultSetConcurrency;
    }

    public synchronized String getCursorName() throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getCursorName();
    }

    private DataSource getDataSource() {
        try {
            InitialContext initialContext = new InitialContext();
            return (DataSource)initialContext.lookup(this.dataSourceName);
        }
        catch (NamingException namingException) {
            namingException.printStackTrace();
            return null;
        }
    }

    public synchronized String getDataSourceName() {
        return this.dataSourceName;
    }

    public synchronized Date getDate(int n) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getDate(n);
    }

    public synchronized Date getDate(int n, Calendar calendar) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getDate(n, calendar);
    }

    public synchronized Date getDate(String string) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getDate(string);
    }

    public synchronized Date getDate(String string, Calendar calendar) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getDate(string, calendar);
    }

    public synchronized double getDouble(int n) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getDouble(n);
    }

    public synchronized double getDouble(String string) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getDouble(string);
    }

    public synchronized boolean getEscapeProcessing() throws SQLException {
        return this.escapeProcessing;
    }

    public synchronized int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public synchronized int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public synchronized float getFloat(int n) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getFloat(n);
    }

    public synchronized float getFloat(String string) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getFloat(string);
    }

    public synchronized int getInt(int n) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getInt(n);
    }

    public synchronized int getInt(String string) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getInt(string);
    }

    public synchronized long getLong(int n) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getLong(n);
    }

    public synchronized long getLong(String string) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getLong(string);
    }

    public synchronized int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public synchronized int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        return null;
    }

    public synchronized Object getObject(int n) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getObject(n);
    }

    public synchronized Object getObject(int n, Map map) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getObject(n, map);
    }

    public synchronized Object getObject(String string) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getObject(string);
    }

    public synchronized Object getObject(String string, Map map) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getObject(string, map);
    }

    public synchronized String getPassword() {
        return this.password;
    }

    public synchronized int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    public synchronized Ref getRef(int n) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getRef(n);
    }

    public synchronized Ref getRef(String string) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getRef(string);
    }

    public synchronized int getRow() throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getRow();
    }

    public synchronized short getShort(int n) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getShort(n);
    }

    public synchronized short getShort(String string) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getShort(string);
    }

    public synchronized Statement getStatement() throws SQLException {
        return this.currentStatement;
    }

    public synchronized String getString(int n) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getString(n);
    }

    public synchronized String getString(String string) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getString(string);
    }

    public synchronized Time getTime(int n) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getTime(n);
    }

    public synchronized Time getTime(int n, Calendar calendar) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getTime(n, calendar);
    }

    public synchronized Time getTime(String string) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getTime(string);
    }

    public synchronized Time getTime(String string, Calendar calendar) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getTime(string, calendar);
    }

    public synchronized Timestamp getTimestamp(int n) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getTimestamp(n);
    }

    public synchronized Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getTimestamp(n, calendar);
    }

    public synchronized Timestamp getTimestamp(String string) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getTimestamp(string);
    }

    public synchronized Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getTimestamp(string, calendar);
    }

    public int getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public synchronized int getType() throws SQLException {
        return this.resultSetType;
    }

    public synchronized Map getTypeMap() throws SQLException {
        return this.typeMap;
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getUnicodeStream(n);
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.getUnicodeStream(string);
    }

    public synchronized String getUrl() throws SQLException {
        return this.url;
    }

    public synchronized String getUsername() {
        return this.username;
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        SQLWarning sQLWarning;
        SQLWarning sQLWarning2 = null;
        if (this.connection == null) {
            return null;
        }
        if (this.currentResults != null) {
            sQLWarning2 = this.currentResults.getWarnings();
        }
        if (this.currentStatement != null && (sQLWarning = this.currentStatement.getWarnings()) != null) {
            if (sQLWarning2 == null) {
                sQLWarning2 = sQLWarning;
            } else {
                sQLWarning2.setNextWarning(sQLWarning);
            }
        }
        if (this.connection != null && (sQLWarning = this.connection.getWarnings()) != null) {
            if (sQLWarning2 == null) {
                sQLWarning2 = sQLWarning;
            } else {
                sQLWarning2.setNextWarning(sQLWarning);
            }
        }
        return sQLWarning2;
    }

    public synchronized void insertRow() throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.insertRow();
        this.eventSupport.rowChanged();
    }

    public synchronized boolean isAfterLast() throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.isAfterLast();
    }

    public synchronized boolean isBeforeFirst() throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.isBeforeFirst();
    }

    public synchronized boolean isFirst() throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.isFirst();
    }

    public synchronized boolean isLast() throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.isLast();
    }

    public synchronized boolean isReadOnly() {
        return this.readOnly;
    }

    public synchronized boolean last() throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        boolean bl = this.isLast();
        boolean bl2 = this.currentResults.last();
        if (!bl) {
            this.eventSupport.cursorMoved();
        }
        return bl2;
    }

    public synchronized void moveToCurrentRow() throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.moveToCurrentRow();
        this.eventSupport.cursorMoved();
    }

    public synchronized void moveToInsertRow() throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.moveToInsertRow();
        this.eventSupport.cursorMoved();
    }

    public synchronized boolean next() throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        boolean bl = this.currentResults.next();
        this.eventSupport.cursorMoved();
        return bl;
    }

    private void prepareStatement() throws SQLException {
        if (this.connection == null) {
            this.connection = this.dataSource == null ? DriverManager.getConnection(this.url, this.username, this.password) : (this.username == null ? this.dataSource.getConnection() : this.dataSource.getConnection(this.username, this.password));
            this.connection.setReadOnly(this.readOnly);
            this.connection.setTransactionIsolation(this.transactionIsolation);
            if (this.typeMap != null) {
                this.connection.setTypeMap(this.typeMap);
            }
        }
        this.currentStatement = this.connection.prepareStatement(this.command, this.resultSetType, this.resultSetConcurrency);
        this.currentStatement.setFetchDirection(this.fetchDirection);
        this.currentStatement.setFetchSize(this.fetchSize);
        this.currentStatement.setMaxFieldSize(this.maxFieldSize);
        this.currentStatement.setMaxRows(this.maxRows);
        this.currentStatement.setQueryTimeout(this.queryTimeout);
    }

    public synchronized boolean previous() throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        boolean bl = this.currentResults.previous();
        this.eventSupport.cursorMoved();
        return bl;
    }

    public synchronized void refreshRow() throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.refreshRow();
    }

    public synchronized boolean relative(int n) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        boolean bl = this.currentResults.relative(n);
        this.eventSupport.cursorMoved();
        return bl;
    }

    public synchronized void removeRowSetListener(RowSetListener rowSetListener) {
        this.eventSupport.removeListener(rowSetListener);
    }

    public synchronized boolean rowDeleted() throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.rowDeleted();
    }

    public synchronized boolean rowInserted() throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.rowInserted();
    }

    public synchronized boolean rowUpdated() throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.rowUpdated();
    }

    public synchronized void setArray(int n, Array array) throws SQLException {
        if (this.currentStatement == null) {
            this.prepareStatement();
        }
        this.currentStatement.setArray(n, array);
    }

    public synchronized void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.currentStatement == null) {
            this.prepareStatement();
        }
        this.currentStatement.setAsciiStream(n, inputStream, n2);
    }

    public synchronized void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (this.currentStatement == null) {
            this.prepareStatement();
        }
        this.currentStatement.setBigDecimal(n, bigDecimal);
    }

    public synchronized void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.currentStatement == null) {
            this.prepareStatement();
        }
        this.currentStatement.setBinaryStream(n, inputStream, n2);
    }

    public synchronized void setBlob(int n, Blob blob) throws SQLException {
        if (this.currentStatement == null) {
            this.prepareStatement();
        }
        this.currentStatement.setBlob(n, blob);
    }

    public synchronized void setBoolean(int n, boolean bl) throws SQLException {
        if (this.currentStatement == null) {
            this.prepareStatement();
        }
        this.currentStatement.setBoolean(n, bl);
    }

    public synchronized void setByte(int n, byte by) throws SQLException {
        if (this.currentStatement == null) {
            this.prepareStatement();
        }
        this.currentStatement.setByte(n, by);
    }

    public synchronized void setBytes(int n, byte[] byArray) throws SQLException {
        if (this.currentStatement == null) {
            this.prepareStatement();
        }
        this.currentStatement.setBytes(n, byArray);
    }

    public synchronized void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        if (this.currentStatement == null) {
            this.prepareStatement();
        }
        this.currentStatement.setCharacterStream(n, reader, n2);
    }

    public synchronized void setClob(int n, Clob clob) throws SQLException {
        if (this.currentStatement == null) {
            this.prepareStatement();
        }
        this.currentStatement.setClob(n, clob);
    }

    public synchronized void setCommand(String string) throws SQLException {
        if (this.currentStatement != null) {
            throw new SQLException("Cannot reset command while a  statement is being processed.");
        }
        this.command = string;
    }

    public synchronized void setConcurrency(int n) throws SQLException {
        this.resultSetConcurrency = n;
    }

    public synchronized void setDataSourceName(String string) throws SQLException {
        if (this.connection != null) {
            throw new SQLException("Cannot change DSN with an open connection.");
        }
        this.dataSourceName = string;
        this.dataSource = this.getDataSource();
    }

    public synchronized void setDate(int n, Date date) throws SQLException {
        if (this.currentStatement == null) {
            this.prepareStatement();
        }
        this.currentStatement.setDate(n, date);
    }

    public synchronized void setDate(int n, Date date, Calendar calendar) throws SQLException {
        if (this.currentStatement == null) {
            this.prepareStatement();
        }
        this.currentStatement.setDate(n, date, calendar);
    }

    public synchronized void setDouble(int n, double d) throws SQLException {
        if (this.currentStatement == null) {
            this.prepareStatement();
        }
        this.currentStatement.setDouble(n, d);
    }

    public synchronized void setEscapeProcessing(boolean bl) throws SQLException {
        if (this.currentStatement == null) {
            this.currentStatement.setEscapeProcessing(bl);
        }
        this.escapeProcessing = bl;
    }

    public synchronized void setFetchDirection(int n) throws SQLException {
        if (this.currentStatement != null) {
            this.currentStatement.setFetchDirection(n);
        }
        this.fetchDirection = n;
    }

    public synchronized void setFetchSize(int n) throws SQLException {
        if (this.currentStatement != null) {
            this.currentStatement.setFetchSize(n);
        }
        this.fetchSize = n;
    }

    public synchronized void setFloat(int n, float f) throws SQLException {
        if (this.currentStatement == null) {
            this.prepareStatement();
        }
        this.currentStatement.setFloat(n, f);
    }

    public synchronized void setInt(int n, int n2) throws SQLException {
        if (this.currentStatement == null) {
            this.prepareStatement();
        }
        this.currentStatement.setInt(n, n2);
    }

    public synchronized void setLong(int n, long l) throws SQLException {
        if (this.currentStatement == null) {
            this.prepareStatement();
        }
        this.currentStatement.setLong(n, l);
    }

    public synchronized void setMaxFieldSize(int n) throws SQLException {
        if (this.currentStatement != null) {
            this.currentStatement.setMaxFieldSize(n);
        }
        this.maxFieldSize = n;
    }

    public synchronized void setMaxRows(int n) throws SQLException {
        if (this.currentStatement != null) {
            this.currentStatement.setMaxRows(n);
        }
        this.maxRows = n;
    }

    public synchronized void setNull(int n, int n2) throws SQLException {
        if (this.currentStatement == null) {
            this.prepareStatement();
        }
        this.currentStatement.setNull(n, n2);
    }

    public synchronized void setNull(int n, int n2, String string) throws SQLException {
        if (this.currentStatement == null) {
            this.prepareStatement();
        }
        this.currentStatement.setNull(n, n2);
    }

    public synchronized void setObject(int n, Object object) throws SQLException {
        if (this.currentStatement == null) {
            this.prepareStatement();
        }
        this.currentStatement.setObject(n, object);
    }

    public synchronized void setObject(int n, Object object, int n2) throws SQLException {
        if (this.currentStatement == null) {
            this.prepareStatement();
        }
        this.currentStatement.setObject(n, object, n2);
    }

    public synchronized void setObject(int n, Object object, int n2, int n3) throws SQLException {
        if (this.currentStatement == null) {
            this.prepareStatement();
        }
        this.currentStatement.setObject(n, object, n2, n3);
    }

    public synchronized void setPassword(String string) throws SQLException {
        this.password = string;
    }

    public synchronized void setQueryTimeout(int n) throws SQLException {
        if (this.currentStatement != null) {
            this.currentStatement.setQueryTimeout(n);
        }
        this.queryTimeout = n;
    }

    public synchronized void setReadOnly(boolean bl) throws SQLException {
        if (this.connection != null) {
            this.connection.setReadOnly(bl);
        }
        this.readOnly = bl;
    }

    public synchronized void setRef(int n, Ref ref) throws SQLException {
        if (this.currentStatement == null) {
            this.prepareStatement();
        }
        this.currentStatement.setRef(n, ref);
    }

    public synchronized void setShort(int n, short s) throws SQLException {
        if (this.currentStatement == null) {
            this.prepareStatement();
        }
        this.currentStatement.setShort(n, s);
    }

    public synchronized void setString(int n, String string) throws SQLException {
        if (this.currentStatement == null) {
            this.prepareStatement();
        }
        this.currentStatement.setString(n, string);
    }

    public synchronized void setTime(int n, Time time) throws SQLException {
        if (this.currentStatement == null) {
            this.prepareStatement();
        }
        this.currentStatement.setTime(n, time);
    }

    public synchronized void setTime(int n, Time time, Calendar calendar) throws SQLException {
        if (this.currentStatement == null) {
            this.prepareStatement();
        }
        this.currentStatement.setTime(n, time, calendar);
    }

    public synchronized void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (this.currentStatement == null) {
            this.prepareStatement();
        }
        this.currentStatement.setTimestamp(n, timestamp);
    }

    public synchronized void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (this.currentStatement == null) {
            this.prepareStatement();
        }
        this.currentStatement.setTimestamp(n, timestamp, calendar);
    }

    public synchronized void setTransactionIsolation(int n) throws SQLException {
        if (this.connection != null) {
            this.connection.setTransactionIsolation(n);
        }
        this.transactionIsolation = n;
    }

    public synchronized void setType(int n) throws SQLException {
        this.resultSetType = n;
    }

    public synchronized void setTypeMap(Map map) throws SQLException {
        if (this.connection != null) {
            this.connection.setTypeMap(map);
        }
        this.typeMap = map;
    }

    public synchronized void setUrl(String string) throws SQLException {
        this.url = string;
    }

    public synchronized void setUsername(String string) throws SQLException {
        this.username = string;
    }

    public synchronized void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.updateAsciiStream(n, inputStream, n2);
    }

    public synchronized void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.updateAsciiStream(string, inputStream, n);
    }

    public synchronized void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.updateBigDecimal(n, bigDecimal);
    }

    public synchronized void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.updateBigDecimal(string, bigDecimal);
    }

    public synchronized void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.updateBinaryStream(n, inputStream, n2);
    }

    public synchronized void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.updateBinaryStream(string, inputStream, n);
    }

    public synchronized void updateBoolean(int n, boolean bl) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.updateBoolean(n, bl);
    }

    public synchronized void updateBoolean(String string, boolean bl) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.updateBoolean(string, bl);
    }

    public synchronized void updateByte(int n, byte by) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.updateByte(n, by);
    }

    public synchronized void updateByte(String string, byte by) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.updateByte(string, by);
    }

    public synchronized void updateBytes(int n, byte[] byArray) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.updateBytes(n, byArray);
    }

    public synchronized void updateBytes(String string, byte[] byArray) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.updateBytes(string, byArray);
    }

    public synchronized void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.updateCharacterStream(n, reader, n2);
    }

    public synchronized void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.updateCharacterStream(string, reader, n);
    }

    public synchronized void updateDate(int n, Date date) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.updateDate(n, date);
    }

    public synchronized void updateDate(String string, Date date) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.updateDate(string, date);
    }

    public synchronized void updateDouble(int n, double d) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.updateDouble(n, d);
    }

    public synchronized void updateDouble(String string, double d) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.updateDouble(string, d);
    }

    public synchronized void updateFloat(int n, float f) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.updateFloat(n, f);
    }

    public synchronized void updateFloat(String string, float f) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.updateFloat(string, f);
    }

    public synchronized void updateInt(int n, int n2) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.updateInt(n, n2);
    }

    public synchronized void updateInt(String string, int n) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.updateInt(string, n);
    }

    public synchronized void updateLong(int n, long l) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.updateLong(n, l);
    }

    public synchronized void updateLong(String string, long l) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.updateLong(string, l);
    }

    public synchronized void updateNull(int n) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.updateNull(n);
    }

    public synchronized void updateNull(String string) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.updateNull(string);
    }

    public synchronized void updateObject(int n, Object object) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.updateObject(n, object);
    }

    public synchronized void updateObject(int n, Object object, int n2) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.updateObject(n, object, n2);
    }

    public synchronized void updateObject(String string, Object object) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.updateObject(string, object);
    }

    public synchronized void updateObject(String string, Object object, int n) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.updateObject(string, object, n);
    }

    public synchronized void updateRow() throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.updateRow();
    }

    public synchronized void updateShort(int n, short s) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.updateShort(n, s);
    }

    public synchronized void updateShort(String string, short s) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.updateShort(string, s);
    }

    public synchronized void updateString(int n, String string) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.updateString(n, string);
    }

    public synchronized void updateString(String string, String string2) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.updateString(string, string2);
    }

    public synchronized void updateTime(int n, Time time) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.updateTime(n, time);
    }

    public synchronized void updateTime(String string, Time time) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.updateTime(string, time);
    }

    public synchronized void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.updateTimestamp(n, timestamp);
    }

    public synchronized void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        this.currentResults.updateTimestamp(string, timestamp);
    }

    public synchronized boolean wasNull() throws SQLException {
        if (this.currentResults == null) {
            throw new SQLException("Row set references no results.");
        }
        return this.currentResults.wasNull();
    }
}

