/*
 * Decompiled with CFR 0.152.
 */
package com.imaginary.sql.msql;

import com.imaginary.sql.msql.MsqlTypes;
import com.imaginary.sql.msql.ParsedRow;
import java.sql.SQLException;

public class MsqlColumn {
    private String catalog = null;
    private String columnName = null;
    private int length = 0;
    private int msqlType = 2;
    private boolean nullable = false;
    private boolean primaryKey = false;
    private String tableName = null;

    MsqlColumn(String string, ParsedRow parsedRow) throws SQLException {
        String string2;
        this.tableName = parsedRow.get(0);
        this.columnName = parsedRow.get(1);
        this.msqlType = Integer.parseInt(parsedRow.get(2));
        this.length = Integer.parseInt(parsedRow.get(3));
        try {
            string2 = parsedRow.get(4);
            this.nullable = !string2.equals("Y");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.nullable = true;
        }
        try {
            string2 = parsedRow.get(5);
            this.primaryKey = string2.equals("Y");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.primaryKey = false;
        }
    }

    public String getColumnName() {
        return this.columnName;
    }

    public int getLength() {
        return this.length;
    }

    public int getMsqlType() {
        return this.msqlType;
    }

    public int getSQLType() {
        return MsqlTypes.getSQLTypeForMsql(this.msqlType);
    }

    public String getTableName() {
        return this.tableName;
    }

    int getType() {
        return this.getSQLType();
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }
}

