/*
 * Decompiled with CFR 0.152.
 */
package com.imaginary.sql.msql;

import com.imaginary.sql.msql.MsqlException;
import com.imaginary.sql.msql.ParsedRow;
import java.sql.SQLException;

public class MsqlRow {
    public static final int UNMODIFIED = 1;
    public static final int MODIFIED = 2;
    public static final int NEW = 3;
    public static final int DELETED = 4;
    private String encoding = "8859_1";
    private String[] modifications = null;
    private ParsedRow row = null;
    private int state = 1;

    MsqlRow(int n, String string) {
        this.modifications = new String[n];
        this.encoding = string;
    }

    MsqlRow(ParsedRow parsedRow, String string) {
        this.row = parsedRow;
        this.encoding = string;
    }

    void delete() {
        this.state = 4;
    }

    String getColumn(int n, int n2) throws SQLException {
        if (this.state != 1) {
            if (n2 == 1005) {
                return this.modifications[n];
            }
            if (this.row == null) {
                throw new MsqlException("Invalid row.");
            }
            return this.row.get(n);
        }
        return this.row.get(n);
    }

    boolean isDeleted() {
        return this.state == 4;
    }

    boolean isInserted() {
        return this.state == 3;
    }

    boolean isUpdated() {
        return this.state == 2;
    }

    void refresh() throws SQLException {
        this.modifications = null;
        if (this.state == 2) {
            this.state = 1;
            this.state = 1;
        }
    }

    void setColumn(int n, String string) throws SQLException {
        if (n < 0) {
            throw new MsqlException("Negative array index.");
        }
        if (this.modifications == null) {
            this.modifications = new String[this.row.size()];
            int n2 = 0;
            while (n2 < this.modifications.length) {
                this.modifications[n2] = this.row.get(n2);
                ++n2;
            }
        }
        if (n >= this.modifications.length) {
            throw new IndexOutOfBoundsException();
        }
        String string2 = this.modifications[n];
        if (string2 != null && string2.equals(string)) {
            return;
        }
        this.modifications[n] = string;
        if (this.state == 1) {
            this.state = 2;
        }
    }

    void update() throws SQLException {
        this.state = 1;
        int n = 0;
        while (n < this.row.size()) {
            this.row.set(n, this.modifications[n]);
            ++n;
        }
        this.modifications = null;
    }
}

