/* $Id: MsqlTypes.java,v 2.1 1999/07/06 05:50:59 borg Exp $ */
/* Copyright (c) 1999 George Reese */
package com.imaginary.sql.msql;

import java.sql.Types;

/**
 * Provides tools for moving around among SQL and mSQL data types using
 * both the SQL Types constants and the mSQL socket protocol constants.
 * <BR>
 * Last modified $Date: 1999/07/06 05:50:59 $
 * @version $Revision: 2.1 $
 * @author George Reese (borg@imaginary.com)
 */
public class MsqlTypes {
    static public final int INT    = 1;
    static public final int CHAR   = 2;
    static public final int REAL   = 3;
    static public final int IDENT  = 4;
    static public final int NULL   = 5;
    static public final int TEXT   = 6;
    static public final int DATE   = 7;
    static public final int UINT   = 8;
    static public final int MONEY  = 9;
    static public final int TIME   = 10;
    static public final int IDX    = 253;
    static public final int SYSVAR = 254;
    static public final int ANY    = 255;

    /**
     * Provides the mSQL type in the form of an <CODE>int<CODE> from
     * this class for the specified SQL type from <CODE>java.sql.Types</CODE>.
     * The conversion used here is the same conversion the driver uses.
     * @param sql the SQL type from <CODE>java.sql.Types</CODE>
     * @return an <CODE>int</CODE> value representing the mSQL type
     * @see java.sql.Types
     */
    static public int getMsqlTypeForSQL(int sql) {
	switch( sql ) {
	case Types.INTEGER:
	    return INT;

	case Types.CHAR:
	    return CHAR;

	case Types.DATE:
	    return DATE;

	case Types.DOUBLE:
	    return MONEY;
	    
	case Types.REAL:
	    return REAL;

	case Types.TIME:
	    return TIME;
	    
	case Types.VARCHAR:
	    return TEXT;

	case Types.OTHER: case Types.JAVA_OBJECT: case Types.DISTINCT:
	case Types.STRUCT: case Types.ARRAY: case Types.REF:
	    return ANY;
	    
	case Types.BLOB:
	    return TEXT;
	    
	case Types.CLOB:
	    return TEXT;

	default:
	    return NULL;
	}
    }

    /**
     * Provides a <CODE>String</CODE> representation of the specified
     * mSQL type. The representation is using the mSQL type system.
     * @param msql the mSQL type whose name is desired
     * @return the mSQL name for the specified type
     */
    static public String getMsqlTypeNameForMsql(int msql) {
	switch( msql ) {
	case INT: return "INT";
	case CHAR: return "CHAR";
	case REAL: return "REAL";
	case IDENT: return "IDENT";
	case NULL: return "NULL";
	case TEXT: return "TEXT";
	case DATE: return "DATE";
	case UINT: return "UINT";
	case MONEY: return "MONEY";
	case TIME: return "TIME";
	case IDX: return "IDX";
	case SYSVAR: return "SYSVAR";
	case ANY: return "ANY";
	default: return "NULL";
	}
    }

    /**
     * Provides the mSQL type name for the specified SQL type constant
     * from <CODE>java.sql.Types</CODE>.
     * @param sql the SQL type value
     * @return the mSQL type name
     * @see java.sql.Types
     */
    static public String getMsqlTypeNameForSQL(int sql) {
	switch( sql ) {
	case Types.INTEGER:
	    return "INT";

	case Types.CHAR:
	    return "CHAR";

	case Types.DATE:
	    return "DATE";

	case Types.DOUBLE:
	    return "MONEY";
	    
	case Types.REAL:
	    return "REAL";

	case Types.TIME:
	    return "TIME";
	    
	case Types.VARCHAR:
	    return "TEXT";

	case Types.OTHER: case Types.JAVA_OBJECT: case Types.DISTINCT:
	case Types.STRUCT: case Types.ARRAY: case Types.REF:
	    return "UNKNOWN";
	    
	case Types.BLOB:
	    return "BLOB";
	    
	case Types.CLOB:
	    return "CLOB";

	default:
	    return "NULL";
	}
    }

    /**
     * Provides the SQL type that corresponds to the specified mSQL type.
     * @param msql the desired mSQL type
     * @return the SQL type from <CODE>java.sql.Types</CODE>
     */
    static public int getSQLTypeForMsql(int msql) {
	switch( msql ) {
	case INT: return Types.INTEGER;
	case CHAR: return Types.CHAR;
	case REAL: return Types.REAL;
	case NULL: return Types.NULL;
	case TEXT: return Types.VARCHAR;
	case DATE: return Types.DATE;
	case UINT: return Types.INTEGER;
	case MONEY: return Types.DOUBLE;
	case TIME: return Types.TIME;
	case ANY: return Types.JAVA_OBJECT;
	default: return Types.NULL;
	}
    }
}
	
