/* $Id: MsqlUnicodeInputStream.java,v 2.1 1999/07/06 05:51:00 borg Exp $ */
/* Copyright (c) 1997 George Reese */
package com.imaginary.sql.msql;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

/**
 * Last modified $Date: 1999/07/06 05:51:00 $
 * @version $Revision: 2.1 $
 * @author George Reese (borg@imaginary.com)
 */
public class MsqlUnicodeInputStream extends FilterInputStream {
    /**
     * Constructs an MsqlUnicodeInputStream.
     * @param data the byte array representing the data to be streamed
     */
    public MsqlUnicodeInputStream(byte[] data) {
	super(new ByteArrayInputStream(data));
    }

    /**
     * Constructs an MsqlUnicodeInputStream for a string.
     * @param data the String to create a stream for
     * @throws java.io.UnsupportedEncodingException this should never
     * actually get thrown
     */
    public MsqlUnicodeInputStream(String data)
    throws UnsupportedEncodingException {
	this(data.getBytes("8859_1"));
    }

    public int read() throws IOException {
	int left = super.read();
	int right = super.read();

	return ((left<<8) + right);
    }
}
