/*
 * Decompiled with CFR 0.152.
 */
package xBaseJ;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Date;
import xBaseJ.DBF;
import xBaseJ.Field;
import xBaseJ.Index;
import xBaseJ.Message;
import xBaseJ.Server;
import xBaseJ.ServerDBF;
import xBaseJ.xBaseJException;

class ServerThread
extends Thread {
    Socket DBFSocket;
    Message myMessage;
    Message myResponse;
    InputStream inputStream;
    OutputStream outputStream;
    DataInputStream dataInStream;
    DataOutputStream dataOutStream;
    ServerDBF jaxDBFs;
    Server sframe;
    private String lastDBFConnectionID = "";

    public void finalize() throws IOException {
    }

    public ServerThread(Socket socket, ServerDBF serverDBF, Server server) throws IOException, xBaseJException {
        this.sframe = server;
        this.jaxDBFs = serverDBF;
        this.DBFSocket = socket;
        this.inputStream = this.DBFSocket.getInputStream();
        this.dataInStream = new DataInputStream(this.inputStream);
        this.outputStream = this.DBFSocket.getOutputStream();
        this.dataOutStream = new DataOutputStream(this.outputStream);
    }

    private void recCount(String string, Message message) throws xBaseJException {
        int n = 0;
        while (n < this.jaxDBFs.size()) {
            if (this.jaxDBFs.getId(n).trim().compareTo(string.trim()) == 0) {
                DBF dBF = this.jaxDBFs.getDBF(n);
                message.setHeader("Reccount", String.valueOf(dBF.getRecordCount()));
                return;
            }
            ++n;
        }
        message.setException("Exception", "Unknown DBF " + string);
    }

    private void Open(String string, Message message) throws xBaseJException {
        String string2 = this.lastDBFConnectionID;
        while (string2.compareTo(this.lastDBFConnectionID) == 0) {
            string2 = new Date().toString();
        }
        this.lastDBFConnectionID = string2;
        int n = 0;
        while (n < this.jaxDBFs.size()) {
            if (this.jaxDBFs.getId(n).trim().compareTo(string.trim()) == 0) {
                message.setHeader("Open", String.valueOf(String.valueOf(n)) + string);
                DBF dBF = this.jaxDBFs.getDBF(n);
                message.setField("ConnectionID", string2);
                message.setField("Fldcount", String.valueOf(dBF.getFieldCount()));
                int n2 = 1;
                while (n2 <= dBF.getFieldCount()) {
                    Field field = dBF.getField(n2);
                    message.setField("Name " + n2, field.getName());
                    message.setField("Type " + n2, String.valueOf(field.getType()));
                    message.setField("Length " + n2, String.valueOf(field.getLength()));
                    message.setField("DecPoint " + n2, String.valueOf(field.getDecimalPositionCount()));
                    ++n2;
                }
                return;
            }
            ++n;
        }
        message.setException("Exception", "Unknown DBF " + string);
    }

    private void Read(String string, Message message, Message message2) throws xBaseJException {
        message.getField(1);
        int n = Integer.parseInt(message.getField(2));
        int n2 = 0;
        while (n2 < this.jaxDBFs.size()) {
            if (this.jaxDBFs.getId(n2).trim().compareTo(string.trim()) == 0) {
                message2.setHeader("Read", String.valueOf(String.valueOf(n2)) + string);
                DBF dBF = this.jaxDBFs.getDBF(n2);
                try {
                    dBF.gotoRecord(n);
                    message2.setField("deleted", dBF.deleted() ? "deleted" : "not deleted");
                    int n3 = 1;
                    while (n3 <= dBF.getFieldCount()) {
                        Field field = dBF.getField(n3);
                        message2.setField(field.getName(), field.get());
                        ++n3;
                    }
                    return;
                }
                catch (IOException iOException) {
                    this.myResponse.setException("Exception", "IOException " + iOException.getMessage());
                    return;
                }
                catch (xBaseJException xBaseJException2) {
                    this.myResponse.setException("xBaseJException", xBaseJException2.getMessage());
                    return;
                }
            }
            ++n2;
        }
        message2.setException("Exception", "Unknown DBF " + string);
    }

    private void Write(String string, Message message, Message message2) throws xBaseJException {
        String string2 = message.getField(1);
        int n = 0;
        while (n < this.jaxDBFs.size()) {
            if (this.jaxDBFs.getId(n).trim().compareTo(string.trim()) == 0) {
                message2.setHeader("Write", String.valueOf(String.valueOf(n)) + string);
                DBF dBF = this.jaxDBFs.getDBF(n);
                try {
                    this.jaxDBFs.lockedOut(n, "-1", string2);
                    int n2 = 1;
                    while (n2 <= dBF.getFieldCount()) {
                        Field field = dBF.getField(n2);
                        field.put(message.getField(n2 + 1));
                        ++n2;
                    }
                    dBF.write();
                    message2.setField("deleted", dBF.deleted() ? "deleted" : "not deleted");
                    return;
                }
                catch (IOException iOException) {
                    this.myResponse.setException("Exception", "IOException " + iOException.getMessage());
                    return;
                }
                catch (xBaseJException xBaseJException2) {
                    this.myResponse.setException("xBaseJException", xBaseJException2.getMessage());
                    return;
                }
            }
            ++n;
        }
        message2.setException("Exception", "Unknown DBF " + string);
    }

    /*
     * Loose catch block
     */
    private void Update(String string, Message message, Message message2) throws xBaseJException {
        String string2 = message.getField(1);
        int n = 0;
        while (n < this.jaxDBFs.size()) {
            if (this.jaxDBFs.getId(n).trim().compareTo(string.trim()) == 0) {
                message2.setHeader("Update", String.valueOf(String.valueOf(n)) + string);
                DBF dBF = this.jaxDBFs.getDBF(n);
                try {
                    this.jaxDBFs.lockedOut(n, message.getField(2), string2);
                    dBF.gotoRecord(Integer.parseInt(message.getField(2)));
                }
                catch (IOException iOException) {
                    this.myResponse.setException("Exception", "IOException " + iOException.getMessage());
                }
                catch (xBaseJException xBaseJException2) {
                    this.myResponse.setException("xBaseJException", xBaseJException2.getMessage());
                }
                Object var10_12 = null;
                try {
                    int n2 = 1;
                    while (n2 <= dBF.getFieldCount()) {
                        Field field = dBF.getField(n2);
                        field.put(message.getField(n2 + 2));
                        ++n2;
                    }
                    dBF.update();
                    message2.setField("deleted", dBF.deleted() ? "deleted" : "not deleted");
                }
                catch (IOException exception) {
                    this.myResponse.setException("Exception", "IOException " + exception.getMessage());
                }
                catch (xBaseJException exception) {
                    this.myResponse.setException("xBaseJException", exception.getMessage());
                }
                return;
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    try {
                        int n3 = 1;
                        while (n3 <= dBF.getFieldCount()) {
                            Field field = dBF.getField(n3);
                            field.put(message.getField(n3 + 2));
                            ++n3;
                        }
                        dBF.update();
                        message2.setField("deleted", dBF.deleted() ? "deleted" : "not deleted");
                    }
                    catch (IOException iOException) {
                        this.myResponse.setException("Exception", "IOException " + iOException.getMessage());
                    }
                    catch (xBaseJException xBaseJException3) {
                        this.myResponse.setException("xBaseJException", xBaseJException3.getMessage());
                    }
                }
                throw throwable;
            }
            ++n;
        }
        message2.setException("Exception", "Unknown DBF " + string);
    }

    private void useIndex(String string, Message message, Message message2) throws xBaseJException {
        message.getField(1);
        int n = 0;
        while (n < this.jaxDBFs.size()) {
            if (this.jaxDBFs.getId(n).trim().compareTo(string.trim()) == 0) {
                message2.setHeader("UseIndex", String.valueOf(String.valueOf(n)) + string);
                DBF dBF = this.jaxDBFs.getDBF(n);
                try {
                    dBF.useIndexByID(message.getField(2));
                    return;
                }
                catch (xBaseJException xBaseJException2) {
                    this.myResponse.setException("xBaseJException", xBaseJException2.getMessage());
                    return;
                }
            }
            ++n;
        }
        message2.setException("Exception", "Unknown DBF " + string);
    }

    private void find(String string, Message message, Message message2) throws xBaseJException {
        message.getField(1);
        int n = 0;
        while (n < this.jaxDBFs.size()) {
            if (this.jaxDBFs.getId(n).trim().compareTo(string.trim()) == 0) {
                message2.setHeader("find", String.valueOf(String.valueOf(n)) + string);
                DBF dBF = this.jaxDBFs.getDBF(n);
                try {
                    Index index = dBF.useIndexByID(message.getField(2));
                    message2.setField("Index", message.getField(3));
                    boolean bl = dBF.find(message.getField(3));
                    message2.setField("key", index.buildKey());
                    message2.setField("recno", String.valueOf(dBF.getCurrentRecordNumber()));
                    message2.setField("deleted", dBF.deleted() ? "deleted" : "not deleted");
                    message2.setField("match", bl ? "true" : "false");
                    int n2 = 1;
                    while (n2 <= dBF.getFieldCount()) {
                        Field field = dBF.getField(n2);
                        message2.setField(field.getName(), field.get());
                        ++n2;
                    }
                    return;
                }
                catch (xBaseJException xBaseJException2) {
                    this.myResponse.setException("xBaseJException", xBaseJException2.getMessage());
                    return;
                }
                catch (IOException iOException) {
                    this.myResponse.setException("IOException", iOException.getMessage());
                    return;
                }
            }
            ++n;
        }
        message2.setException("Exception", "Unknown DBF " + string);
    }

    private void find_next(String string, Message message, Message message2) throws xBaseJException {
        message.getField(1);
        int n = 0;
        while (n < this.jaxDBFs.size()) {
            if (this.jaxDBFs.getId(n).trim().compareTo(string.trim()) == 0) {
                message2.setHeader("find_next", String.valueOf(String.valueOf(n)) + string);
                DBF dBF = this.jaxDBFs.getDBF(n);
                try {
                    Index index = dBF.useIndexByID(message.getField(2));
                    dBF.find(message.getField(3), Integer.parseInt(message.getField(4)));
                    dBF.findNext();
                    message2.setField("key", index.buildKey());
                    message2.setField("recno", String.valueOf(dBF.getCurrentRecordNumber()));
                    message2.setField("deleted", dBF.deleted() ? "deleted" : "not deleted");
                    int n2 = 1;
                    while (n2 <= dBF.getFieldCount()) {
                        Field field = dBF.getField(n2);
                        message2.setField(field.getName(), field.get());
                        ++n2;
                    }
                    return;
                }
                catch (xBaseJException xBaseJException2) {
                    this.myResponse.setException("xBaseJException", xBaseJException2.getMessage());
                    return;
                }
                catch (IOException iOException) {
                    this.myResponse.setException("IOException", iOException.getMessage());
                    return;
                }
            }
            ++n;
        }
        message2.setException("Exception", "Unknown DBF " + string);
    }

    private void find_prev(String string, Message message, Message message2) throws xBaseJException {
        message.getField(1);
        int n = 0;
        while (n < this.jaxDBFs.size()) {
            if (this.jaxDBFs.getId(n).trim().compareTo(string.trim()) == 0) {
                message2.setHeader("find", String.valueOf(String.valueOf(n)) + string);
                DBF dBF = this.jaxDBFs.getDBF(n);
                try {
                    Index index = dBF.useIndexByID(message.getField(2));
                    dBF.find(message.getField(3), Integer.parseInt(message.getField(4)));
                    dBF.findPrev();
                    message2.setField("key", index.buildKey());
                    message2.setField("recno", String.valueOf(dBF.getCurrentRecordNumber()));
                    message2.setField("deleted", dBF.deleted() ? "deleted" : "not deleted");
                    int n2 = 1;
                    while (n2 <= dBF.getFieldCount()) {
                        Field field = dBF.getField(n2);
                        message2.setField(field.getName(), field.get());
                        ++n2;
                    }
                    return;
                }
                catch (xBaseJException xBaseJException2) {
                    this.myResponse.setException("xBaseJException", xBaseJException2.getMessage());
                    return;
                }
                catch (IOException iOException) {
                    this.myResponse.setException("IOException", iOException.getMessage());
                    return;
                }
            }
            ++n;
        }
        message2.setException("Exception", "Unknown DBF " + string);
    }

    private void delete(String string, boolean bl, Message message, Message message2) throws xBaseJException {
        String string2 = message.getField(1);
        int n = Integer.parseInt(message.getField(2));
        int n2 = 0;
        while (n2 < this.jaxDBFs.size()) {
            if (this.jaxDBFs.getId(n2).trim().compareTo(string.trim()) == 0) {
                message2.setHeader("Delete", String.valueOf(String.valueOf(n2)) + string);
                DBF dBF = this.jaxDBFs.getDBF(n2);
                try {
                    this.jaxDBFs.lockedOut(n2, message.getField(2), string2);
                    dBF.gotoRecord(n);
                    if (bl) {
                        dBF.delete();
                        return;
                    }
                    dBF.undelete();
                    return;
                }
                catch (IOException iOException) {
                    this.myResponse.setException("Exception", "IOException " + iOException.getMessage());
                    return;
                }
                catch (xBaseJException xBaseJException2) {
                    this.myResponse.setException("xBaseJException", xBaseJException2.getMessage());
                    return;
                }
            }
            ++n2;
        }
        message2.setException("Exception", "Unknown DBF " + string);
    }

    private void lock(String string, Message message, Message message2) throws xBaseJException {
        Server.addText("type = " + message.getField(2));
        String string2 = message.getField(1);
        boolean bl = message.getField(2).compareTo("LockRecord") == 0;
        int n = 0;
        while (n < this.jaxDBFs.size()) {
            if (this.jaxDBFs.getId(n).trim().compareTo(string.trim()) == 0) {
                DBF dBF = this.jaxDBFs.getDBF(n);
                try {
                    this.jaxDBFs.lockedOut(n, message.getField(2), string2);
                    if (bl) {
                        this.jaxDBFs.setLockID(n, string2, message.getField(3));
                    } else {
                        this.jaxDBFs.setLockID(n, string2);
                    }
                    message2.setHeader("Lock", String.valueOf(String.valueOf(n)) + string);
                    return;
                }
                catch (xBaseJException xBaseJException2) {
                    message2.setException("xBaseJException", xBaseJException2.getMessage());
                    return;
                }
            }
            ++n;
        }
        message2.setException("Exception", "Unknown DBF " + string);
    }

    private void unlock(String string, Message message, Message message2) throws xBaseJException {
        String string2 = message.getField(1);
        boolean bl = message.getField(2).compareTo("LockRecord") == 0;
        int n = 0;
        while (n < this.jaxDBFs.size()) {
            if (this.jaxDBFs.getId(n).trim().compareTo(string.trim()) == 0) {
                DBF dBF = this.jaxDBFs.getDBF(n);
                try {
                    if (bl) {
                        this.jaxDBFs.unLockID(n, string2, message.getField(3));
                    } else {
                        this.jaxDBFs.unLockID(n, string2);
                    }
                    message2.setHeader("Unlock", String.valueOf(String.valueOf(n)) + string);
                    return;
                }
                catch (xBaseJException xBaseJException2) {
                    message2.setException("xBaseJException", xBaseJException2.getMessage());
                    return;
                }
            }
            ++n;
        }
        message2.setException("Exception", "Unknown DBF " + string);
    }

    public void run() {
        String[] stringArray = new String[]{"Open", "Reccount", "Read", "Write", "Update", "useIndex", "find", "findNext", "findPrev", "Delete", "Undelete", "Lock", "Unlock"};
        try {
            this.myMessage = new Message(this.dataInStream);
            this.myResponse = new Message();
            int n = 0;
            while (n < stringArray.length) {
                if (this.myMessage.getId().compareTo(stringArray[n]) == 0) {
                    String string = this.myMessage.getField(stringArray[n]);
                    Server.addText(String.valueOf(this.myMessage.getId()) + "(" + string + ") from " + this.DBFSocket.getInetAddress().getHostName());
                    Server.addText(this.myMessage.getId());
                    switch (n) {
                        case 0: {
                            this.Open(string, this.myResponse);
                            break;
                        }
                        case 1: {
                            this.recCount(string, this.myResponse);
                            break;
                        }
                        case 2: {
                            this.Read(string, this.myMessage, this.myResponse);
                            break;
                        }
                        case 3: {
                            this.Write(string, this.myMessage, this.myResponse);
                            break;
                        }
                        case 4: {
                            this.Update(string, this.myMessage, this.myResponse);
                            break;
                        }
                        case 5: {
                            this.useIndex(string, this.myMessage, this.myResponse);
                            break;
                        }
                        case 6: {
                            this.find(string, this.myMessage, this.myResponse);
                            break;
                        }
                        case 7: {
                            this.find_next(string, this.myMessage, this.myResponse);
                            break;
                        }
                        case 8: {
                            this.find_prev(string, this.myMessage, this.myResponse);
                            break;
                        }
                        case 9: {
                            this.delete(string, true, this.myMessage, this.myResponse);
                            break;
                        }
                        case 10: {
                            this.delete(string, false, this.myMessage, this.myResponse);
                            break;
                        }
                        case 11: {
                            this.lock(string, this.myMessage, this.myResponse);
                            break;
                        }
                        case 12: {
                            this.unlock(string, this.myMessage, this.myResponse);
                            break;
                        }
                        default: {
                            this.myResponse.setHeader("xBaseJException", "Not built yet " + stringArray[n]);
                            break;
                        }
                    }
                    break;
                }
                ++n;
            }
            if (n == stringArray.length) {
                Server.addText("Unknown request");
                this.myResponse.setHeader("xBaseJException", "Unknown request " + this.myMessage.getId());
            }
            this.myResponse.write(this.dataOutStream);
        }
        catch (IOException iOException) {
            System.out.println("caught an IOException during write response" + iOException.getMessage());
        }
        catch (xBaseJException xBaseJException2) {
            System.out.println("caught an xBaseJException" + xBaseJException2.getMessage());
        }
        try {
            this.DBFSocket.close();
            return;
        }
        catch (IOException iOException) {
            System.out.println("caught an IOException during socket close" + iOException.getMessage());
            return;
        }
    }
}

