/*
 * Decompiled with CFR 0.152.
 */
package xBaseJ;

import java.text.DateFormat;
import java.text.ParseException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.table.AbstractTableModel;
import xBaseJ.DBF;
import xBaseJ.Field;

class TableModel
extends AbstractTableModel {
    DBF currentDBF;
    int inRow;
    String[] columnName;
    int columnCount;
    int rowCount;
    DateFormat df;
    String[][] fld;
    Boolean[] deleted;
    JFrame parent;
    ProgressMonitor pm;

    public TableModel(String string, JFrame jFrame) {
        try {
            this.currentDBF = new DBF(string);
            this.df = DateFormat.getDateInstance(3);
            this.parent = jFrame;
            this.getData();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public TableModel() {
        this.columnCount = 0;
        this.rowCount = 0;
    }

    public void save() {
        try {
            int n = 0;
            while (n < this.rowCount) {
                this.currentDBF.gotoRecord(n + 1);
                int n2 = 0;
                while (n2 < this.columnCount) {
                    if (n2 == 0) {
                        Boolean bl = this.deleted[n];
                        if (bl.booleanValue()) {
                            this.currentDBF.delete();
                        } else {
                            this.currentDBF.undelete();
                        }
                    } else {
                        this.currentDBF.getField(n2).put(this.fld[n][n2]);
                    }
                    ++n2;
                }
                this.currentDBF.update();
                ++n;
            }
            return;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.parent, "not set yet caused an exception: " + exception.getMessage(), "Error Setting Field", 0);
            return;
        }
    }

    public String getColumnName(int n) {
        return this.columnName[n];
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 0) {
            this.deleted[n] = (Boolean)object;
            return;
        }
        String string = (String)object;
        string = string.trim();
        try {
            if (string.length() == 0) {
                this.fld[n][n2] = string;
                return;
            }
            if (this.currentDBF.getField(n2).getType() == 'D') {
                this.df.parse(string);
            } else if (this.currentDBF.getField(n2).getType() == 'F') {
                Float.valueOf(string);
            } else if (this.currentDBF.getField(n2).getType() == 'N') {
                Float.valueOf(string);
            }
            this.fld[n][n2] = string;
            return;
        }
        catch (ParseException parseException) {
            JOptionPane.showMessageDialog(this.parent, String.valueOf(string) + " is not the correct format for date fields.", "Invalid Date Field", 0);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this.parent, String.valueOf(string) + " is not the correct format for numeric fields.", "Invalid Floating Numeric Field", 0);
            return;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.parent, String.valueOf(string) + " caused an exception: " + exception.getMessage(), "Error Setting Field", 0);
            return;
        }
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return this.deleted[n];
        }
        return this.fld[n][n2];
    }

    public Class getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    public Field getColumnField(int n) throws Exception {
        return this.currentDBF.getField(n);
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    public void getData() throws Exception {
        this.rowCount = this.currentDBF.getRecordCount();
        this.columnCount = this.currentDBF.getFieldCount() + 1;
        this.columnName = new String[this.columnCount + 1];
        this.columnName[0] = "Deleted";
        int n = 1;
        while (n < this.columnCount) {
            this.columnName[n] = this.currentDBF.getField(n).getName();
            ++n;
        }
        this.deleted = new Boolean[this.rowCount];
        this.fld = new String[this.rowCount][this.columnCount];
        if (this.pm != null) {
            this.pm.setMaximum(this.rowCount);
            this.pm.setProgress(0);
            this.pm.setMillisToDecideToPopup(1000);
        }
        try {
            int n2 = 0;
            while (n2 < this.rowCount) {
                this.currentDBF.gotoRecord(n2 + 1);
                n = 0;
                while (n < this.columnCount) {
                    if (n == 0) {
                        this.deleted[n2] = new Boolean(this.currentDBF.deleted());
                    } else {
                        this.fld[n2][n] = this.currentDBF.getField(n).get();
                    }
                    ++n;
                }
                ++n2;
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

