/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.JSerial;

import java.io.IOException;
import org.jSyncManager.JSerial.SerialDataBitException;
import org.jSyncManager.JSerial.SerialGrabException;
import org.jSyncManager.JSerial.SerialHandshakingException;
import org.jSyncManager.JSerial.SerialInitializationException;
import org.jSyncManager.JSerial.SerialParityException;
import org.jSyncManager.JSerial.SerialReleaseException;
import org.jSyncManager.JSerial.SerialSpeedException;
import org.jSyncManager.JSerial.SerialStopBitException;

public class SerialPeer {
    public static final String NOPORT = new String("*** Requested Port does not exist.");
    public static final String PORTUNAVAILABLE = new String("*** The requested port is unavailable.");
    private byte port;
    private int speed;
    private int databits;
    private int parity;
    private int stopbits;
    private boolean status = false;

    public SerialPeer(byte port) throws SerialInitializationException {
        if (!this.checkPort(port)) {
            throw new SerialInitializationException(NOPORT);
        }
        this.port = port;
    }

    public native void grabPort() throws SerialGrabException;

    public native void setSpeed(int var1) throws SerialSpeedException;

    public native void setDataBits(int var1) throws SerialDataBitException;

    public native void setParity(int var1) throws SerialParityException;

    public native void setStopBits(int var1) throws SerialStopBitException;

    public native int getChar() throws IOException;

    public native void putChar(int var1) throws IOException;

    public static native String getPlatformName();

    public static native String getVersion();

    public byte getPort() {
        return this.port;
    }

    public int getSpeed() {
        return this.speed;
    }

    public int getDataBits() {
        return this.databits;
    }

    public int getParity() {
        return this.parity;
    }

    public int getStopBits() {
        return this.stopbits;
    }

    public native void releasePort() throws SerialReleaseException;

    public boolean portStatus() {
        return !this.status;
    }

    public native boolean checkPort(byte var1);

    public native void setRTSCTS(boolean var1) throws SerialHandshakingException;

    public native void setDSRDTR(boolean var1) throws SerialHandshakingException;

    public native void setXONXOFF(boolean var1) throws SerialHandshakingException;

    public native void startBreak();

    public native void stopBreak();

    public native boolean getRTSCTSState();

    public native boolean getDSRDTRState();

    public native boolean getXONXOFFState();

    static {
        System.loadLibrary("jserial");
    }
}

