/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.JSerial.TestSuite;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import org.jSyncManager.JSerial.SerialDataBitException;
import org.jSyncManager.JSerial.SerialGrabException;
import org.jSyncManager.JSerial.SerialHandshakingException;
import org.jSyncManager.JSerial.SerialInitializationException;
import org.jSyncManager.JSerial.SerialInterface;
import org.jSyncManager.JSerial.SerialParityException;
import org.jSyncManager.JSerial.SerialReleaseException;
import org.jSyncManager.JSerial.SerialSpeedException;
import org.jSyncManager.JSerial.SerialStopBitException;
import org.jSyncManager.JSerial.TestSuite.AboutBox;
import org.jSyncManager.JSerial.TestSuite.CommSettingsPanel;
import org.jSyncManager.JSerial.TestSuite.TerminalThread;

public class TerminalUI
extends Frame
implements ActionListener,
ItemListener,
WindowListener {
    public boolean connectFlag = false;
    public Thread inputThread = null;
    public DataInputStream is = null;
    private AboutBox ivjAboutBox1 = null;
    private CheckboxMenuItem ivjCheckboxMenuItem1 = null;
    private CommSettingsPanel ivjCommSettingsPanel1 = null;
    private Menu ivjMenu1 = null;
    private MenuItem ivjMenuItem1 = null;
    private MenuItem ivjMenuItem2 = null;
    private MenuItem ivjMenuItem3 = null;
    private MenuItem ivjMenuItem4 = null;
    private Panel ivjPanel1 = null;
    private Button ivjstartButton = null;
    private MenuBar ivjTerminalUIMenuBar = null;
    private TextArea ivjterminalViewer = null;
    private TextField ivjTextField1 = null;
    public boolean localEcho = false;
    public DataOutputStream os = null;
    public SerialInterface serial = null;
    public TerminalThread t = null;
    static /* synthetic */ Class class$java$awt$Window;

    public TerminalUI() {
        this.initialize();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getMenuItem3()) {
            this.conn1(e);
        }
        if (e.getSource() == this.getMenuItem4()) {
            this.conn2(e);
        }
        if (e.getSource() == this.getTextField1()) {
            this.conn4(e);
        }
        if (e.getSource() == this.getstartButton()) {
            this.conn6(e);
        }
        if (e.getSource() == this.getTextField1()) {
            this.conn7(e);
        }
        if (e.getSource() == this.getMenuItem1()) {
            this.conn3(e);
        }
    }

    private void conn0(WindowEvent arg1) {
        try {
            this.dispose();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void conn1(ActionEvent arg1) {
        try {
            this.getAboutBox1().show();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void conn2(ActionEvent arg1) {
        try {
            this.dispose();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void conn3(ActionEvent arg1) {
        try {
            this.getterminalViewer().setText(new String());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void conn4(ActionEvent arg1) {
        try {
            this.sendString(this.getTextField1().getText());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void conn6(ActionEvent arg1) {
        try {
            this.connectToPort();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void conn7(ActionEvent arg1) {
        try {
            this.getTextField1().setText(new String());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void conn8(ItemEvent arg1) {
        try {
            this.setLocalEcho(this.getCheckboxMenuItem1().getState());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connectToPort() {
        if (this.connectFlag) {
            try {
                this.serial.releasePort();
            }
            catch (SerialReleaseException e) {
                this.getterminalViewer().append("*** Unable to release port!\n");
                return;
            }
            this.t.setRunning(false);
            try {
                this.inputThread.interrupt();
            }
            catch (SecurityException e) {
                System.out.println("*** Unable to stop thread!");
            }
            this.inputThread = null;
            this.getstartButton().setLabel("Initialize Port");
            this.getCommSettingsPanel1().setEnabled(true);
            this.serial = null;
            try {
                this.is.close();
                this.os.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.is = null;
            this.os = null;
            this.connectFlag = false;
            return;
        }
        int speed = 0;
        int port = 0;
        port = this.getCommSettingsPanel1().getPortSelect().getSelectedIndex();
        try {
            speed = Integer.parseInt(this.getCommSettingsPanel1().getSpeedSelect().getSelectedItem());
        }
        catch (Exception e) {
            this.getterminalViewer().append("*** Error parsing speed value.\n");
            this.getterminalViewer().append("*** Exception: " + e.toString());
            this.getterminalViewer().append("*** Value selected: " + this.getCommSettingsPanel1().getSpeedSelect().getSelectedItem());
            return;
        }
        try {
            this.serial = new SerialInterface((byte)port, speed);
        }
        catch (SerialInitializationException e1) {
            this.getterminalViewer().append("*** Unable to initialize port (may already be in use).\n");
            return;
        }
        catch (SerialSpeedException e2) {
            this.getterminalViewer().append("***Unable to set Speed to " + speed + ".\n");
            return;
        }
        catch (SerialDataBitException e3) {
            this.getterminalViewer().append("*** Error initializing with default databit size.\n");
            return;
        }
        catch (SerialParityException e4) {
            this.getterminalViewer().append("*** Error initializing with default parity.\n");
            return;
        }
        catch (SerialStopBitException e5) {
            this.getterminalViewer().append("*** Error initializing with default stop bit value.\n");
            return;
        }
        catch (SerialGrabException e6) {
            this.getterminalViewer().append("*** Unable to grab port (may already be in use).\n");
            return;
        }
        this.getstartButton().setLabel("Disconnect");
        this.getCommSettingsPanel1().setEnabled(false);
        TerminalUI terminalUI = this;
        TerminalUI terminalUI2 = this;
        this.getterminalViewer().append("*** Connected:\n" + terminalUI.serial.getPlatformName() + "\n" + terminalUI2.serial.getPeerVersion() + "\n\n");
        this.os = new DataOutputStream(this.serial.getOutputStream());
        this.is = new DataInputStream(this.serial.getInputStream());
        this.t = new TerminalThread(this.is, this);
        this.inputThread = new Thread(this.t);
        try {
            this.inputThread.setPriority(1);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.connectFlag = true;
        try {
            this.serial.setRTSCTS(true);
        }
        catch (SerialHandshakingException serialHandshakingException) {
            // empty catch block
        }
        this.t.setRunning(true);
        this.inputThread.start();
    }

    private AboutBox getAboutBox1() {
        if (this.ivjAboutBox1 == null) {
            try {
                this.ivjAboutBox1 = new AboutBox(this);
                this.ivjAboutBox1.setName("AboutBox1");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjAboutBox1;
    }

    private CheckboxMenuItem getCheckboxMenuItem1() {
        if (this.ivjCheckboxMenuItem1 == null) {
            try {
                this.ivjCheckboxMenuItem1 = new CheckboxMenuItem();
                this.ivjCheckboxMenuItem1.setLabel("Local Echo Enabled");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCheckboxMenuItem1;
    }

    private CommSettingsPanel getCommSettingsPanel1() {
        if (this.ivjCommSettingsPanel1 == null) {
            try {
                this.ivjCommSettingsPanel1 = new CommSettingsPanel();
                this.ivjCommSettingsPanel1.setName("CommSettingsPanel1");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCommSettingsPanel1;
    }

    private boolean getLocalEcho() {
        return this.localEcho;
    }

    private Menu getMenu1() {
        if (this.ivjMenu1 == null) {
            try {
                this.ivjMenu1 = new Menu();
                this.ivjMenu1.setLabel("Options");
                this.ivjMenu1.add(this.getMenuItem1());
                this.ivjMenu1.add(this.getCheckboxMenuItem1());
                this.ivjMenu1.add(this.getMenuItem4());
                this.ivjMenu1.add(this.getMenuItem2());
                this.ivjMenu1.add(this.getMenuItem3());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjMenu1;
    }

    private MenuItem getMenuItem1() {
        if (this.ivjMenuItem1 == null) {
            try {
                this.ivjMenuItem1 = new MenuItem();
                this.ivjMenuItem1.setLabel("Clear Terminal Window");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjMenuItem1;
    }

    private MenuItem getMenuItem2() {
        if (this.ivjMenuItem2 == null) {
            try {
                this.ivjMenuItem2 = new MenuItem();
                this.ivjMenuItem2.setLabel("-");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjMenuItem2;
    }

    private MenuItem getMenuItem3() {
        if (this.ivjMenuItem3 == null) {
            try {
                this.ivjMenuItem3 = new MenuItem();
                this.ivjMenuItem3.setLabel("About...");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjMenuItem3;
    }

    private MenuItem getMenuItem4() {
        if (this.ivjMenuItem4 == null) {
            try {
                this.ivjMenuItem4 = new MenuItem();
                this.ivjMenuItem4.setLabel("Return to Main Menu");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjMenuItem4;
    }

    private Panel getPanel1() {
        GridBagConstraints constraintsCommSettingsPanel1 = new GridBagConstraints();
        GridBagConstraints constraintsstartButton = new GridBagConstraints();
        GridBagConstraints constraintsTextField1 = new GridBagConstraints();
        if (this.ivjPanel1 == null) {
            try {
                this.ivjPanel1 = new Panel();
                this.ivjPanel1.setName("Panel1");
                this.ivjPanel1.setLayout(new GridBagLayout());
                this.ivjPanel1.setBackground(Color.lightGray);
                constraintsCommSettingsPanel1.gridx = 0;
                constraintsCommSettingsPanel1.gridy = 3;
                constraintsCommSettingsPanel1.gridwidth = 1;
                constraintsCommSettingsPanel1.gridheight = 1;
                constraintsCommSettingsPanel1.fill = 2;
                constraintsCommSettingsPanel1.anchor = 10;
                constraintsCommSettingsPanel1.weightx = 0.8;
                constraintsCommSettingsPanel1.weighty = 0.0;
                ((GridBagLayout)this.getPanel1().getLayout()).setConstraints(this.getCommSettingsPanel1(), constraintsCommSettingsPanel1);
                this.getPanel1().add(this.getCommSettingsPanel1());
                constraintsstartButton.gridx = 1;
                constraintsstartButton.gridy = 3;
                constraintsstartButton.gridwidth = 1;
                constraintsstartButton.gridheight = 1;
                constraintsstartButton.fill = 2;
                constraintsstartButton.anchor = 10;
                constraintsstartButton.weightx = 0.2;
                constraintsstartButton.weighty = 0.0;
                ((GridBagLayout)this.getPanel1().getLayout()).setConstraints(this.getstartButton(), constraintsstartButton);
                this.getPanel1().add(this.getstartButton());
                constraintsTextField1.gridx = 0;
                constraintsTextField1.gridy = 0;
                constraintsTextField1.gridwidth = 0;
                constraintsTextField1.gridheight = 1;
                constraintsTextField1.fill = 2;
                constraintsTextField1.anchor = 10;
                constraintsTextField1.weightx = 0.0;
                constraintsTextField1.weighty = 0.0;
                ((GridBagLayout)this.getPanel1().getLayout()).setConstraints(this.getTextField1(), constraintsTextField1);
                this.getPanel1().add(this.getTextField1());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPanel1;
    }

    private Button getstartButton() {
        if (this.ivjstartButton == null) {
            try {
                this.ivjstartButton = new Button();
                this.ivjstartButton.setName("startButton");
                this.ivjstartButton.setLabel("Initialize Port");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjstartButton;
    }

    private MenuBar getTerminalUIMenuBar() {
        if (this.ivjTerminalUIMenuBar == null) {
            try {
                this.ivjTerminalUIMenuBar = new MenuBar();
                this.ivjTerminalUIMenuBar.add(this.getMenu1());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTerminalUIMenuBar;
    }

    private TextArea getterminalViewer() {
        if (this.ivjterminalViewer == null) {
            try {
                this.ivjterminalViewer = new TextArea();
                this.ivjterminalViewer.setName("terminalViewer");
                this.ivjterminalViewer.setText("Not Connected.");
                this.ivjterminalViewer.setBackground(Color.black);
                this.ivjterminalViewer.setForeground(Color.green);
                this.ivjterminalViewer.setEditable(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjterminalViewer;
    }

    private TextField getTextField1() {
        if (this.ivjTextField1 == null) {
            try {
                this.ivjTextField1 = new TextField();
                this.ivjTextField1.setName("TextField1");
                this.ivjTextField1.setBackground(Color.white);
                this.ivjTextField1.setForeground(new Color(0, 0, 93));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTextField1;
    }

    private void handleException(Throwable exception) {
    }

    private void initConnections() {
        this.addWindowListener(this);
        this.getMenuItem3().addActionListener(this);
        this.getMenuItem4().addActionListener(this);
        this.getTextField1().addActionListener(this);
        this.getstartButton().addActionListener(this);
        this.getMenuItem1().addActionListener(this);
        this.getCheckboxMenuItem1().addItemListener(this);
    }

    private void initialize() {
        this.setName("TerminalUI");
        this.setName("TerminalUI");
        this.setMenuBar(this.getTerminalUIMenuBar());
        this.setLayout(new BorderLayout());
        this.setSize(626, 420);
        this.setTitle("Simple Java Terminal - By Brad Barclay");
        this.add("South", this.getPanel1());
        this.add("Center", this.getterminalViewer());
        this.initConnections();
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.getCheckboxMenuItem1()) {
            this.conn8(e);
        }
    }

    public static void main(String[] args) {
        try {
            TerminalUI aTerminalUI = new TerminalUI();
            try {
                Class<?> aCloserClass = Class.forName("uvm.abt.edit.WindowCloser");
                Class[] parmTypes = new Class[]{class$java$awt$Window == null ? (class$java$awt$Window = TerminalUI.class$("java.awt.Window")) : class$java$awt$Window};
                Object[] parms = new Object[]{aTerminalUI};
                Constructor<?> aCtor = aCloserClass.getConstructor(parmTypes);
                aCtor.newInstance(parms);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            aTerminalUI.setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of java.awt.Frame");
        }
    }

    private void sendString(String msg) {
        if (this.connectFlag) {
            try {
                this.os.writeBytes(msg + "\r");
            }
            catch (IOException e) {
                this.getterminalViewer().append("*** Unable to write string to buffer.\n");
            }
            if (this.getLocalEcho()) {
                this.getterminalViewer().append(msg + "\n");
            }
        } else {
            this.getterminalViewer().append("*** Port is not open.\n");
        }
    }

    private void setLocalEcho(boolean b) {
        this.localEcho = b;
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        if (e.getSource() == this) {
            this.conn0(e);
        }
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    protected void writeChar(char c) {
        this.getterminalViewer().append("" + c);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

