/**
 *
 *         (C) Sergey Posokhov - JavaDive, Rinat Sadretdinov - Iopl32.
 *
 */

#define INCL_DOS
#define INCL_DOSERRORS
#define INCL_DOSDEVIOCTL

#include <OS2.h>
#include <String.h>

#include "..\\Java2C\\Java2C.h"
#include "..\\Iopl32\\Iopl32.h"

#define SIZE_OF_COMMAND 1024

/*
 #define PRINT_DEBUG_MESSAGES
*/

                                         /*  */

JAVAINT EXPENTRY Java_JavaDive_Dive_readByteFromHardwarePort( PVOID This, JAVALONG Port )
{
 INT Address = J2CConvertToInteger( &Port );
 IoplDiveToNextRing(); INT Value = inp( Address ); IoplLeaveRing();

 return Value;
}

JAVAINT EXPENTRY Java_JavaDive_Dive_readWordFromHardwarePort( PVOID This, JAVALONG Port )
{
 INT Address = J2CConvertToInteger( &Port );
 IoplDiveToNextRing(); INT Value = inpw( Address ); IoplLeaveRing();

 return Value;
}

VOID EXPENTRY Java_JavaDive_Dive_writeByteToHardwarePort( PVOID This, JAVALONG Port, JAVALONG Value )
{
 INT Address = J2CConvertToInteger( &Port ); INT Data = J2CConvertToInteger( &Value );
 IoplDiveToNextRing(); outp( Address, Data ); IoplLeaveRing();
}

VOID EXPENTRY Java_JavaDive_Dive_writeWordToHardwarePort( PVOID This, JAVALONG Port, JAVALONG Value )
{
 INT Address = J2CConvertToInteger( &Port ); INT Data = J2CConvertToInteger( &Value );
 IoplDiveToNextRing(); outpw( Address, Data ); IoplLeaveRing();
}

                                         /*  */

VOID SelectCommunicationPort( INT Port, PCHAR Name )
{
 switch( Port )
  {
   case -1: strcpy( Name, "\\Dev\\COM1" ); break; case -2: strcpy( Name, "\\Dev\\COM2" ); break;
   case -3: strcpy( Name, "\\Dev\\COM3" ); break; case -4: strcpy( Name, "\\Dev\\COM4" ); break;
   case -5: strcpy( Name, "\\Dev\\COM5" ); break; case -6: strcpy( Name, "\\Dev\\COM6" ); break;
   case -7: strcpy( Name, "\\Dev\\COM7" ); break; case -8: strcpy( Name, "\\Dev\\COM8" ); break;

   case -1001: strcpy( Name, "\\Dev\\LPT1" ); break; case -1002: strcpy( Name, "\\Dev\\LPT2" ); break;
   case -1003: strcpy( Name, "\\Dev\\LPT3" ); break; case -1004: strcpy( Name, "\\Dev\\LPT4" ); break;
   case -1005: strcpy( Name, "\\Dev\\LPT5" ); break; case -1006: strcpy( Name, "\\Dev\\LPT6" ); break;
   case -1007: strcpy( Name, "\\Dev\\LPT7" ); break; case -1008: strcpy( Name, "\\Dev\\LPT8" ); break;
  }
}

JAVAINT EXPENTRY Java_JavaDive_Dive_readByteFromCommunicationPort( PVOID This, JAVALONG Port_to_access )
{
 CHAR Port_name[ 10 ] = ""; SelectCommunicationPort( J2CConvertToInteger( &Port_to_access ), Port_name );

 HFILE File = NULLHANDLE; ULONG Report = 0;
 DosOpen( Port_name, &File, &Report, 0, FILE_NORMAL, FILE_OPEN, OPEN_ACCESS_READONLY | OPEN_SHARE_DENYNONE, NULL );

 if( File == NULLHANDLE )
  {
   #ifdef PRINT_DEBUG_MESSAGES
   CHAR English_message[ 75 ] = "JavaDive: Unable to open the port "; strcat( English_message, &Port_name[ 5 ] );
   CHAR Russian_message[ 75 ] = "JavaDive:      "; strcat( Russian_message, &Port_name[ 5 ] );
   SystemOutPrintln( English_message, Russian_message );
   #endif

   return 0;
  }

 BYTE Data[ 1 ] = { 0 }; ULONG BytesRead = 0;
 Report = DosRead( File, Data, 1, &BytesRead );

 if( Report != NO_ERROR )
  {
   CHAR English_message[ 75 ] = "JavaDive: Unable to read from port "; strcat( English_message, &Port_name[ 5 ] );
   CHAR Russian_message[ 75 ] = "JavaDive:  ⥭   "; strcat( Russian_message, &Port_name[ 5 ] );
   SystemOutPrintln( English_message, Russian_message );

   DosClose( File );
   return 0;
  }

 DosClose( File );

 return Data[ 0 ];
}

VOID EXPENTRY Java_JavaDive_Dive_writeByteToCommunicationPort( PVOID This, JAVALONG Port_to_access, JAVALONG Value )
{
 CHAR Port_name[ 10 ] = ""; SelectCommunicationPort( J2CConvertToInteger( &Port_to_access ), Port_name );

 HFILE File = NULLHANDLE; ULONG Report = 0;
 DosOpen( Port_name, &File, &Report, 0, FILE_NORMAL, FILE_OPEN, OPEN_ACCESS_WRITEONLY | OPEN_SHARE_DENYNONE, NULL );

 if( File == NULLHANDLE )
  {
   #ifdef PRINT_DEBUG_MESSAGES
   CHAR English_message[ 75 ] = "JavaDive: Unable to open the port "; strcat( English_message, &Port_name[ 5 ] );
   CHAR Russian_message[ 75 ] = "JavaDive:      "; strcat( Russian_message, &Port_name[ 5 ] );
   SystemOutPrintln( English_message, Russian_message );
   #endif

   return;
  }

 BYTE Data = (BYTE) J2CConvertToInteger( &Value );
 Report = DosWrite( File, &Data, 1, &Report );

 if( Report != NO_ERROR )
  {
   CHAR English_message[ 75 ] = "JavaDive: Unable to write to port "; strcat( English_message, &Port_name[ 5 ] );
   CHAR Russian_message[ 75 ] = "JavaDive:     "; strcat( Russian_message, &Port_name[ 5 ] );
   SystemOutPrintln( English_message, Russian_message );

   DosClose( File );
   return;
  }

 DosClose( File );
}

VOID EXPENTRY Java_JavaDive_Dive_talkWithDeviceViaCommunicationPort( PVOID This, JAVALONG Port, JAVALONG Port_rate, JAVALONG Queue_handle )
{
 CHAR Port_name[ 10 ] = ""; SelectCommunicationPort( J2CConvertToInteger( &Port ), Port_name );

 HFILE File = NULLHANDLE; ULONG Report = 0;
 DosOpen( Port_name, &File, &Report, 0, FILE_NORMAL, FILE_OPEN, OPEN_ACCESS_READWRITE | OPEN_SHARE_DENYNONE, NULL );

 if( File == NULLHANDLE )
  {
   #ifdef PRINT_DEBUG_MESSAGES
   CHAR English_message[ 75 ] = "JavaDive: Unable to open the port "; strcat( English_message, &Port_name[ 5 ] );
   CHAR Russian_message[ 75 ] = "JavaDive:      "; strcat( Russian_message, &Port_name[ 5 ] );
   SystemOutPrintln( English_message, Russian_message );
   #endif

   J2CWriteString( J2CConvertToHandle( &Queue_handle ), "" );
   return;
  }

 ULONG Rate = J2CConvertToInteger( &Port_rate ); ULONG Parameters = 2;
 Report = DosDevIOCtl( File, IOCTL_ASYNC, ASYNC_SETBAUDRATE, &Rate, sizeof( Rate ), &Parameters, NULL, 0, NULL );

 if( Report != NO_ERROR )
  {
   CHAR English_message[ 75 ] = "JavaDive: Unable to write to port "; strcat( English_message, &Port_name[ 5 ] );
   CHAR Russian_message[ 75 ] = "JavaDive:     "; strcat( Russian_message, &Port_name[ 5 ] );
   SystemOutPrintln( English_message, Russian_message );

   J2CWriteString( J2CConvertToHandle( &Queue_handle ), "" );
   DosClose( File );
   return;
  }

 HQUEUE Queue = J2CConvertToHandle( &Queue_handle );
 CHAR Command[ SIZE_OF_COMMAND ] = ""; J2CReadString( Queue, Command );
 CHAR Markers[ SIZE_OF_COMMAND ] = ""; J2CReadString( Queue, Markers );

 DosWrite( File, Command, strlen( Command ), &Report );

 CHAR Reply[ SIZE_OF_COMMAND ] = "";
 for( INT Count = 0; Count < SIZE_OF_COMMAND - 1; Count ++ )
  {
   ULONG BytesRead = 0; DosRead( File, &Reply[ Count ], 1, &BytesRead );

   BYTE Stop_reading = 0;
   if( strlen( Markers ) == 0 )
    {
     if( Reply[ Count ] == 0 ) Stop_reading = 1;
    }
   else
    {
     for( INT Marker_count = 0; Marker_count < strlen( Markers ); Marker_count ++ )
      if( Reply[ Count ] == Markers[ Marker_count ] ) Stop_reading = 1;
    }

   if( Stop_reading ) break;
  }
 Reply[ Count + 1 ] = 0;

 DosClose( File );

 J2CWriteString( Queue, Reply );
}

