
package JavaDive;

/**
 * 	[En]	Java to C++ interface		[En]
 * 	[Ru]	 Java  C++		[Ru]
 */

public final class Java2C 
{
	static
	{
		System.loadLibrary( "Java2C.dll" );
	}	


/**
 * 	[En]	Creates an OS/2 queue	[En]
 * 	[Ru]	 । OS/2	[Ru]
 */

public native static int createQueue( );


/**
 * 	[En]	Deletes an OS/2 queue, this is not necesary	 if it was cleared out		[En]
 * 	[Ru]	 ।,  祬  ᫨  祭 ࠭  	[Ru]
 */

public native static void deleteQueue( );


/**
 * 	[En]	Checks an OS/2 queue		[En]
 * 	[Ru]	஢ ।		[Ru]
 */

public native static boolean queueIsEmpty ( long queueHandle );



native static int readFDivider ( long queueHandle );

/**
 * 	[En]	Reads a float value from OS/2 queue		[En]
 * 	[Ru]	⠥ 祭  窮	  ।	[Ru]
 */

public static float readFloat ( long queueHandle )
{
	float value = readFValue( queueHandle );
	float divider = readFDivider( queueHandle );
	
	return value / divider;
}


native static int readFValue ( long queueHandle );


/**
 * 	[En]	Reads an integer value from OS/2 queue		[En]
 * 	[Ru]	⠥ 楫 ᫮  ।				[Ru]
 */

public native static int readInteger ( long queueHandle );



native static int readSCharacter ( long queueHandle );



native static boolean readSMarker ( long queueHandle );

/**
 * 	[En]	Reads a "stopper" from OS/2 queue		[En]
 * 	[Ru]	 ""  ।			[Ru]
 */

public static void readStopper ( long queueHandle )
{
	readInteger( queueHandle );
}	
/**
 * 	[En]	Reads a string from OS/2 queue		[En]
 * 	[Ru]	⠥ ப  ।			[Ru]
 */

public static String readString ( long queueHandle )
{
	boolean markerIsFound = readSMarker( queueHandle );	 
	if( !markerIsFound ) return null;
	
	StringBuffer string = new StringBuffer();
	while( true )
	{
		char value = (char) readSCharacter( queueHandle );
		if( value != 0 ) string.append( value ); else break;
	}	

	return new String( string );
}	

/**
 * 	[En]	Writes a float value to OS/2 queue			[En]
 * 	[Ru]	  । 祭  窮		[Ru]
 */

public native static void writeFloat ( long queueHandle, long value, long divider );


/**
 * 	[En]	Writes a long value to OS/2 queue			[En]
 * 	[Ru]	  । 楫 ᫮		[Ru]
 */

public native static void writeInteger ( long queueHandle, long value );



native static void writeSCharacter ( long queueHandle, long character );



native static void writeSMarker ( long queueHandle );

/**
 * 	[En]	Writes a "stopper" to OS/2 queue to keep it alive			[En]
 * 	[Ru]	  । "", ⮡   㤠		[Ru]
 */

public static void writeStopper ( long queueHandle )
{
	writeInteger( queueHandle, 0 );
}	
/**
 * 	[En]	Writes a string to OS/2 queue	[En]
 * 	[Ru]	  । ப		[Ru]
 */

public static void writeString ( long queueHandle, String string )
{
	char [] bytes = string.toCharArray();

	writeSMarker( queueHandle );	
	for( int count = 0; count < bytes.length; count ++ ) writeSCharacter( queueHandle, bytes[ count ] );
	writeSCharacter( queueHandle, 0 );	
}	
}