/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing;

import com.l2fprod.common.swing.plaf.JOutlookBarAddon;
import com.l2fprod.common.swing.plaf.LookAndFeelAddons;
import com.l2fprod.common.swing.plaf.OutlookBarUI;
import java.awt.Color;
import java.awt.Component;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.plaf.TabbedPaneUI;

public class JOutlookBar
extends JTabbedPane {
    public static final String UI_CLASS_ID = "OutlookBarUI";
    public static final String ANIMATED_CHANGED_KEY = "animated";
    protected Map extendedPages = new WeakHashMap();
    private boolean animated = true;
    static /* synthetic */ Class class$com$l2fprod$common$swing$plaf$OutlookBarUI;

    public JOutlookBar() {
        this(2);
    }

    public JOutlookBar(int tabPlacement) {
        super(tabPlacement, 0);
        this.updateUI();
    }

    public void updateUI() {
        this.setUI((OutlookBarUI)((Object)LookAndFeelAddons.getUI(this, class$com$l2fprod$common$swing$plaf$OutlookBarUI == null ? (class$com$l2fprod$common$swing$plaf$OutlookBarUI = JOutlookBar.class$("com.l2fprod.common.swing.plaf.OutlookBarUI")) : class$com$l2fprod$common$swing$plaf$OutlookBarUI, UIManager.getUI(this))));
    }

    public void setUI(OutlookBarUI ui) {
        super.setUI((TabbedPaneUI)((Object)ui));
    }

    public String getUIClassID() {
        return UI_CLASS_ID;
    }

    public void setAnimated(boolean animated) {
        if (this.animated != animated) {
            this.animated = animated;
            this.firePropertyChange(ANIMATED_CHANGED_KEY, !animated, animated);
        }
    }

    public boolean isAnimated() {
        return this.animated;
    }

    public JScrollPane makeScrollPane(Component component) {
        return ((OutlookBarUI)((Object)this.getUI())).makeScrollPane(component);
    }

    public void removeTabAt(int index) {
        this.checkIndex(index);
        this.removeExtendedPage(index);
        super.removeTabAt(index);
    }

    public void setAllTabsAlignment(int alignment) {
        Iterator iter = this.extendedPages.values().iterator();
        while (iter.hasNext()) {
            ExtendedPage page = (ExtendedPage)iter.next();
            page.setTabAlignment(alignment);
        }
    }

    public void setAlignmentAt(int index, int alignment) {
        this.getExtendedPage(index).setTabAlignment(alignment);
    }

    public int getAlignmentAt(int index) {
        return this.getExtendedPage(index).getTabAlignment();
    }

    public void setTitleAt(int index, String title) {
        super.setTitleAt(index, title);
        this.firePropertyChange("tabPropertyChangedAtIndex", null, new Integer(index));
    }

    public void setIconAt(int index, Icon icon) {
        super.setIconAt(index, icon);
        this.firePropertyChange("tabPropertyChangedAtIndex", null, new Integer(index));
    }

    public void setBackgroundAt(int index, Color background) {
        super.setBackgroundAt(index, background);
        this.firePropertyChange("tabPropertyChangedAtIndex", null, new Integer(index));
    }

    public void setForegroundAt(int index, Color foreground) {
        super.setForegroundAt(index, foreground);
        this.firePropertyChange("tabPropertyChangedAtIndex", null, new Integer(index));
    }

    public void setToolTipTextAt(int index, String toolTipText) {
        super.setToolTipTextAt(index, toolTipText);
        this.firePropertyChange("tabPropertyChangedAtIndex", null, new Integer(index));
    }

    public void setDisplayedMnemonicIndexAt(int tabIndex, int mnemonicIndex) {
        super.setDisplayedMnemonicIndexAt(tabIndex, mnemonicIndex);
        this.firePropertyChange("tabPropertyChangedAtIndex", null, new Integer(tabIndex));
    }

    public void setMnemonicAt(int index, int mnemonic) {
        super.setMnemonicAt(index, mnemonic);
        this.firePropertyChange("tabPropertyChangedAtIndex", null, new Integer(index));
    }

    public void setDisabledIconAt(int index, Icon disabledIcon) {
        super.setDisabledIconAt(index, disabledIcon);
        this.firePropertyChange("tabPropertyChangedAtIndex", null, new Integer(index));
    }

    public void setEnabledAt(int index, boolean enabled) {
        super.setEnabledAt(index, enabled);
        this.firePropertyChange("tabPropertyChangedAtIndex", null, new Integer(index));
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (index != -1) {
            super.addImpl(comp, constraints, index);
        } else {
            int pageIndex = this.indexOfComponent(comp);
            if (pageIndex == -1) {
                super.addImpl(comp, constraints, index);
            } else {
                super.addImpl(comp, constraints, pageIndex * 2);
            }
        }
    }

    protected void removeExtendedPage(int index) {
        Component component = this.getComponentAt(index);
        this.extendedPages.remove(component);
    }

    protected ExtendedPage getExtendedPage(int index) {
        this.checkIndex(index);
        Component component = this.getComponentAt(index);
        ExtendedPage page = (ExtendedPage)this.extendedPages.get(component);
        if (page == null) {
            page = new ExtendedPage();
            page.component = component;
            this.extendedPages.put(component, page);
        }
        return page;
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.getTabCount()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Tab count: " + this.getTabCount());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        LookAndFeelAddons.contribute(new JOutlookBarAddon());
    }

    private class ExtendedPage {
        Component component;
        int alignment = UIManager.getInt("OutlookBar.tabAlignment");

        private ExtendedPage() {
        }

        public void setTabAlignment(int alignment) {
            if (this.alignment != alignment) {
                this.alignment = alignment;
                JOutlookBar.this.firePropertyChange("tabPropertyChangedAtIndex", null, new Integer(this.getIndex()));
            }
        }

        public int getIndex() {
            return JOutlookBar.this.indexOfComponent(this.component);
        }

        public int getTabAlignment() {
            return this.alignment;
        }
    }
}

