/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.game;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Random;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.comedia.game.CHighScores;

public class CTetris
extends JComponent
implements Runnable,
KeyListener,
MouseListener {
    private static final int DEFAULT_INSET_SIZE = 10;
    private static final int DEFAULT_X_CELL_NUMBER = 11;
    private static final int DEFAULT_Y_CELL_NUMBER = 20;
    private static final Color DEFAULT_BACK_COLOR = Color.lightGray;
    private static final int SPEEDUP = 50;
    private static final int MIN_DELAY = 200;
    private static final int MAX_DELAY = 1000;
    private int xCellNum = 11;
    private int yCellNum = 20;
    private int xInset;
    private int yInset;
    private int mapWidth;
    private int mapHeight;
    private int cellSide;
    private int scoreWidth;
    private CTetrisMap map = null;
    private int score = 0;
    private int figureCount = 0;
    private int lineCount = 0;
    private int delay = 1000;
    private Random random = new Random();
    private CFigure nextFigure = null;
    private CFigure currentFigure = null;
    private Thread thread = null;
    private boolean flick = true;
    private String message = "GAME OVER";
    private boolean active = false;
    private boolean over = true;
    protected CHighScores highScores = new CHighScores();

    public CTetris() {
        this.setRequestFocusEnabled(true);
        this.setOpaque(false);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.map = new CTetrisMap();
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(this.delay);
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean bl = this.flick = !this.flick;
            if (this.active && !this.over) {
                this.stepDown();
                continue;
            }
            if (this.message.length() <= 0 || !this.flick) continue;
            this.repaint();
        }
    }

    synchronized void stepDown() {
        if (this.currentFigure == null) {
            return;
        }
        CFigure cFigure = new CFigure(this.currentFigure);
        cFigure.moveDown();
        if (!this.map.checkFit(cFigure)) {
            this.dropDown();
        } else {
            this.currentFigure = cFigure;
        }
        this.repaint();
    }

    void switchFigure() {
        if (this.nextFigure == null) {
            this.nextFigure = new CFigure(this.xCellNum / 2 - 1, 0);
            this.currentFigure = new CFigure(this.xCellNum / 2 - 1, 0);
        } else {
            this.currentFigure = this.nextFigure;
            this.nextFigure = new CFigure(this.xCellNum / 2 - 1, 0);
        }
        if (!this.map.checkFit(this.currentFigure)) {
            this.currentFigure = null;
            this.gameOver();
        }
    }

    public void startNewGame() {
        this.map = new CTetrisMap();
        this.figureCount = 0;
        this.lineCount = 0;
        this.score = 0;
        this.delay = 1000;
        this.active = true;
        this.over = false;
        this.message = "";
        this.nextFigure = null;
        this.switchFigure();
        this.repaint();
    }

    synchronized void dropDown() {
        do {
            this.currentFigure.moveDown();
        } while (this.map.checkFit(this.currentFigure));
        this.currentFigure.moveUp();
        this.map.addFigure(this.currentFigure);
        ++this.figureCount;
        int n = this.map.checkMap();
        this.lineCount += n;
        if (this.delay > 200) {
            this.delay -= 50 * n;
        }
        if (this.delay < 200) {
            this.delay = 200;
        }
        this.score = this.lineCount * 50 + this.figureCount;
        this.switchFigure();
        this.repaint();
        if (!this.map.checkFit(this.currentFigure)) {
            this.gameOver();
        }
    }

    public void gameOver() {
        this.active = false;
        this.over = true;
        this.message = "GAME OVER";
        this.repaint();
        if (this.highScores.getMinimumScore() >= this.score && this.highScores.isFull()) {
            JOptionPane.showMessageDialog(null, "Your score is " + this.score, "Game Over", 1);
        } else {
            String string = JOptionPane.showInputDialog(null, "Congratulations!\nYou have reached " + this.score + " score", "Enter you name", 1);
            if (string != null) {
                this.highScores.addScore(string.trim(), this.score);
            }
        }
        this.startNewGame();
    }

    private void drawNextFigure(Graphics graphics, int n, int n2) {
        if (this.nextFigure != null) {
            this.nextFigure.draw(graphics, n, n2);
        }
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        Font font = this.findFont(graphics, "Score: 00000", this.scoreWidth, this.cellSide);
        graphics.setFont(font);
        int n3 = this.xInset + this.mapWidth + 10;
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        int n4 = fontMetrics.getHeight() - fontMetrics.getDescent() * 2;
        this.map.drawMap(graphics);
        graphics.setColor(Color.black);
        graphics.drawRect(this.xInset, this.yInset - 1, this.mapWidth + 1, this.mapHeight + 1);
        if (this.currentFigure != null) {
            this.currentFigure.draw(graphics, this.currentFigure.column * this.cellSide + this.xInset, this.currentFigure.row * this.cellSide + this.yInset);
        }
        if (this.message.length() > 0) {
            n2 = (this.mapWidth - fontMetrics.stringWidth(this.message)) / 2;
            n = (this.mapHeight - n4) / 2;
            font = new Font(graphics.getFont().getName(), 1, graphics.getFont().getSize());
            graphics.setColor(Color.white);
            graphics.drawString(this.message, this.xInset + n2 + 1, this.yInset + n + 1);
            graphics.setColor(Color.black);
            graphics.drawString(this.message, this.xInset + n2, this.yInset + n);
        }
        this.drawNextFigure(graphics, n3, this.yInset + n4 * 4);
        graphics.setColor(Color.black);
        graphics.drawString("Score: " + this.score, n3, this.yInset + n4);
        graphics.drawString("Next:", n3, this.yInset + n4 * 3);
        n2 = this.yInset + n4 * 10;
        graphics.drawString("High scores:", n3, n2);
        n2 += n4 / 2;
        n = 0;
        while (n < this.highScores.getLength()) {
            graphics.drawString(this.highScores.formatScore(n, 5), n3, n2 += n4);
            ++n;
        }
    }

    private Font findFont(Graphics graphics, String string, int n, int n2) {
        FontMetrics fontMetrics;
        int n3 = 6;
        Font font = new Font(this.getFont().getName(), this.getFont().getStyle(), n3);
        while ((fontMetrics = graphics.getFontMetrics(font)).getHeight() <= n2 && fontMetrics.stringWidth(string) <= n) {
            font = new Font(this.getFont().getName(), this.getFont().getStyle(), ++n3);
        }
        return font;
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        Dimension dimension2 = new Dimension((int)((double)dimension.width * 0.7), dimension.height);
        Dimension dimension3 = new Dimension((int)((double)dimension.width * 0.3), dimension.height);
        this.xInset = 10;
        this.mapWidth = dimension2.width - this.xInset * 2;
        this.yInset = 10;
        this.mapHeight = dimension2.height - this.yInset * 2;
        this.scoreWidth = dimension3.width - this.xInset;
        if (this.mapHeight > this.mapWidth / this.xCellNum * this.yCellNum) {
            this.cellSide = this.mapWidth / this.xCellNum;
            this.mapWidth = this.cellSide * this.xCellNum;
            this.mapHeight = this.cellSide * this.yCellNum;
            this.yInset = (dimension2.height - this.mapHeight) / 2;
        } else {
            this.cellSide = this.mapHeight / this.yCellNum;
            this.mapWidth = this.cellSide * this.xCellNum;
            this.mapHeight = this.cellSide * this.yCellNum;
            this.xInset = (dimension2.width - this.mapWidth) / 2;
        }
        this.repaint();
    }

    public void start() {
        this.active = true;
    }

    public void stop() {
        this.active = false;
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        CFigure cFigure = new CFigure(this.currentFigure);
        if (keyEvent.getKeyCode() == 19) {
            this.active = !this.active;
            this.message = this.active ? "" : "PAUSED";
            this.repaint();
            return;
        }
        if (this.active && !this.over) {
            switch (keyEvent.getKeyCode()) {
                case 37: {
                    cFigure.moveLeft();
                    break;
                }
                case 39: {
                    cFigure.moveRight();
                    break;
                }
                case 40: {
                    this.stepDown();
                    return;
                }
                case 38: {
                    cFigure.rotate();
                    break;
                }
                case 32: {
                    this.dropDown();
                    return;
                }
                default: {
                    return;
                }
            }
            if (this.map.checkFit(cFigure)) {
                this.currentFigure = cFigure;
            }
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    void drawBox(Graphics graphics, Color color, int n, int n2) {
        int n3 = n + this.cellSide - 1;
        int n4 = n2 + this.cellSide - 1;
        if (color == DEFAULT_BACK_COLOR) {
            graphics.setColor(DEFAULT_BACK_COLOR);
            graphics.fillRect(n, n2, this.cellSide, this.cellSide);
            graphics.setColor(Color.gray);
            graphics.drawLine(n, n2, n, n4);
        } else {
            graphics.setColor(color);
            graphics.fillRect(n, n2, this.cellSide, this.cellSide);
            graphics.setColor(Color.black);
            graphics.drawLine(n, n4, n3, n4);
            graphics.drawLine(n3, n2, n3, n4);
            graphics.setColor(Color.white);
            graphics.drawLine(n, n2, n3, n2);
            graphics.drawLine(n, n2, n, n4);
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Tetris");
        CTetris cTetris = new CTetris();
        jFrame.getContentPane().add((Component)cTetris, "Center");
        ((Component)jFrame).setSize(300, 500);
        ((Component)jFrame).setLocation(300, 100);
        jFrame.setDefaultCloseOperation(3);
        jFrame.show();
        cTetris.requestFocus();
        cTetris.startNewGame();
    }

    protected class CHiScore {
        public String player = "";
        public int score = 0;

        protected CHiScore() {
        }
    }

    private class CTetrisMap {
        Color[][] cells = null;

        public CTetrisMap() {
            this.cells = new Color[CTetris.this.yCellNum][CTetris.this.xCellNum];
            this.clear();
        }

        public void clear() {
            int n = 0;
            while (n < CTetris.this.yCellNum) {
                int n2 = 0;
                while (n2 < CTetris.this.xCellNum) {
                    this.cells[n][n2] = DEFAULT_BACK_COLOR;
                    ++n2;
                }
                ++n;
            }
        }

        public void drawMap(Graphics graphics) {
            int n = CTetris.this.xInset;
            int n2 = CTetris.this.yInset;
            int n3 = 0;
            while (n3 < CTetris.this.yCellNum) {
                int n4 = 0;
                while (n4 < CTetris.this.xCellNum) {
                    CTetris.this.drawBox(graphics, this.cells[n3][n4], n, n2);
                    n += CTetris.this.cellSide;
                    ++n4;
                }
                n2 += CTetris.this.cellSide;
                n = CTetris.this.xInset;
                ++n3;
            }
        }

        public boolean checkFit(CFigure cFigure) {
            char c;
            String string = cFigure.figureShapes[cFigure.currentShape];
            int n = 0;
            int n2 = cFigure.column;
            int n3 = cFigure.row;
            while ((c = string.charAt(n++)) != '.') {
                if (c == '@' && (n2 < 0 || n3 < 0 || n2 >= CTetris.this.xCellNum || n3 >= CTetris.this.yCellNum || this.cells[n3][n2] != DEFAULT_BACK_COLOR)) {
                    return false;
                }
                ++n2;
                if (c != '|') continue;
                ++n3;
                n2 = cFigure.column;
            }
            return true;
        }

        private void removeRow(int n) {
            do {
                System.arraycopy(this.cells[n - 1], 0, this.cells[n], 0, this.cells[n - 1].length);
            } while (--n > 0);
        }

        public int checkMap() {
            int n = 1;
            int n2 = 0;
            do {
                int n3 = 0;
                while (n3 < CTetris.this.xCellNum) {
                    if (this.cells[n][n3] == DEFAULT_BACK_COLOR) break;
                    ++n3;
                }
                if (n3 != CTetris.this.xCellNum) continue;
                this.removeRow(n);
                ++n2;
            } while (++n < CTetris.this.yCellNum);
            return n2;
        }

        public void addFigure(CFigure cFigure) {
            char c;
            String string = cFigure.figureShapes[cFigure.currentShape];
            int n = 0;
            int n2 = cFigure.column;
            int n3 = cFigure.row;
            while ((c = string.charAt(n++)) != '.') {
                if (c == '@') {
                    this.cells[n3][n2] = cFigure.figureColor;
                }
                ++n2;
                if (c != '|') continue;
                ++n3;
                n2 = cFigure.column;
            }
        }
    }

    private class CFigure {
        String[] figureShapes = new String[]{"@@@|@.", "@@| @| @.", "  @|@@@.", "@ |@ |@@.", "@@@|  @.", " @| @|@@.", "@  |@@@.", "@@|@ |@.", "@@ | @@.", " @|@@|@.", " @@|@@.", "@ |@@| @.", "@@@@.", "@|@|@|@.", "@@@| @.", " @|@@| @.", " @ |@@@.", "@ |@@|@.", "@@|@@.", "@@@|@  |@@@.", "@@@|@ @|@ @.", "@@@|  @|@@@.", "@ @|@ @|@@@.", "@ @|@ @|@@@.", "@@@|@  |@@@.", "@@@|@ @|@ @.", "@@@|  @|@@@.", "@@|@@|@ @.", "@@@| @@|@.", "@ @| @@| @@.", "  @|@@|@@@.", "@@@|@@|@@@.", "@@@|@@@|@ @.", "@@@| @@|@@@.", "@ @|@@@|@@@."};
        int[] baseShapes = new int[]{0, 4, 8, 10, 12, 14, 18, 19, 23, 27, 31};
        int[] maxShapes = new int[]{3, 7, 9, 11, 13, 17, 18, 22, 26, 30, 34};
        Color[] figureColors = new Color[]{Color.green, Color.blue, Color.cyan, Color.orange, Color.pink, Color.yellow, Color.magenta, Color.red, Color.red, Color.red, Color.red};
        int baseShape;
        int maxShape;
        int currentShape;
        int figureIndex;
        int row;
        int column;
        Color figureColor;

        public void draw(Graphics graphics, int n, int n2) {
            char c;
            String string = this.figureShapes[this.currentShape];
            int n3 = 0;
            int n4 = n;
            while ((c = string.charAt(n3++)) != '.') {
                if (c == '@') {
                    CTetris.this.drawBox(graphics, this.figureColor, n, n2);
                }
                n += CTetris.this.cellSide;
                if (c != '|') continue;
                n2 += CTetris.this.cellSide;
                n = n4;
            }
        }

        public CFigure(int n, int n2, int n3) {
            this.column = n;
            this.row = n2;
            this.figureIndex = n3;
            this.baseShape = this.baseShapes[n3];
            this.maxShape = this.maxShapes[n3];
            this.currentShape = this.baseShape;
            this.figureColor = this.figureColors[n3];
        }

        public CFigure(int n, int n2) {
            this(n, n2, Math.abs(cTetris.random.nextInt()) % 7);
        }

        public CFigure(CFigure cFigure) {
            this(cFigure.column, cFigure.row, cFigure.figureIndex);
            this.currentShape = cFigure.currentShape;
        }

        void moveLeft() {
            --this.column;
        }

        void moveRight() {
            ++this.column;
        }

        void moveDown() {
            ++this.row;
        }

        void moveUp() {
            --this.row;
        }

        void rotate() {
            ++this.currentShape;
            if (this.currentShape > this.maxShape) {
                this.currentShape = this.baseShape;
            }
        }
    }
}

