/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.undo.UndoableEdit;

public class CEditor
extends JTextPane
implements UndoableEditListener {
    public ArrayList undoList = new ArrayList();
    public int undoPosition = -1;
    private boolean modified = false;

    public CEditor() {
        this.getDocument().addUndoableEditListener(this);
        Keymap keymap = JTextComponent.addKeymap("UndoMap", this.getKeymap());
        KeyStroke keyStroke = KeyStroke.getKeyStroke(90, 2, false);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(90, 3, false);
        keymap.addActionForKeyStroke(keyStroke, new UndoAction());
        keymap.addActionForKeyStroke(keyStroke2, new RedoAction());
        this.setKeymap(keymap);
    }

    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        UndoItem undoItem = new UndoItem(this.getCaretPosition(), undoableEditEvent.getEdit());
        int n = this.undoList.size() - 1;
        while (n > this.undoPosition) {
            this.undoList.remove(n);
            --n;
        }
        this.undoList.add(undoItem);
        ++this.undoPosition;
        this.modified = true;
    }

    public void discardUndo() {
        this.undoPosition = -1;
        this.undoList.clear();
        this.modified = false;
    }

    public void undo() {
        if (this.undoPosition >= 0) {
            UndoItem undoItem = (UndoItem)this.undoList.get(this.undoPosition);
            this.setCaretPosition(undoItem.position);
            undoItem.item.undo();
            --this.undoPosition;
            while (this.undoPosition >= 0) {
                UndoItem undoItem2 = (UndoItem)this.undoList.get(this.undoPosition);
                if (!undoItem2.item.getPresentationName().equals(undoItem.item.getPresentationName()) || (!undoItem2.item.getPresentationName().startsWith("add") || undoItem.position - undoItem2.position != 1) && (!undoItem2.item.getPresentationName().startsWith("del") || undoItem2.position - undoItem.position != 1)) break;
                undoItem = undoItem2;
                undoItem.item.undo();
                --this.undoPosition;
            }
        }
        this.modified = this.undoPosition >= 0;
    }

    public void redo() {
        if (this.undoPosition + 1 < this.undoList.size()) {
            ++this.undoPosition;
            UndoItem undoItem = (UndoItem)this.undoList.get(this.undoPosition);
            undoItem.item.redo();
            this.setCaretPosition(undoItem.position);
            while (this.undoPosition + 1 < this.undoList.size()) {
                UndoItem undoItem2 = (UndoItem)this.undoList.get(this.undoPosition + 1);
                if (!undoItem2.item.getPresentationName().equals(undoItem.item.getPresentationName()) || (!undoItem2.item.getPresentationName().startsWith("add") || undoItem2.position - undoItem.position != 1) && (!undoItem2.item.getPresentationName().startsWith("del") || undoItem.position - undoItem2.position != 1)) break;
                undoItem = undoItem2;
                undoItem.item.redo();
                ++this.undoPosition;
            }
        }
        this.modified = this.undoPosition >= 0;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean bl) {
        this.modified = bl;
    }

    public void read(Reader reader, Object object) throws IOException {
        this.discardUndo();
        super.read(reader, object);
        this.getDocument().addUndoableEditListener(this);
    }

    public void write(Writer writer) throws IOException {
        super.write(writer);
        this.discardUndo();
        this.getDocument().addUndoableEditListener(this);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Comedia Editor Test");
        CEditor cEditor = new CEditor();
        cEditor.setText("xxxxxxxxxxxxxxxx xxxxxxxxxxxxxxxxxx xxxxxxxxxxxxxxx xxxxxxxxxx");
        JScrollPane jScrollPane = new JScrollPane(cEditor);
        jFrame.getContentPane().add((Component)jScrollPane, "Center");
        ((Component)jFrame).setLocation(100, 100);
        ((Component)jFrame).setSize(300, 300);
        jFrame.setDefaultCloseOperation(3);
        jFrame.show();
    }

    private class RedoAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            CEditor.this.redo();
        }
    }

    private class UndoAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            CEditor.this.undo();
        }
    }

    private class UndoItem {
        public int position;
        public UndoableEdit item;

        public UndoItem(int n, UndoableEdit undoableEdit) {
            this.position = n;
            this.item = undoableEdit;
        }
    }
}

