/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;

public class COutlookBar
extends JComponent
implements ActionListener {
    private ArrayList items = new ArrayList();
    private int currentIndex = -1;
    private int animationSpeed = 20;

    public COutlookBar() {
        this.setLayout(new BorderLayout());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            int n = this.getPanelIndex(((JButton)actionEvent.getSource()).getText());
            if (this.currentIndex >= 0 && this.currentIndex != n) {
                this.sweepBar(n);
            }
        }
    }

    public int getAnimationSpeed() {
        return this.animationSpeed;
    }

    public void setAnimationSpeed(int n) {
        this.animationSpeed = n;
    }

    public int getSelectedIndex() {
        return this.currentIndex;
    }

    public void setSelectedIndex(int n) {
        if (this.currentIndex != n) {
            this.currentIndex = n;
            this.updateContent();
        }
    }

    public int getPanelIndex(String string) {
        int n = 0;
        while (n < this.items.size()) {
            COutlookBarItem cOutlookBarItem = (COutlookBarItem)this.items.get(n);
            if (cOutlookBarItem.getButton().getText().equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getPanelIndex(Component component) {
        int n = 0;
        while (n < this.items.size()) {
            COutlookBarItem cOutlookBarItem = (COutlookBarItem)this.items.get(n);
            if (cOutlookBarItem.getComponent() == component) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getPanelCount() {
        return this.items.size();
    }

    public Component getPanel(int n) {
        return ((COutlookBarItem)this.items.get(n)).getComponent();
    }

    public Component getPanel(String string) {
        int n = 0;
        while (n < this.items.size()) {
            COutlookBarItem cOutlookBarItem = (COutlookBarItem)this.items.get(n);
            if (cOutlookBarItem.getButton().getText().equals(string)) {
                return cOutlookBarItem.getComponent();
            }
            ++n;
        }
        return null;
    }

    public String getPanelTitle(int n) {
        return ((COutlookBarItem)this.items.get(n)).getButton().getText();
    }

    public Component addPanel(String string) {
        return this.addPanel(string, new JPanel());
    }

    public Component addPanel(String string, Component component) {
        COutlookBarItem cOutlookBarItem = new COutlookBarItem(string, component);
        this.items.add(cOutlookBarItem);
        cOutlookBarItem.getButton().addActionListener(this);
        if (this.currentIndex < 0) {
            this.currentIndex = 0;
        }
        this.updateContent();
        return component;
    }

    public void removePanel(int n) {
        if (this.currentIndex >= n) {
            --this.currentIndex;
        }
        if (this.currentIndex < 0 && this.items.size() > 0) {
            this.currentIndex = 0;
        }
        this.items.remove(n);
        this.updateContent();
    }

    public void removePanel(String string) {
        this.removePanel(this.getPanelIndex(string));
    }

    public void removePanel(Component component) {
        this.removePanel(this.getPanelIndex(component));
    }

    private void updateContent() {
        super.removeAll();
        if (this.items.size() >= 0 && this.currentIndex >= 0 && this.currentIndex < this.items.size()) {
            JPanel jPanel = null;
            JPanel jPanel2 = null;
            int n = this.currentIndex + 1;
            int n2 = this.items.size() - n;
            if (n > 0) {
                jPanel = new JPanel();
                jPanel.setLayout(new GridLayout(n, 1));
                super.add((Component)jPanel, "North");
            } else {
                jPanel = null;
            }
            if (n2 > 0) {
                jPanel2 = new JPanel();
                jPanel2.setLayout(new GridLayout(n2, 1));
                super.add((Component)jPanel2, "South");
            }
            super.add(((COutlookBarItem)this.items.get(this.currentIndex)).getComponent(), "Center");
            int n3 = 0;
            while (n3 < this.items.size()) {
                COutlookBarItem cOutlookBarItem = (COutlookBarItem)this.items.get(n3);
                if (n3 <= this.currentIndex) {
                    jPanel.add(cOutlookBarItem.getButton());
                } else {
                    jPanel2.add(cOutlookBarItem.getButton());
                }
                ++n3;
            }
        }
        this.revalidate();
        this.repaint();
    }

    public void updateUI() {
        int n = 0;
        while (n < this.items.size()) {
            COutlookBarItem cOutlookBarItem = (COutlookBarItem)this.items.get(n);
            SwingUtilities.updateComponentTreeUI(cOutlookBarItem.getButton());
            if (cOutlookBarItem.getComponent() instanceof JComponent) {
                SwingUtilities.updateComponentTreeUI((JComponent)cOutlookBarItem.getComponent());
            }
            ++n;
        }
        super.updateUI();
    }

    private void sweepBar(int n) {
        Component component;
        Object object;
        super.removeAll();
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        int n2 = 0;
        while (n2 < this.items.size()) {
            object = (COutlookBarItem)this.items.get(n2);
            component = new JButton(((COutlookBarItem)object).getButton().getText());
            if (n2 <= n && n2 <= this.currentIndex) {
                jPanel.add(component);
            } else if (n2 > n && n2 > this.currentIndex) {
                jPanel3.add(component);
            } else {
                jPanel2.add(component);
            }
            ++n2;
        }
        if (jPanel.getComponentCount() > 0) {
            jPanel.setLayout(new GridLayout(jPanel.getComponentCount(), 1));
            super.add((Component)jPanel, "North");
        }
        if (jPanel3.getComponentCount() > 0) {
            jPanel3.setLayout(new GridLayout(jPanel3.getComponentCount(), 1));
            super.add((Component)jPanel3, "South");
        }
        if (jPanel2.getComponentCount() > 0) {
            jPanel2.setLayout(new GridLayout(jPanel2.getComponentCount(), 1));
        }
        object = ((COutlookBarItem)this.items.get(this.currentIndex)).getComponent();
        component = ((COutlookBarItem)this.items.get(n)).getComponent();
        CSweepPanel cSweepPanel = new CSweepPanel();
        cSweepPanel.reset((Component)object, component, jPanel2, this.currentIndex - n);
        super.add((Component)cSweepPanel, "Center");
        this.revalidate();
        this.repaint();
        this.currentIndex = n;
        CSweepThread cSweepThread = new CSweepThread(cSweepPanel);
        try {
            cSweepThread.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
        COutlookBar cOutlookBar = new COutlookBar();
        cOutlookBar.setAnimationSpeed(50);
        cOutlookBar.addPanel("Panel", new JPanel());
        cOutlookBar.addPanel("Button", new JButton("xxx"));
        cOutlookBar.addPanel("Label", new JLabel("xxx"));
        cOutlookBar.addPanel("Text", new JTextPane());
        cOutlookBar.addPanel("Auto Panel");
        cOutlookBar.removePanel(0);
        JFrame jFrame = new JFrame("Outlook Bar");
        jFrame.getContentPane().add(cOutlookBar);
        ((Component)jFrame).setSize(305, 320);
        ((Component)jFrame).setLocation(200, 200);
        jFrame.setDefaultCloseOperation(3);
        jFrame.show();
    }

    private class COutlookBarItem {
        private JButton button = null;
        private Component component = null;

        public COutlookBarItem(String string, Component component) {
            this.button = new JButton(string);
            this.component = component;
        }

        public JButton getButton() {
            return this.button;
        }

        public Component getComponent() {
            return this.component;
        }
    }

    private class CSweepThread
    extends Thread {
        private CSweepPanel sweep = null;

        public CSweepThread(CSweepPanel cSweepPanel) {
            this.sweep = cSweepPanel;
        }

        public void run() {
            while (this.sweep.step(20)) {
                this.sweep.revalidate();
                this.sweep.repaint();
                try {
                    Thread.sleep(COutlookBar.this.animationSpeed);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            COutlookBar.this.updateContent();
        }
    }

    private class CSweepPanel
    extends JPanel {
        private int y = 0;
        private int dir = 0;
        private JPanel topPanel = new JPanel();
        private JPanel centerPanel = new JPanel();
        private JPanel bottomPanel = new JPanel();
        private JPanel movePanel = new JPanel();

        public CSweepPanel() {
            this.setLayout(new BorderLayout());
            this.movePanel.setLayout(new BorderLayout());
            this.topPanel.setLayout(new BorderLayout());
            this.centerPanel.setLayout(new BorderLayout());
            this.bottomPanel.setLayout(new BorderLayout());
        }

        public void reset(Component component, Component component2, Component component3, int n) {
            this.y = 0;
            this.dir = n;
            this.removeAll();
            this.topPanel.removeAll();
            this.bottomPanel.removeAll();
            this.centerPanel.removeAll();
            this.centerPanel.add(component3);
            if (n >= 0) {
                this.topPanel.add(component2);
                this.bottomPanel.add(component);
                this.movePanel.add((Component)this.topPanel, "Center");
                this.movePanel.add((Component)this.centerPanel, "South");
                this.add((Component)this.movePanel, "North");
                this.add((Component)this.bottomPanel, "Center");
            } else {
                this.topPanel.add(component);
                this.bottomPanel.add(component2);
                this.movePanel.add((Component)this.bottomPanel, "Center");
                this.movePanel.add((Component)this.centerPanel, "North");
                this.add((Component)this.movePanel, "South");
                this.add((Component)this.topPanel, "Center");
            }
            this.topPanel.setPreferredSize(new Dimension(0, 0));
            this.bottomPanel.setPreferredSize(new Dimension(0, 0));
        }

        public boolean step(int n) {
            this.y += n;
            if (this.dir >= 0) {
                this.topPanel.setPreferredSize(new Dimension(0, this.y));
            } else {
                this.bottomPanel.setPreferredSize(new Dimension(0, this.y));
            }
            int n2 = this.getSize().height - this.centerPanel.getPreferredSize().height;
            return this.y + n < n2 && n2 != 0;
        }
    }
}

