/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.application.core;

import com.l2fprod.common.application.core.ActionManager;
import com.l2fprod.common.application.core.AppContext;
import com.l2fprod.common.application.core.CommandContext;
import com.l2fprod.common.application.core.SelectionManager;
import com.l2fprod.common.application.core.UpdateableAction;
import com.l2fprod.common.application.selection.EmptySelection;
import com.l2fprod.common.application.selection.Selection;
import com.l2fprod.common.application.selection.SelectionChangedEvent;
import com.l2fprod.common.application.selection.SelectionListener;
import com.l2fprod.common.application.selection.SelectionProvider;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.event.EventListenerList;

public class DefaultAppContext
implements AppContext,
SelectionManager,
ActionManager,
CommandContext,
SelectionListener {
    private EventListenerList selectionListeners;
    private OnFocusChangeUpdater focusUpdater;
    private Component focusOwner;
    private SelectionProvider selectionProvider;
    private Selection selection;
    private List actions = new ArrayList();
    private Map services = new Hashtable();
    static /* synthetic */ Class class$com$l2fprod$common$application$selection$SelectionListener;

    public DefaultAppContext() {
        this.selectionProvider = SelectionProvider.NULL_PROVIDER;
        this.setSelection(null);
        this.selectionListeners = new EventListenerList();
        this.focusUpdater = new OnFocusChangeUpdater();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this.focusUpdater);
    }

    public ActionManager getActions() {
        return this;
    }

    public SelectionManager getSelectionManager() {
        return this;
    }

    public Object getService(Object key) {
        return this.services.get(key);
    }

    public void registerService(Object key, Object value) {
        this.services.put(key, value);
    }

    public Selection getSelection() {
        return this.selection;
    }

    private void setSelection(Selection selection) {
        this.selection = selection == null ? new EmptySelection() : selection;
    }

    public Component getFocusOwner() {
        return this.focusOwner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Action action) {
        List list = this.actions;
        synchronized (list) {
            this.actions.add(action);
        }
        action.putValue("commandContext", this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Action action) {
        List list = this.actions;
        synchronized (list) {
            this.actions.remove(action);
        }
        action.putValue("commandContext", null);
    }

    public Action get(String actionId) {
        Iterator iter = this.actions.iterator();
        while (iter.hasNext()) {
            Action a = (Action)iter.next();
            if (!actionId.equals(a.getValue("id"))) continue;
            return a;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateActions() {
        Object[] currentActions;
        List list = this.actions;
        synchronized (list) {
            currentActions = this.actions.toArray();
        }
        int c = currentActions.length;
        for (int i = 0; i < c; ++i) {
            Action action = (Action)currentActions[i];
            if (!(action instanceof UpdateableAction)) continue;
            ((UpdateableAction)action).update(this);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setSelection(this.selectionProvider.getSelection());
        this.updateActions();
        this.fireSelectionChanged(event);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.selectionListeners.add(class$com$l2fprod$common$application$selection$SelectionListener == null ? (class$com$l2fprod$common$application$selection$SelectionListener = DefaultAppContext.class$("com.l2fprod.common.application.selection.SelectionListener")) : class$com$l2fprod$common$application$selection$SelectionListener, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.selectionListeners.remove(class$com$l2fprod$common$application$selection$SelectionListener == null ? (class$com$l2fprod$common$application$selection$SelectionListener = DefaultAppContext.class$("com.l2fprod.common.application.selection.SelectionListener")) : class$com$l2fprod$common$application$selection$SelectionListener, listener);
    }

    private void fireSelectionChanged(SelectionChangedEvent event) {
        SelectionListener[] l = (SelectionListener[])this.selectionListeners.getListeners(class$com$l2fprod$common$application$selection$SelectionListener == null ? (class$com$l2fprod$common$application$selection$SelectionListener = DefaultAppContext.class$("com.l2fprod.common.application.selection.SelectionListener")) : class$com$l2fprod$common$application$selection$SelectionListener);
        int c = l.length;
        for (int i = 0; i < c; ++i) {
            l[i].selectionChanged(event);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class OnFocusChangeUpdater
    implements PropertyChangeListener {
        OnFocusChangeUpdater() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Component newFocusOwner = (Component)evt.getNewValue();
            SelectionProvider newSelectionProvider = SelectionProvider.Helper.findSelectionProvider(newFocusOwner);
            if (newSelectionProvider != null) {
                DefaultAppContext.this.selectionProvider.removeSelectionListener(DefaultAppContext.this);
                newSelectionProvider.addSelectionListener(DefaultAppContext.this);
                DefaultAppContext.this.selectionProvider = newSelectionProvider;
            }
            DefaultAppContext.this.focusOwner = newFocusOwner;
            DefaultAppContext.this.setSelection(DefaultAppContext.this.selectionProvider.getSelection());
            DefaultAppContext.this.updateActions();
        }
    }
}

