/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.application.document;

import com.l2fprod.common.application.document.Workspace;
import com.l2fprod.common.application.document.WorkspaceDocument;
import com.l2fprod.common.application.document.WorkspaceDocumentAdapter;
import com.l2fprod.common.application.document.WorkspaceDocumentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;

public class AbstractWorkspace
implements Workspace {
    private List documents = new ArrayList();
    private WorkspaceDocument selected;
    private WorkspaceDocumentListener documentListener = new DocumentListener();
    private PropertyChangeListener changeListener = new ChangeListener();

    public void setSelected(WorkspaceDocument document) throws PropertyVetoException {
        if (document == null) {
            return;
        }
        if (document.getWorkspace() != this) {
            throw new IllegalArgumentException("document not opened in this workspace");
        }
        WorkspaceDocument oldSelected = this.selected;
        if (oldSelected != null) {
            oldSelected.setSelected(false);
            this.selected = null;
        }
        document.setSelected(true);
        this.selected = document;
    }

    public final WorkspaceDocument getSelected() {
        return this.selected;
    }

    public final WorkspaceDocument[] getDocuments() {
        return this.documents.toArray(new WorkspaceDocument[0]);
    }

    public final void open(WorkspaceDocument document) {
        document.setWorkspace(this);
        document.addDocumentListener(this.documentListener);
        document.addPropertyChangeListener(this.changeListener);
        try {
            document.setClosed(false);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
    }

    protected void documentOpened(WorkspaceDocument document) {
    }

    protected void documentChanged(WorkspaceDocument document, PropertyChangeEvent event) {
    }

    protected void documentClosed(WorkspaceDocument document) {
    }

    public void close(WorkspaceDocument document) throws PropertyVetoException {
        if (document == null) {
            return;
        }
        if (document.getWorkspace() != this) {
            throw new IllegalArgumentException("document not opened in this workspace");
        }
        document.setClosed(true);
    }

    public void save(WorkspaceDocument document) {
        if (document == null) {
            return;
        }
        if (document.getWorkspace() != this) {
            throw new IllegalArgumentException("document not opened in this workspace");
        }
        document.save();
    }

    class ChangeListener
    implements PropertyChangeListener {
        ChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("closed".equals(evt.getPropertyName()) && Boolean.TRUE.equals(evt.getNewValue())) {
                ((WorkspaceDocument)evt.getSource()).removePropertyChangeListener(this);
            } else {
                if ("selected".equals(evt.getPropertyName()) && Boolean.TRUE.equals(evt.getNewValue())) {
                    try {
                        AbstractWorkspace.this.setSelected((WorkspaceDocument)evt.getSource());
                    }
                    catch (PropertyVetoException e) {
                        e.printStackTrace();
                    }
                }
                AbstractWorkspace.this.documentChanged((WorkspaceDocument)evt.getSource(), evt);
            }
        }
    }

    class DocumentListener
    extends WorkspaceDocumentAdapter {
        DocumentListener() {
        }

        public void documentOpened(WorkspaceDocument document) {
            AbstractWorkspace.this.documents.add(document);
            AbstractWorkspace.this.documentOpened(document);
        }

        public void documentClosed(WorkspaceDocument document) {
            document.removeDocumentListener(this);
            AbstractWorkspace.this.documents.remove(document);
            AbstractWorkspace.this.documentClosed(document);
        }
    }
}

