/*
 * Decompiled with CFR 0.152.
 */
package electric.xml;

import electric.xml.Node;
import java.io.IOException;
import java.io.Writer;

public class NodeWriter {
    protected static int defaultStep = 2;
    protected static String defaultEOL = "\r\n";
    protected Writer writer;
    protected int indent;
    protected int step;
    protected boolean expandEmptyElements;
    protected String eol;

    public NodeWriter(Writer writer) {
        this(writer, 0, false, defaultStep, defaultEOL);
    }

    public NodeWriter(Writer writer, int n, boolean bl) {
        this(writer, n, bl, defaultStep, defaultEOL);
    }

    public NodeWriter(Writer writer, int n, boolean bl, int n2, String string) {
        this.writer = writer;
        this.indent = n;
        this.expandEmptyElements = bl;
        this.step = n2;
        this.eol = string;
    }

    public int getIndent() {
        return this.indent;
    }

    public void setIndent(int n) {
        this.indent = n;
    }

    public void increaseIndent() {
        this.indent += this.step;
    }

    public void decreaseIndent() {
        this.indent -= this.step;
    }

    public static void setDefaultStep(int n) {
        defaultStep = n;
    }

    public static int getDefaultStep() {
        return defaultStep;
    }

    public String getEOL() {
        return this.eol;
    }

    public void setEOL(String string) {
        this.eol = string;
    }

    public static void setDefaultEOL(String string) {
        defaultEOL = string;
    }

    public static String getDefaultEOL() {
        return defaultEOL;
    }

    public boolean getExpandEmptyElements() {
        return this.expandEmptyElements;
    }

    public void setExpandEmptyElements(boolean bl) {
        this.expandEmptyElements = bl;
    }

    public void write(Node node) throws IOException {
        node.write(this);
    }

    public void write(String string) throws IOException {
        this.writer.write(string);
    }

    public void write(char c) throws IOException {
        this.writer.write(c);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        this.writer.write(cArray, n, n2);
    }

    public void writeIndent() throws IOException {
        int n = 0;
        while (n < this.indent) {
            this.writer.write(32);
            ++n;
        }
    }

    public void writeEOL() throws IOException {
        this.writer.write(this.eol);
    }
}

