/*
 * Decompiled with CFR 0.152.
 */
package electric.xml;

import electric.util.Lex;
import electric.xml.CharacterData;
import electric.xml.Element;
import electric.xml.NodeWriter;
import electric.xml.Parent;
import java.io.IOException;

public class Text
extends CharacterData
implements org.w3c.dom.Text {
    private static final char[] specials = new char[]{'&', '<', '>', '\'', '\"'};
    private static final String[] substitutes = new String[]{"&amp;", "&lt;", "&gt;", "&apos;", "&quot;"};
    protected boolean raw;

    public Text(String string) {
        super(string);
    }

    public Text(Text text) {
        super(text.string);
    }

    Text(Lex lex, StringBuffer stringBuffer, Element element) throws IOException {
        super(element);
        String string = lex.readToPattern("<", 72);
        this.string = stringBuffer == null ? string : stringBuffer.append(string).toString();
    }

    Text(Parent parent) {
        super(parent);
    }

    public Object clone() {
        return new Text(this);
    }

    public String getString() {
        return this.string;
    }

    public void setString(String string) {
        this.string = string;
    }

    public void setRaw(boolean bl) {
        this.raw = bl;
    }

    public boolean getRaw() {
        return this.raw;
    }

    public void write(NodeWriter nodeWriter) throws IOException {
        nodeWriter.writeIndent();
        if (this.raw) {
            nodeWriter.write(this.string);
        } else {
            Text.writeWithSubstitution(nodeWriter, this.string);
        }
    }

    private static int getSpecialIndex(char c) {
        int n = 0;
        while (n < specials.length) {
            if (specials[n] == c) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    static void writeWithSubstitution(NodeWriter nodeWriter, String string) throws IOException {
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            int n3 = Text.getSpecialIndex(cArray[n2]);
            if (n3 >= 0) {
                if (n < n2) {
                    nodeWriter.write(cArray, n, n2 - n);
                }
                nodeWriter.write(substitutes[n3]);
                n = n2 + 1;
            }
            ++n2;
        }
        if (n < cArray.length) {
            nodeWriter.write(cArray, n, cArray.length - n);
        }
    }

    public short getNodeType() {
        return 3;
    }

    public String getNodeName() {
        return "#text";
    }

    public org.w3c.dom.Text splitText(int n) {
        String string = this.string.substring(n);
        this.string = this.string.substring(0, n);
        Text text = new Text(string);
        this.setNextSiblingChild(text);
        return text;
    }
}

