/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.lib.ui.BorderFactory;
import ch.abacus.lib.ui.JAButton;
import ch.abacus.lib.ui.JALabel;
import ch.abacus.lib.ui.JAPanel;
import ch.abacus.lib.ui.JARadioGroup;
import ch.abacus.lib.ui.VerticalFlowLayout;
import ch.abacus.lib.ui.customizer.CustomizerAvailableClass;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;

public class CustomizerAlternativeClassesDialog
extends JDialog {
    private final CustomizerAvailableClass[] m_alternativeClasses;
    private String m_selectedClassName;
    private SuperDesignCockpit m_owner;

    public CustomizerAlternativeClassesDialog(SuperDesignCockpit owner, String title, CustomizerAvailableClass[] alternativeClasses) {
        super((Frame)((Object)owner), title, true);
        this.m_owner = owner;
        this.m_alternativeClasses = alternativeClasses;
        this.populateDialog();
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void populateDialog() {
        Container contentPane = this.getContentPane();
        contentPane.setLayout((LayoutManager)new VerticalFlowLayout());
        JALabel text = new JALabel(this.m_owner.theLanguageManager.getMessage("SelectAlternativeClassDialog.description", "Which component do you want to use for this Field?"));
        text.setBorder(BorderFactory.createEmptyBorder((int)10, (int)10, (int)10, (int)10));
        contentPane.add((Component)text);
        final JARadioGroup radioGroup = new JARadioGroup();
        radioGroup.setBorder(BorderFactory.createEmptyBorder((int)10, (int)50, (int)10, (int)50));
        radioGroup.setLayout((LayoutManager)new GridLayout(this.m_alternativeClasses.length, 1, 10, 10));
        for (int iClass = 0; iClass < this.m_alternativeClasses.length; ++iClass) {
            radioGroup.addRadioButton(this.m_alternativeClasses[iClass].getDisplayName());
        }
        radioGroup.setSelectedIndex(0);
        contentPane.add((Component)radioGroup);
        JAButton btnOK = new JAButton(this.m_owner.theLanguageManager.getMessage("Dialogs.OK", "OK"));
        JAPanel panel = new JAPanel();
        ((FlowLayout)panel.getLayout()).setAlignment(2);
        panel.add((Component)btnOK);
        contentPane.add((Component)panel);
        btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CustomizerAlternativeClassesDialog.this.m_selectedClassName = CustomizerAlternativeClassesDialog.this.m_alternativeClasses[radioGroup.getSelectedIndex()].getMetadataClassName();
                CustomizerAlternativeClassesDialog.this.hide();
            }
        });
    }

    public String getSelectedClassName() {
        return this.m_selectedClassName;
    }
}

